/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.excel.common;

import de.rcenvironment.components.excel.common.ExcelException;
import de.rcenvironment.components.excel.common.ExcelUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelAddress
implements Serializable {
    private static final long serialVersionUID = 169274298193312428L;
    private String fullAddress;
    private String worksheetName;
    private String firstCell;
    private String lastCell;
    private int numberOfRows;
    private int numberOfColumns;
    private int beginningRowNumber;
    private int beginningColumnNumber;
    private String userDefinedNameForAddress;

    public ExcelAddress(ExcelAddress addr) {
        this.fullAddress = addr.fullAddress;
        this.worksheetName = addr.worksheetName;
        this.firstCell = addr.firstCell;
        this.lastCell = addr.lastCell;
        this.numberOfRows = addr.numberOfRows;
        this.numberOfColumns = addr.numberOfColumns;
        this.beginningRowNumber = addr.beginningRowNumber;
        this.beginningColumnNumber = addr.beginningColumnNumber;
        this.userDefinedNameForAddress = addr.userDefinedNameForAddress;
    }

    public ExcelAddress(File excelFile, String rawAddress) throws ExcelException {
        FileInputStream inp = null;
        try {
            try {
                inp = new FileInputStream(excelFile);
                Workbook wb = WorkbookFactory.create((InputStream)inp);
                Name name = wb.getName(rawAddress);
                if (name != null) {
                    this.fullAddress = name.getRefersToFormula();
                    this.fullAddress = StringUtils.remove((String)this.fullAddress, (String)"$");
                    this.userDefinedNameForAddress = name.getNameName();
                    this.worksheetName = name.getSheetName();
                    this.worksheetName = ExcelAddress.cutBeginningAndEndingApostrophe(this.worksheetName);
                    AreaReference ar = new AreaReference(this.fullAddress, SpreadsheetVersion.EXCEL2007);
                    this.firstCell = StringUtils.split((String)ar.getFirstCell().formatAsString(), (String)"!")[1];
                    this.lastCell = StringUtils.split((String)ar.getLastCell().formatAsString(), (String)"!")[1];
                    int rowUpperLeft = ar.getFirstCell().getRow();
                    int rowLowerRight = ar.getLastCell().getRow();
                    this.numberOfRows = rowLowerRight - rowUpperLeft + 1;
                    short colUpperLeft = ar.getFirstCell().getCol();
                    short colLowerRight = ar.getLastCell().getCol();
                    this.numberOfColumns = colLowerRight - colUpperLeft + 1;
                    this.beginningRowNumber = ar.getFirstCell().getRow() + 1;
                    this.beginningColumnNumber = ar.getFirstCell().getCol() + 1;
                } else {
                    boolean isNewXlFile;
                    if (wb instanceof HSSFWorkbook) {
                        isNewXlFile = false;
                    } else if (wb instanceof XSSFWorkbook) {
                        isNewXlFile = true;
                    } else {
                        throw new ExcelException("Could not determine if Excel file is old-style (Excel 97-2007) or new-style (Excel 2007+) based.");
                    }
                    String[] splitAddress = rawAddress.split("!");
                    String lastAddressToken = splitAddress[splitAddress.length - 1];
                    String exceptionMessage = "Validation of address '" + rawAddress + "' failed. " + "Most likely it's no valid Excel cell address.";
                    if (isNewXlFile ? splitAddress.length != 2 || !lastAddressToken.matches("^\\$?([A-Za-z]{0,3})\\$?([0-9]{0,7}):?\\$?([A-Za-z]{0,3})\\$?([0-9]{0,7})$") || lastAddressToken.matches("[A-Za-z]+") || lastAddressToken.matches("[0-9]+") || lastAddressToken.startsWith(":") || lastAddressToken.endsWith(":") : splitAddress.length != 2 || !lastAddressToken.matches("^\\$?([A-Za-z]{0,2})\\$?([0-9]{0,5}):?\\$?([A-Za-z]{0,2})\\$?([0-9]{0,5})$") || lastAddressToken.matches("[A-Za-z]+") || lastAddressToken.matches("[0-9]+") || lastAddressToken.startsWith(":") || lastAddressToken.endsWith(":")) {
                        throw new ExcelException(exceptionMessage);
                    }
                    String rawAddressWithoutAbsoluteFlag = StringUtils.remove((String)rawAddress, (String)"$");
                    this.worksheetName = StringUtils.split((String)rawAddressWithoutAbsoluteFlag, (String)"!")[0];
                    this.worksheetName = ExcelAddress.cutBeginningAndEndingApostrophe(this.worksheetName);
                    this.firstCell = ExcelAddress.getAddressPart(rawAddressWithoutAbsoluteFlag, true, isNewXlFile);
                    this.lastCell = ExcelAddress.getAddressPart(rawAddressWithoutAbsoluteFlag, false, isNewXlFile);
                    this.numberOfRows = ExcelAddress.getNumberOfRows(this.firstCell, this.lastCell);
                    this.numberOfColumns = ExcelAddress.getNumberOfColumns(this.firstCell, this.lastCell);
                    this.beginningRowNumber = Integer.valueOf(ExcelAddress.getRowNumberOfCell(this.firstCell));
                    this.beginningColumnNumber = ExcelAddress.getNumberOfColumnChar(ExcelAddress.getColumnCharsOfCell(this.firstCell));
                    this.fullAddress = String.valueOf(this.worksheetName) + "!" + this.firstCell + ":" + this.lastCell;
                    AreaReference ar = new AreaReference(this.fullAddress, SpreadsheetVersion.EXCEL2007);
                    this.fullAddress = ar.formatAsString();
                    Sheet sheet = wb.getSheet(this.worksheetName);
                    if (sheet == null) {
                        throw new ExcelException("Cannot discover sheet in Excel file.");
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new ExcelException(e);
            }
            catch (FileNotFoundException e) {
                throw new ExcelException(e);
            }
            catch (IllegalArgumentException e) {
                throw new ExcelException("File is no Excel file.", e);
            }
            catch (IOException e) {
                throw new ExcelException("Excel file is not found or cannot be opened.", e);
            }
        }
        finally {
            if (inp != null) {
                try {
                    ((InputStream)inp).close();
                }
                catch (IOException e) {
                    throw new ExcelException("Cannot close access to Excel file.", e);
                }
            }
            ExcelUtils.destroyGarbage();
        }
    }

    private static String cutBeginningAndEndingApostrophe(String rawString) {
        String resultString = StringUtils.removeStart((String)rawString, (String)"'");
        resultString = StringUtils.removeEnd((String)resultString, (String)"'");
        return resultString;
    }

    public String getFullAddress() {
        return this.fullAddress;
    }

    public String getUserDefinedName() {
        return this.userDefinedNameForAddress;
    }

    public String getWorkSheetName() {
        return this.worksheetName;
    }

    public String getFirstCell() {
        return this.firstCell;
    }

    public String getLastCell() {
        return this.lastCell;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public int getBeginningRowNumber() {
        return this.beginningRowNumber;
    }

    public int getBeginningColumnNumber() {
        return this.beginningColumnNumber;
    }

    public boolean isUserDefindNameOfScheme(String regex) {
        return this.userDefinedNameForAddress != null && !this.userDefinedNameForAddress.isEmpty() && this.userDefinedNameForAddress.matches(regex);
    }

    public static ExcelAddress getExcelAddressForTableRange(File excelFile, ExcelAddress originAddr, int rows, int columns) {
        ExcelAddress address = new ExcelAddress(originAddr);
        if (rows > 0 && columns > 0) {
            address.lastCell = "";
            String columnName = ExcelAddress.getNextColumnName(ExcelAddress.getColumnCharsOfCell(address.firstCell), columns - 1);
            address.lastCell = columnName.concat(String.valueOf(Integer.valueOf(ExcelAddress.getRowNumberOfCell(address.firstCell)) + rows - 1));
            if (!originAddr.getFirstCell().equalsIgnoreCase(originAddr.getLastCell())) {
                address.fullAddress = StringUtils.removeEnd((String)address.fullAddress, (String)originAddr.getLastCell());
            }
            if (!address.fullAddress.endsWith(":")) {
                address.fullAddress = address.fullAddress.concat(":");
            }
            address.fullAddress = address.fullAddress.concat(address.lastCell);
            address.userDefinedNameForAddress = null;
            address.numberOfColumns = columns;
            address.numberOfRows = rows;
            address = new ExcelAddress(excelFile, address.getFullAddress());
        }
        return address;
    }

    private static String getAddressPart(String address, boolean leftAddress, boolean isXlsX) {
        int addressFlag = leftAddress ? 0 : 1;
        String cells = address.split("!")[1];
        String[] normalizedCells = cells.split(":");
        if (normalizedCells.length == 1) {
            return normalizedCells[0];
        }
        String columnChars = ExcelAddress.getColumnCharsOfCell(normalizedCells[addressFlag]);
        String rowNumber = ExcelAddress.getRowNumberOfCell(normalizedCells[addressFlag]);
        if (columnChars == null || columnChars.equals("")) {
            columnChars = leftAddress ? "A" : (isXlsX ? SpreadsheetVersion.EXCEL2007.getLastColumnName() : SpreadsheetVersion.EXCEL97.getLastColumnName());
        }
        if (rowNumber == null || rowNumber.equals("")) {
            rowNumber = leftAddress ? "1" : (isXlsX ? Integer.toString(SpreadsheetVersion.EXCEL2007.getMaxRows()) : Integer.toString(SpreadsheetVersion.EXCEL97.getMaxRows()));
        }
        return String.valueOf(columnChars) + rowNumber;
    }

    private static String getRowNumberOfCell(String cellname) {
        String[] result = cellname.split("[\\D]+");
        String returnVal = null;
        returnVal = result.length == 0 ? "" : (result.length == 1 ? result[0] : result[1]);
        return returnVal;
    }

    private static String getColumnCharsOfCell(String cellname) {
        String[] result = cellname.split("[\\d]+");
        String returnVal = null;
        returnVal = result.length == 0 ? "" : result[0];
        return returnVal;
    }

    private static int getNumberOfColumns(String upperLeftCell, String lowerRightCell) {
        String tempLr;
        String tempUl = ExcelAddress.getColumnCharsOfCell(upperLeftCell);
        if (tempUl != null && !tempUl.equals("") && (tempLr = ExcelAddress.getColumnCharsOfCell(lowerRightCell)) != null && !tempLr.equals("")) {
            int number = 1;
            while (!tempUl.equals(tempLr)) {
                ++number;
                tempUl = ExcelAddress.getNextColumnName(tempUl, 1);
            }
            return number;
        }
        return 1;
    }

    private static int getNumberOfColumnChar(String columnChar) {
        return ExcelAddress.toPos(columnChar);
    }

    private static int toPos(String col) {
        int pos = 0;
        int i = 0;
        while (i < col.length()) {
            pos *= 26;
            pos += Integer.parseInt(col.substring(i, i + 1), 36) - 9;
            ++i;
        }
        return pos;
    }

    private static String getOffsetCol(String col, int offset) {
        return ExcelAddress.toCol(ExcelAddress.toPos(col) + offset);
    }

    private static String toCol(int pos) {
        String col = "";
        while (pos > 0) {
            col = String.valueOf((char)(--pos % 26 + 65)) + col;
            pos /= 26;
        }
        return col;
    }

    private static String getNextColumnName(String currentColumnName, int offset) {
        return ExcelAddress.getOffsetCol(currentColumnName, offset);
    }

    private static int getNumberOfRows(String upperLeftCell, String lowerRightCell) {
        String tempUl = ExcelAddress.getRowNumberOfCell(upperLeftCell);
        if (tempUl != null && !tempUl.equals("")) {
            int ul = Integer.valueOf(tempUl);
            String tempLr = ExcelAddress.getRowNumberOfCell(lowerRightCell);
            if (tempLr != null && !tempLr.equals("")) {
                int lr = Integer.valueOf(tempLr);
                return lr - ul + 1;
            }
        }
        return 1;
    }
}

