/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.excel.gui.dm;

import de.rcenvironment.components.excel.common.ExcelComponentHistoryDataItem;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.datamanagement.api.CommonComponentHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.gui.datamanagement.browser.spi.CommonHistoryDataItemSubtreeBuilderUtils;
import de.rcenvironment.core.gui.datamanagement.browser.spi.ComponentHistoryDataItemSubtreeBuilder;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNode;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNodeType;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ExcelHistoryDataItemSubtreeBuilder
implements ComponentHistoryDataItemSubtreeBuilder {
    private static final Image COMPONENT_ICON;

    static {
        String bundleName = "de.rcenvironment.components.excel.common";
        String iconName = "excel16.png";
        URL url = ComponentUtils.readIconURL((String)bundleName, (String)iconName);
        COMPONENT_ICON = url != null ? ImageDescriptor.createFromURL((URL)url).createImage() : null;
    }

    public String[] getSupportedHistoryDataItemIdentifier() {
        return new String[]{"de.rcenvironment.excel"};
    }

    public Serializable deserializeHistoryDataItem(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        return (Serializable)ois.readObject();
    }

    public void buildInitialHistoryDataItemSubtree(Serializable historyDataItem, DMBrowserNode parentNode) {
        ServiceRegistryAccess registryAccess = ServiceRegistry.createAccessFor((Object)this);
        TypedDatumSerializer serializer = ((TypedDatumService)registryAccess.getService(TypedDatumService.class)).getSerializer();
        if (historyDataItem instanceof String) {
            ExcelComponentHistoryDataItem historyData;
            try {
                historyData = ExcelComponentHistoryDataItem.fromString((String)((String)((Object)historyDataItem)), (TypedDatumSerializer)serializer);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            CommonHistoryDataItemSubtreeBuilderUtils.buildCommonHistoryDataItemSubtrees((CommonComponentHistoryDataItem)historyData, (DMBrowserNode)parentNode);
            if (historyData.getExcelFilePath() != null) {
                DMBrowserNode.addNewLeafNode((String)StringUtils.format((String)"Excel file: %s", (Object[])new Object[]{historyData.getExcelFilePath()}), (DMBrowserNodeType)DMBrowserNodeType.InformationText, (DMBrowserNode)parentNode);
            }
        } else {
            String exceptionInformationText = "";
            exceptionInformationText = historyDataItem != null ? StringUtils.format((String)"Parsing history data point failed: Expected type %s, but was of type %s", (Object[])new Object[]{String.class.getCanonicalName(), historyDataItem.getClass().getCanonicalName()}) : StringUtils.format((String)"Parsing history data point failed: Expected type %s, actual type not available.", (Object[])new Object[]{String.class.getCanonicalName()});
            throw new IllegalArgumentException(exceptionInformationText);
        }
    }

    public Image getComponentIcon(String identifier) {
        return COMPONENT_ICON;
    }
}

