/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.CucumberExpression;
import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.cucumberexpressions.Expression;
import io.cucumber.cucumberexpressions.ParameterTypeRegistry;
import io.cucumber.cucumberexpressions.RegularExpression;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class ExpressionFactory {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("((?:\\\\){0,2})\\{([^}]*)\\}");
    private final ParameterTypeRegistry parameterTypeRegistry;

    public ExpressionFactory(ParameterTypeRegistry parameterTypeRegistry) {
        this.parameterTypeRegistry = parameterTypeRegistry;
    }

    public Expression createExpression(String expressionString) {
        int length = expressionString.length();
        if (length == 0) {
            return new CucumberExpression(expressionString, this.parameterTypeRegistry);
        }
        int lastCharIndex = length - 1;
        char firstChar = expressionString.charAt(0);
        char lastChar = expressionString.charAt(lastCharIndex);
        if (firstChar == '^' || lastChar == '$') {
            return this.createRegularExpressionWithAnchors(expressionString);
        }
        if (firstChar == '/' && lastChar == '/') {
            return new RegularExpression(Pattern.compile(expressionString.substring(1, lastCharIndex)), this.parameterTypeRegistry);
        }
        return new CucumberExpression(expressionString, this.parameterTypeRegistry);
    }

    private RegularExpression createRegularExpressionWithAnchors(String expressionString) {
        try {
            return new RegularExpression(Pattern.compile(expressionString), this.parameterTypeRegistry);
        }
        catch (PatternSyntaxException e) {
            if (PARAMETER_PATTERN.matcher(expressionString).find()) {
                throw new CucumberExpressionException("You cannot use anchors (^ or $) in Cucumber Expressions. Please remove them from " + expressionString, e);
            }
            throw e;
        }
    }
}

