/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.update.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.rcenvironment.core.component.update.api.DistributedPersistentComponentDescriptionUpdateService;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.component.workflow.update.api.PersistentWorkflowDescription;
import de.rcenvironment.core.component.workflow.update.api.PersistentWorkflowDescriptionUpdateService;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersistentWorkflowDescriptionUpdateServiceImpl
implements PersistentWorkflowDescriptionUpdateService {
    private static final String SHORT_TEXT = "ShortText";
    private static final String CURRENT_VERSION = String.valueOf(5);
    private static final String VERSION_3 = "3";
    private static final Map<String, String> OLD_TO_NEW_TYPES = new HashMap<String, String>(){
        {
            this.put("java.lang.String", PersistentWorkflowDescriptionUpdateServiceImpl.SHORT_TEXT);
            this.put("java.lang.Double", "Float");
            this.put("java.lang.Integer", "Integer");
            this.put("java.lang.Float", "Float");
            this.put("java.lang.Long", "Integer");
            this.put("java.lang.Boolean", "Boolean");
            this.put("de.rcenvironment.commons.channel.DataManagementFileReference", "FileReference");
            this.put("de.rcenvironment.commons.channel.VariantArray", "SmallTable");
        }
    };
    private static final Log LOGGER = LogFactory.getLog(PersistentWorkflowDescriptionUpdateServiceImpl.class);
    private DistributedPersistentComponentDescriptionUpdateService componentUpdateService;

    @Override
    public boolean isUpdateForWorkflowDescriptionAvailable(PersistentWorkflowDescription description, boolean silent) {
        if (!silent ? description.getWorkflowVersion().compareTo(VERSION_3) < 0 : description.getWorkflowVersion().compareTo(CURRENT_VERSION) < 0) {
            return true;
        }
        return this.componentUpdateService.getFormatVersionsAffectedByUpdate(description.getComponentDescriptions(), silent) != 0;
    }

    @Override
    public PersistentWorkflowDescription performWorkflowDescriptionUpdate(PersistentWorkflowDescription persistentDescription) throws IOException {
        PersistentWorkflowDescription description = persistentDescription;
        Set<String> endpoints = this.getEndpoints(description);
        description = this.performComponentDescriptionUpdates(1, description, true);
        description = this.performComponentDescriptionUpdates(1, description, false);
        String workflowVersion = description.getWorkflowVersion();
        description = this.checkForWorkflowDescriptionUpdateAndPerformOnDemand(description, workflowVersion);
        description = this.performComponentDescriptionUpdates(2, description, true);
        description = this.performComponentDescriptionUpdates(2, description, false);
        description = this.checkForConnectionDescriptionUpdateAndPerformOnDemand(description, workflowVersion);
        description = this.performComponentDescriptionUpdates(4, description, true);
        description = this.performComponentDescriptionUpdates(4, description, false);
        endpoints.removeAll(this.getEndpoints(description));
        description = this.removeConnectionsRelatedToRemovedEndpoints(description, endpoints);
        description = this.updateWorkflowToCurrentVersion(description);
        return description;
    }

    private Set<String> getEndpoints(PersistentWorkflowDescription persWfDescription) throws JsonProcessingException, IOException {
        HashSet<String> endpoints = new HashSet<String>();
        for (PersistentComponentDescription persCompDesc : persWfDescription.getComponentDescriptions()) {
            ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
            JsonNode node = mapper.readTree(persCompDesc.getComponentDescriptionAsString());
            endpoints.addAll(this.getEndpointsOfGroup(node, "staticInputs"));
            endpoints.addAll(this.getEndpointsOfGroup(node, "staticOutputs"));
            endpoints.addAll(this.getEndpointsOfGroup(node, "dynamicInputs"));
            endpoints.addAll(this.getEndpointsOfGroup(node, "dynamicOutputs"));
        }
        return endpoints;
    }

    private Set<String> getEndpointsOfGroup(JsonNode node, String endpointGroup) throws JsonProcessingException, IOException {
        HashSet<String> endpoints = new HashSet<String>();
        if (node.has(endpointGroup)) {
            Iterator outputJsonNodes = node.get(endpointGroup).elements();
            while (outputJsonNodes.hasNext()) {
                endpoints.add(((JsonNode)outputJsonNodes.next()).get("identifier").textValue());
            }
        }
        return endpoints;
    }

    private PersistentWorkflowDescription removeConnectionsRelatedToRemovedEndpoints(PersistentWorkflowDescription persWfDescription, Set<String> endpointsRemoved) throws JsonProcessingException, IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode workflowDescriptionAsTree = mapper.readTree(persWfDescription.getWorkflowDescriptionAsString());
        for (String endpointRemoved : endpointsRemoved) {
            if (!workflowDescriptionAsTree.has("connections")) continue;
            ArrayNode connectionsJsonNode = (ArrayNode)workflowDescriptionAsTree.get("connections");
            Iterator connectionJsonNodes = connectionsJsonNode.elements();
            while (connectionJsonNodes.hasNext()) {
                JsonNode connectionJsonNode = (JsonNode)connectionJsonNodes.next();
                if (!connectionJsonNode.get("input").textValue().equals(endpointRemoved) && !connectionJsonNode.get("output").textValue().equals(endpointRemoved)) continue;
                connectionJsonNodes.remove();
            }
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentWorkflowDescription(persWfDescription.getComponentDescriptions(), writer.writeValueAsString((Object)workflowDescriptionAsTree));
    }

    private PersistentWorkflowDescription updateWorkflowToCurrentVersion(PersistentWorkflowDescription description) {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            JsonNode workflowDescriptionAsTree = mapper.readTree(description.getWorkflowDescriptionAsString());
            ((ObjectNode)workflowDescriptionAsTree).set("workflowVersion", (JsonNode)TextNode.valueOf((String)CURRENT_VERSION));
            ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
            JsonNode nodes = workflowDescriptionAsTree.get("nodes");
            return new PersistentWorkflowDescription(this.createComponentDescriptions(nodes), writer.writeValueAsString((Object)workflowDescriptionAsTree));
        }
        catch (JsonProcessingException e) {
            LOGGER.error((Object)e.getStackTrace());
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getStackTrace());
        }
        return null;
    }

    private PersistentWorkflowDescription checkForWorkflowDescriptionUpdateAndPerformOnDemand(PersistentWorkflowDescription description, String version) throws IOException {
        if (version.compareTo(VERSION_3) < 0) {
            description = this.performWorkflowDescriptionUpdateVersionOneToTwo(description);
        }
        return description;
    }

    private PersistentWorkflowDescription checkForConnectionDescriptionUpdateAndPerformOnDemand(PersistentWorkflowDescription description, String version) throws IOException {
        if (version.compareTo(VERSION_3) < 0) {
            description = this.performWorkflowDescriptionUpdateVersionOneToTwoForConnections(description);
        }
        return description;
    }

    private PersistentWorkflowDescription performComponentDescriptionUpdates(int formatVersion, PersistentWorkflowDescription description, boolean silent) throws IOException {
        List componentDescriptions = this.componentUpdateService.performComponentDescriptionUpdates(formatVersion, description.getComponentDescriptions(), silent);
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNodeFactory jsonFactory = JsonNodeFactory.instance;
        try {
            ObjectNode workflowDescriptionAsTree = (ObjectNode)mapper.readTree(description.getWorkflowDescriptionAsString());
            ArrayNode componentNodes = new ArrayNode(jsonFactory);
            if (componentDescriptions.size() > 0) {
                for (PersistentComponentDescription pcd : componentDescriptions) {
                    JsonNode component = mapper.readTree(pcd.getComponentDescriptionAsString());
                    componentNodes.add(component);
                }
                JsonNode connections = workflowDescriptionAsTree.remove("connections");
                JsonNode bendpoints = workflowDescriptionAsTree.remove("bendpoints");
                workflowDescriptionAsTree.remove("nodes");
                workflowDescriptionAsTree.set("nodes", (JsonNode)componentNodes);
                if (connections != null) {
                    workflowDescriptionAsTree.set("connections", connections);
                }
                if (bendpoints != null) {
                    workflowDescriptionAsTree.set("bendpoints", bendpoints);
                }
            }
            ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
            return new PersistentWorkflowDescription(componentDescriptions, writer.writeValueAsString((Object)workflowDescriptionAsTree));
        }
        catch (JsonProcessingException e) {
            LOGGER.error((Object)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        return null;
    }

    private PersistentWorkflowDescription performWorkflowDescriptionUpdateVersionOneToTwoForConnections(PersistentWorkflowDescription description) throws IOException {
        JsonNodeFactory jsonFactory = JsonNodeFactory.instance;
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode workflowDescriptionAsTree = mapper.readTree(description.getWorkflowDescriptionAsString());
        JsonNode nodes = workflowDescriptionAsTree.get("nodes");
        JsonNode connections = workflowDescriptionAsTree.get("connections");
        connections = PersistentWorkflowDescriptionUpdateServiceImpl.updateConnectionsToVersion3(connections, nodes, jsonFactory);
        ((ObjectNode)workflowDescriptionAsTree).remove("connections");
        if (connections != null) {
            ((ObjectNode)workflowDescriptionAsTree).set("connections", connections);
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentWorkflowDescription(this.createComponentDescriptions(nodes), writer.writeValueAsString((Object)workflowDescriptionAsTree));
    }

    private PersistentWorkflowDescription performWorkflowDescriptionUpdateVersionOneToTwo(PersistentWorkflowDescription description) throws IOException {
        JsonNodeFactory jsonFactory = JsonNodeFactory.instance;
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode workflowDescriptionAsTree = mapper.readTree(description.getWorkflowDescriptionAsString());
        JsonNode nodes = workflowDescriptionAsTree.get("nodes");
        if (nodes != null) {
            nodes = PersistentWorkflowDescriptionUpdateServiceImpl.updateNodesToVersion3(nodes, jsonFactory);
        }
        ((ObjectNode)workflowDescriptionAsTree).remove("nodes");
        ((ObjectNode)workflowDescriptionAsTree).remove("workflowVersion");
        ((ObjectNode)workflowDescriptionAsTree).set("workflowVersion", (JsonNode)TextNode.valueOf((String)VERSION_3));
        if (nodes != null) {
            ((ObjectNode)workflowDescriptionAsTree).set("nodes", nodes);
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentWorkflowDescription(this.createComponentDescriptions(nodes), writer.writeValueAsString((Object)workflowDescriptionAsTree));
    }

    private static JsonNode updateNodesToVersion3(JsonNode nodes, JsonNodeFactory jsonFactory) {
        ArrayNode newNodes = jsonFactory.arrayNode();
        for (JsonNode componentNode : nodes) {
            ObjectNode newComponentNode = (ObjectNode)componentNode;
            PersistentWorkflowDescriptionUpdateServiceImpl.updateDynamicEndpoints("Output", jsonFactory, componentNode, newComponentNode);
            PersistentWorkflowDescriptionUpdateServiceImpl.updateDynamicEndpoints("Input", jsonFactory, componentNode, newComponentNode);
            PersistentWorkflowDescriptionUpdateServiceImpl.updateConfiguration(jsonFactory, componentNode, newComponentNode);
            newNodes.add((JsonNode)newComponentNode);
        }
        return newNodes;
    }

    private static JsonNode updateConnectionsToVersion3(JsonNode connections, JsonNode nodes, JsonNodeFactory jsonFactory) {
        ArrayNode newConnectionsArrayNode = jsonFactory.arrayNode();
        if (connections != null) {
            for (JsonNode connection : (ArrayNode)connections) {
                ObjectNode connectionObject = (ObjectNode)connection;
                ObjectNode newConnectionsObjectNode = jsonFactory.objectNode();
                newConnectionsObjectNode.set("source", connectionObject.get("source"));
                String sourceOutput = connectionObject.get("output").textValue();
                for (JsonNode component : nodes) {
                    if (!((ObjectNode)component).get("identifier").textValue().equals(connectionObject.get("source").textValue())) continue;
                    boolean foundOutput = false;
                    if (((ObjectNode)component).get("dynamicOutputs") != null) {
                        for (JsonNode endpoint : ((ObjectNode)component).get("dynamicOutputs")) {
                            if (!((ObjectNode)endpoint).get("name").textValue().equals(sourceOutput)) continue;
                            newConnectionsObjectNode.set("output", ((ObjectNode)endpoint).get("identifier"));
                            foundOutput = true;
                        }
                    }
                    if (((ObjectNode)component).get("staticOutputs") != null) {
                        for (JsonNode endpoint : ((ObjectNode)component).get("staticOutputs")) {
                            if (!((ObjectNode)endpoint).get("name").textValue().equals(sourceOutput)) continue;
                            newConnectionsObjectNode.set("output", ((ObjectNode)endpoint).get("identifier"));
                            foundOutput = true;
                        }
                    }
                    if (foundOutput) continue;
                    ArrayNode staticOutputs = (ArrayNode)component.get("staticOutputs");
                    if (staticOutputs == null) {
                        staticOutputs = JsonNodeFactory.instance.arrayNode();
                        ((ObjectNode)component).set("staticOutputs", (JsonNode)staticOutputs);
                    }
                    ObjectNode newStaticOutput = JsonNodeFactory.instance.objectNode();
                    newStaticOutput.put("name", sourceOutput);
                    newStaticOutput.put("identifier", UUID.randomUUID().toString());
                    newStaticOutput.put("datatype", SHORT_TEXT);
                    staticOutputs.add((JsonNode)newStaticOutput);
                    newConnectionsObjectNode.set("output", newStaticOutput.get("identifier"));
                }
                newConnectionsObjectNode.set("target", connectionObject.get("target"));
                String targetInput = connectionObject.get("input").textValue();
                for (JsonNode component : nodes) {
                    if (!((ObjectNode)component).get("identifier").textValue().equals(connectionObject.get("target").textValue())) continue;
                    boolean foundInput = false;
                    if (((ObjectNode)component).get("dynamicInputs") != null) {
                        for (JsonNode endpoint : ((ObjectNode)component).get("dynamicInputs")) {
                            if (!((ObjectNode)endpoint).get("name").textValue().equals(targetInput)) continue;
                            newConnectionsObjectNode.set("input", ((ObjectNode)endpoint).get("identifier"));
                            foundInput = true;
                        }
                    }
                    if (((ObjectNode)component).get("staticInputs") != null) {
                        for (JsonNode endpoint : ((ObjectNode)component).get("staticInputs")) {
                            if (!((ObjectNode)endpoint).get("name").textValue().equals(targetInput)) continue;
                            newConnectionsObjectNode.set("input", ((ObjectNode)endpoint).get("identifier"));
                            foundInput = true;
                        }
                    }
                    if (foundInput) continue;
                    ArrayNode staticInputs = (ArrayNode)component.get("staticInputs");
                    if (staticInputs == null) {
                        staticInputs = JsonNodeFactory.instance.arrayNode();
                        ((ObjectNode)component).set("staticInputs", (JsonNode)staticInputs);
                    }
                    ObjectNode newStaticInput = JsonNodeFactory.instance.objectNode();
                    newStaticInput.put("name", targetInput);
                    newStaticInput.put("identifier", UUID.randomUUID().toString());
                    newStaticInput.put("datatype", SHORT_TEXT);
                    staticInputs.add((JsonNode)newStaticInput);
                    newConnectionsObjectNode.set("input", newStaticInput.get("identifier"));
                }
                newConnectionsArrayNode.add((JsonNode)newConnectionsObjectNode);
            }
        }
        return newConnectionsArrayNode;
    }

    private static void updateConfiguration(JsonNodeFactory jsonFactory, JsonNode componentNode, ObjectNode newComponentNode) {
        ObjectNode newConfigNode = jsonFactory.objectNode();
        ArrayNode oldConfigNode = (ArrayNode)componentNode.get("configuration");
        if (oldConfigNode != null) {
            for (JsonNode config : oldConfigNode) {
                String[] splitted = StringUtils.splitAndUnescape((String)config.textValue());
                if (splitted.length > 2) {
                    newConfigNode.set(splitted[0], (JsonNode)TextNode.valueOf((String)splitted[2]));
                    continue;
                }
                newConfigNode.set(splitted[0], (JsonNode)jsonFactory.textNode(""));
            }
        }
        newComponentNode.set("configuration", (JsonNode)newConfigNode);
    }

    private static void updateDynamicEndpoints(String type, JsonNodeFactory jsonFactory, JsonNode componentNode, ObjectNode newComponentNode) {
        ArrayNode newEndpointList = jsonFactory.arrayNode();
        ArrayNode oldEndpointList = (ArrayNode)componentNode.get("add" + type);
        JsonNode metadata = componentNode.get(String.valueOf(type.toLowerCase()) + "MetaData");
        if (oldEndpointList != null) {
            for (JsonNode endpoint : oldEndpointList) {
                ObjectNode newEndpoint = jsonFactory.objectNode();
                String oldEndpoint = endpoint.textValue();
                newEndpoint.put("identifier", UUID.randomUUID().toString());
                newEndpoint.set("epIdentifier", (JsonNode)jsonFactory.nullNode());
                String[] splittedEndpoint = StringUtils.splitAndUnescape((String)oldEndpoint);
                newEndpoint.put("name", splittedEndpoint[0]);
                newEndpoint.put("datatype", OLD_TO_NEW_TYPES.get(splittedEndpoint[1]));
                if (splittedEndpoint.length > 2) {
                    newEndpoint.put("value", splittedEndpoint[2]);
                } else {
                    newEndpoint.put("value", "");
                }
                if (metadata != null && metadata.get(splittedEndpoint[0]) != null) {
                    ObjectNode newMetadata = jsonFactory.objectNode();
                    for (JsonNode metaDatum : metadata.get(splittedEndpoint[0])) {
                        String metadataText = metaDatum.textValue();
                        String[] splittedMetaDatum = StringUtils.splitAndUnescape((String)metadataText);
                        if (splittedMetaDatum[0].equals("usage")) {
                            if (splittedMetaDatum[2].equals("init")) {
                                splittedMetaDatum[2] = "initial";
                            } else if (splittedMetaDatum[2].equals("Required")) {
                                splittedMetaDatum[2] = "required";
                            } else if (splittedMetaDatum[2].equals("Optional")) {
                                splittedMetaDatum[2] = "optional";
                            }
                        }
                        newMetadata.put(splittedMetaDatum[0], splittedMetaDatum[2]);
                    }
                    newEndpoint.set("metadata", (JsonNode)newMetadata);
                }
                newEndpointList.add((JsonNode)newEndpoint);
            }
        }
        newComponentNode.remove("add" + type);
        newComponentNode.remove(String.valueOf(type.toLowerCase()) + "MetaData");
        newComponentNode.set("dynamic" + type + "s", (JsonNode)newEndpointList);
    }

    @Override
    public PersistentWorkflowDescription createPersistentWorkflowDescription(String persistentWorkflowDescriptionString) throws JsonParseException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JsonParser jsonParser = new JsonFactory().createParser(persistentWorkflowDescriptionString);){
            ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
            JsonNode node = (JsonNode)mapper.readTree(jsonParser);
            ArrayList<PersistentComponentDescription> nodeDescriptionList = new ArrayList();
            JsonNode componentNodes = node.get("nodes");
            if (componentNodes != null) {
                nodeDescriptionList = this.createComponentDescriptions(componentNodes);
            }
            ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
            String workflowDescriptionString = writer.writeValueAsString((Object)node);
            PersistentWorkflowDescription result = new PersistentWorkflowDescription(nodeDescriptionList, workflowDescriptionString);
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<PersistentComponentDescription> createComponentDescriptions(JsonNode nodes) throws JsonGenerationException, JsonMappingException, IOException {
        LinkedList<PersistentComponentDescription> componentDescriptions = new LinkedList<PersistentComponentDescription>();
        if (nodes != null) {
            Iterator nodeIterator = nodes.elements();
            while (nodeIterator.hasNext()) {
                JsonNode component = (JsonNode)nodeIterator.next();
                ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
                ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
                String compontentStr = writer.writeValueAsString((Object)component);
                PersistentComponentDescription pcd = new PersistentComponentDescription(compontentStr);
                componentDescriptions.add(pcd);
            }
        }
        return componentDescriptions;
    }

    public void bindComponentDescriptionUpdateService(DistributedPersistentComponentDescriptionUpdateService updateService) {
        this.componentUpdateService = updateService;
    }
}

