/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.component.workflow.execution.api.WorkflowVerificationBuilder;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowVerificationResults;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowVerificationService;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionContextBuilder;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionService;
import de.rcenvironment.core.component.workflow.execution.headless.internal.HeadlessWorkflowExecutionVerification;
import de.rcenvironment.core.component.workflow.execution.headless.internal.HeadlessWorkflowExecutionVerificationRecorder;
import de.rcenvironment.core.component.workflow.execution.headless.internal.HeadlessWorkflowExecutionVerificationResult;
import de.rcenvironment.core.utils.common.InvalidFilenameException;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.receivers.PrefixingTextOutForwarder;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class WorkflowVerification {
    private TextOutputReceiver outputReceiver;
    private File workflowRootFile;
    private final List<File> wfFilesExpectedToSucceed = new LinkedList<File>();
    private final List<File> wfFilesExpectedToFail = new LinkedList<File>();
    private File placeholdersFile;
    private WorkflowVerificationBuilder.LogFolderFactory logfolderFactory;
    private int parallelRuns;
    private int sequentialRuns;
    private HeadlessWorkflowExecutionService.DisposalBehavior dispose;
    private HeadlessWorkflowExecutionService.DeletionBehavior delete;
    private HeadlessWorkflowExecutionService workflowExecutionService;
    private WorkflowVerificationService workflowVerificationService;

    public WorkflowVerificationResults verify() throws IOException {
        Date startTime = new Date();
        HeadlessWorkflowExecutionVerificationRecorder wfVerificationResultRecorder = HeadlessWorkflowExecutionVerification.createAndInitializeInstance(this.workflowRootFile, this.wfFilesExpectedToSucceed, this.wfFilesExpectedToFail, this.parallelRuns, this.sequentialRuns);
        Collection wfFiles = Stream.concat(this.wfFilesExpectedToSucceed.stream(), this.wfFilesExpectedToFail.stream()).collect(Collectors.toList());
        int j = 0;
        while (j < this.sequentialRuns) {
            HashSet<HeadlessWorkflowExecutionContext> headlessWfExeContexts = new HashSet<HeadlessWorkflowExecutionContext>();
            int i = 0;
            while (i < this.parallelRuns) {
                for (File wfFile : wfFiles) {
                    if (!this.workflowVerificationService.preValidateWorkflow(this.outputReceiver, wfFile, false)) continue;
                    try {
                        HeadlessWorkflowExecutionContextBuilder exeContextBuilder = new HeadlessWorkflowExecutionContextBuilder(wfFile);
                        exeContextBuilder.setLogDirectory(this.logfolderFactory.constructLogFolderForWorkflowFile(wfFile));
                        exeContextBuilder.setPlaceholdersFile(this.placeholdersFile);
                        exeContextBuilder.setTextOutputReceiver((TextOutputReceiver)new PrefixingTextOutForwarder("[workflow execution] ", this.outputReceiver));
                        exeContextBuilder.setDisposalBehavior(this.dispose);
                        exeContextBuilder.setDeletionBehavior(this.delete);
                        headlessWfExeContexts.add(exeContextBuilder.build());
                    }
                    catch (InvalidFilenameException | IOException e) {
                        wfVerificationResultRecorder.addWorkflowError(wfFile, e.getMessage());
                    }
                }
                ++i;
            }
            this.workflowExecutionService.executeWorkflowsAndVerify(headlessWfExeContexts, wfVerificationResultRecorder);
            ++j;
        }
        wfVerificationResultRecorder.setStartAndEndTime(startTime, new Date());
        return WorkflowVerificationResults.fromHeadlessWorkflowExecutionVerificationResult((HeadlessWorkflowExecutionVerificationResult)((Object)wfVerificationResultRecorder));
    }

    public static final class Builder
    implements WorkflowVerificationBuilder {
        private final WorkflowVerification product = new WorkflowVerification();

        @Override
        public WorkflowVerificationBuilder outputReceiver(TextOutputReceiver receiver) {
            this.product.outputReceiver = receiver;
            return this;
        }

        @Override
        public WorkflowVerificationBuilder workflowRootFile(File workflowRootFile) {
            this.product.workflowRootFile = workflowRootFile;
            return this;
        }

        @Override
        public WorkflowVerificationBuilder addWorkflowExpectedToSucceed(File workflowExpectedToSucceed) {
            this.product.wfFilesExpectedToSucceed.add(workflowExpectedToSucceed);
            return this;
        }

        @Override
        public WorkflowVerificationBuilder addWorkflowsExpectedToSucceed(Collection<File> workflowsExpectedToSucceed) {
            this.product.wfFilesExpectedToSucceed.addAll(workflowsExpectedToSucceed);
            return this;
        }

        @Override
        public WorkflowVerificationBuilder addWorkflowExpectedToFail(File workflowExpectedToFail) {
            this.product.wfFilesExpectedToFail.add(workflowExpectedToFail);
            return this;
        }

        @Override
        public WorkflowVerificationBuilder addWorkflowsExpectedToFail(Collection<File> workflowsExpectedToFail) {
            this.product.wfFilesExpectedToFail.addAll(workflowsExpectedToFail);
            return this;
        }

        @Override
        public WorkflowVerificationBuilder placeholdersFile(File placeholdersFileParam) {
            this.product.placeholdersFile = placeholdersFileParam;
            return this;
        }

        @Override
        public WorkflowVerificationBuilder logFileFactory(WorkflowVerificationBuilder.LogFolderFactory logFileFactory) {
            this.product.logfolderFactory = logFileFactory;
            return this;
        }

        @Override
        public WorkflowVerificationBuilder numberOfParallelRuns(int parallelRunsParam) {
            this.product.parallelRuns = parallelRunsParam;
            return this;
        }

        @Override
        public WorkflowVerificationBuilder numberOfSequentialRuns(int sequentialRunsParam) {
            this.product.sequentialRuns = sequentialRunsParam;
            return this;
        }

        @Override
        public WorkflowVerificationBuilder disposalBehavior(HeadlessWorkflowExecutionService.DisposalBehavior disposeParam) {
            this.product.dispose = disposeParam;
            return this;
        }

        @Override
        public WorkflowVerificationBuilder deletionBehavior(HeadlessWorkflowExecutionService.DeletionBehavior deleteParam) {
            this.product.delete = deleteParam;
            return this;
        }

        public WorkflowVerificationBuilder workflowVerificationService(WorkflowVerificationService service) {
            this.product.workflowVerificationService = service;
            return this;
        }

        @Override
        public WorkflowVerificationBuilder workflowExecutionService(HeadlessWorkflowExecutionService service) {
            this.product.workflowExecutionService = service;
            return this;
        }

        @Override
        public WorkflowVerificationResults verify() throws IOException {
            return this.product.verify();
        }
    }
}

