/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.toolintegration;

import de.rcenvironment.core.component.integration.IntegrationContext;
import de.rcenvironment.core.gui.integration.common.ComponentDescriptionValidator;
import de.rcenvironment.core.gui.integration.common.GroupPathChooserButtonListener;
import de.rcenvironment.core.gui.integration.common.PathChooserButtonListener;
import de.rcenvironment.core.gui.integration.toolintegration.Messages;
import de.rcenvironment.core.gui.integration.toolintegration.ToolIntegrationWizard;
import de.rcenvironment.core.gui.integration.toolintegration.api.ToolIntegrationWizardPage;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class ToolCharacteristicsPage
extends ToolIntegrationWizardPage {
    private static final String HELP_CONTEXT_ID = "de.rcenvironment.core.gui.wizard.toolintegration.integration_characteristics";
    private static final String DOTS = "  ...  ";
    private static final int TOOL_DESCRIPTION_TEXT_HEIGHT = 50;
    protected Map<String, Object> configurationMap;
    private Text toolNameText;
    private Text iconText;
    private final List<String> usedToolnames;
    private Text groupPathText;
    private Text descriptionTextArea;
    private Text integratorName;
    private Text integratorEmail;
    private Button uploadIconToFolder;
    private List<String> groupNames;
    private Text documenationText;
    private Optional<String> docValidationMessage = Optional.empty();
    private Optional<String> iconValidationMessage = Optional.empty();
    private Optional<String> nameValidationMessage = Optional.empty();
    private Optional<String> groupValidationMessage = Optional.empty();
    private PathChooserButtonListener docPathChooserButtonListener;
    private Optional<String> nameOrigin = Optional.empty();

    protected ToolCharacteristicsPage(String pageName, Map<String, Object> configurationMap, List<String> usedToolnames, List<String> groupNames) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(Messages.firstPageDescription);
        this.configurationMap = configurationMap;
        this.usedToolnames = usedToolnames;
        this.groupNames = groupNames;
        configurationMap.putIfAbsent("uploadIcon", true);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        GridData containerData = new GridData(1808);
        container.setLayoutData((Object)containerData);
        Composite toolDataComp = new Composite(container, 0);
        toolDataComp.setLayout((Layout)new GridLayout(1, false));
        GridData toolData = new GridData(1808);
        toolDataComp.setLayoutData((Object)toolData);
        Group toolPropertiesGroup = new Group(toolDataComp, 0);
        toolPropertiesGroup.setText(Messages.toolPropGroup);
        toolPropertiesGroup.setLayout((Layout)new GridLayout(3, false));
        GridData toolPropertyData = new GridData(1808);
        toolPropertiesGroup.setLayoutData((Object)toolPropertyData);
        this.toolNameText = this.addLabelAndTextfieldForPropertyToComposite((Composite)toolPropertiesGroup, Messages.nameRequired, "toolName");
        ((GridData)this.toolNameText.getLayoutData()).horizontalSpan = 2;
        this.toolNameText.addModifyListener(e -> {
            ComponentDescriptionValidator validator = new ComponentDescriptionValidator();
            this.nameValidationMessage = validator.validateName(this.toolNameText, ((ToolIntegrationWizard)this.getWizard()).getCurrentContext().getPrefixForComponentId(), this.nameOrigin, this.usedToolnames);
            this.validate(true);
        });
        this.iconText = this.addLabelAndTextfieldForPropertyToComposite((Composite)toolPropertiesGroup, Messages.iconPath, "toolIconPath");
        this.iconText.setMessage(Messages.iconSizeMessage);
        this.iconText.addModifyListener(e -> {
            ComponentDescriptionValidator validator = new ComponentDescriptionValidator();
            this.iconValidationMessage = validator.validateIcon(this.iconText, ((ToolIntegrationWizard)this.getWizard()).getCurrentContext(), (String)this.configurationMap.get("toolName"));
            this.validate(true);
        });
        GridLayout iconCompLayout = new GridLayout(2, false);
        iconCompLayout.marginWidth = 0;
        Composite iconComp = new Composite((Composite)toolPropertiesGroup, 0);
        iconComp.setLayout((Layout)iconCompLayout);
        Button choosePathButton = new Button(iconComp, 8);
        choosePathButton.setText(DOTS);
        choosePathButton.addSelectionListener((SelectionListener)new PathChooserButtonListener(this.iconText, false, new String[]{"*.jpg;*.png", "*.jpg", "*.png"}, this.getShell()));
        this.uploadIconToFolder = new Button(iconComp, 32);
        this.uploadIconToFolder.setText(Messages.copyIconButtonLabel);
        this.uploadIconToFolder.setSelection(true);
        this.uploadIconToFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ToolCharacteristicsPage.this.configurationMap.put("uploadIcon", ToolCharacteristicsPage.this.uploadIconToFolder.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.groupPathText = this.addLabelAndTextfieldForPropertyToComposite((Composite)toolPropertiesGroup, Messages.groupPathText, "groupName");
        GridData groupNameTextData = new GridData(768);
        this.groupPathText.setLayoutData((Object)groupNameTextData);
        this.groupPathText.addModifyListener(e -> {
            ComponentDescriptionValidator validator = new ComponentDescriptionValidator();
            this.groupValidationMessage = validator.validateGroupPath(this.groupPathText);
            this.validate(true);
        });
        Button chooseGroupButton = new Button((Composite)toolPropertiesGroup, 8);
        chooseGroupButton.setText(DOTS);
        chooseGroupButton.addSelectionListener((SelectionListener)new GroupPathChooserButtonListener(this.groupNames, this.groupPathText, this.getShell()));
        this.documenationText = this.addLabelAndTextfieldForPropertyToComposite((Composite)toolPropertiesGroup, "Documentation: ", "documentationFilePath");
        Button chooseDocButton = new Button((Composite)toolPropertiesGroup, 8);
        chooseDocButton.setText(DOTS);
        this.docPathChooserButtonListener = new PathChooserButtonListener(this.documenationText, false, new String[]{"*.txt;*.pdf", "*.txt", "*.pdf"}, this.getShell());
        chooseDocButton.addSelectionListener((SelectionListener)this.docPathChooserButtonListener);
        this.documenationText.addModifyListener(e -> {
            ComponentDescriptionValidator validator = new ComponentDescriptionValidator();
            this.docValidationMessage = validator.validateDoc(this.documenationText, ((ToolIntegrationWizard)this.getWizard()).getCurrentContext(), (String)this.configurationMap.get("toolName"));
            this.validate(true);
        });
        Label toolDescriptionLabel = new Label((Composite)toolPropertiesGroup, 0);
        toolDescriptionLabel.setText(Messages.toolDescription);
        GridData toolDescriptionLabelData = new GridData();
        toolDescriptionLabelData.verticalAlignment = 1;
        toolDescriptionLabel.setLayoutData((Object)toolDescriptionLabelData);
        this.descriptionTextArea = new Text((Composite)toolPropertiesGroup, 2626);
        this.descriptionTextArea.setData("key", (Object)"toolDescription");
        this.descriptionTextArea.addModifyListener(ignored -> {
            Object object = this.configurationMap.put((String)this.descriptionTextArea.getData("key"), this.descriptionTextArea.getText());
        });
        this.descriptionTextArea.addTraverseListener((TraverseListener)new DescriptionTraverseListener());
        GridData descriptionData = new GridData(1808);
        descriptionData.heightHint = 50;
        descriptionData.horizontalSpan = 2;
        this.descriptionTextArea.setLayoutData((Object)descriptionData);
        Group userInformationGroup = new Group(toolDataComp, 0);
        userInformationGroup.setText(Messages.userInformationGroup);
        userInformationGroup.setLayout((Layout)new GridLayout(2, false));
        GridData userInfoData = new GridData(768);
        userInformationGroup.setLayoutData((Object)userInfoData);
        this.integratorName = this.addLabelAndTextfieldForPropertyToComposite((Composite)userInformationGroup, Messages.nameIntegrator, "toolIntegratorName");
        this.integratorEmail = this.addLabelAndTextfieldForPropertyToComposite((Composite)userInformationGroup, Messages.email, "toolIntegratorE-Mail");
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), HELP_CONTEXT_ID);
        this.validate(false);
    }

    private Text addLabelAndTextfieldForPropertyToComposite(Composite composite, String propertyMessage, String key) {
        Label propertyLabel = new Label(composite, 0);
        propertyLabel.setText(propertyMessage);
        Point prefSize = propertyLabel.computeSize(-1, -1);
        GridData labelData = new GridData();
        labelData.widthHint = prefSize.x;
        propertyLabel.setLayoutData((Object)labelData);
        Text propertyText = new Text(composite, 2048);
        GridData gridDataText = new GridData(768);
        propertyText.setLayoutData((Object)gridDataText);
        propertyText.setData("key", (Object)key);
        propertyText.addModifyListener(ignored -> {
            Object object = this.configurationMap.put((String)propertyText.getData("key"), propertyText.getText());
        });
        return propertyText;
    }

    private void validate(boolean update) {
        this.setMessage(null, 0);
        this.setPageComplete(true);
        String name = (String)this.configurationMap.get("toolName");
        if (name == null || name.trim().isEmpty()) {
            this.setMessage(Messages.toolFilenameInvalid, 3);
            this.setPageComplete(false);
        } else if (!update && this.usedToolnames.contains(this.configurationMap.get("toolName"))) {
            this.setMessage(Messages.toolFilenameUsed, 3);
            this.setPageComplete(false);
        }
        if (this.docValidationMessage.isPresent()) {
            this.setMessage(this.docValidationMessage.get(), 3);
            this.setPageComplete(false);
        }
        if (this.groupValidationMessage.isPresent()) {
            this.setMessage(this.groupValidationMessage.get(), 3);
            this.setPageComplete(false);
        }
        if (this.iconValidationMessage.isPresent()) {
            if (this.iconValidationMessage.get().equals("Icon path or file format is invalid. The default icon will be used.")) {
                this.setMessage(this.iconValidationMessage.get(), 2);
                this.setPageComplete(true);
            } else {
                this.setMessage(this.iconValidationMessage.get(), 3);
                this.setPageComplete(false);
            }
        }
        if (this.nameValidationMessage.isPresent()) {
            this.setMessage(this.nameValidationMessage.get(), 3);
            this.setPageComplete(false);
        }
    }

    @Override
    public void setConfigMap(Map<String, Object> newConfigurationMap) {
        this.configurationMap = newConfigurationMap;
        if (this.configurationMap.get("toolName") != null) {
            this.nameOrigin = Optional.of(String.valueOf(this.configurationMap.get("toolName")));
        }
        this.configurationMap.putIfAbsent("uploadIcon", true);
        this.updatePageValues();
    }

    private void updatePageValues() {
        if ((String)this.configurationMap.get("toolName") != null) {
            this.toolNameText.setText((String)this.configurationMap.get("toolName"));
        } else {
            this.toolNameText.setText("");
        }
        if (this.configurationMap.get("toolIconPath") != null) {
            this.iconText.setText((String)this.configurationMap.get("toolIconPath"));
        } else {
            this.iconText.setText("");
        }
        this.uploadIconToFolder.setSelection(Boolean.TRUE.equals(this.configurationMap.get("uploadIcon")));
        if (this.configurationMap.get("documentationFilePath") != null) {
            this.documenationText.setText((String)this.configurationMap.get("documentationFilePath"));
            File pathToOpen = new File(this.documenationText.getText());
            if (!pathToOpen.isAbsolute()) {
                IntegrationContext context = ((ToolIntegrationWizard)this.getWizard()).getCurrentContext();
                pathToOpen = new File(new File(new File(context.getRootPathToToolIntegrationDirectory(), context.getNameOfToolIntegrationDirectory()), (String)this.configurationMap.get("toolName")), "docs");
            }
            this.docPathChooserButtonListener.setOpenPath(pathToOpen);
        } else {
            this.documenationText.setText("");
        }
        if (this.configurationMap.get("groupName") != null) {
            this.groupPathText.setText((String)this.configurationMap.get("groupName"));
        } else {
            this.groupPathText.setText("");
        }
        if (this.configurationMap.get("toolDescription") != null) {
            this.descriptionTextArea.setText((String)this.configurationMap.get("toolDescription"));
        } else {
            this.descriptionTextArea.setText("");
        }
        if (this.configurationMap.get("toolIntegratorName") != null) {
            this.integratorName.setText((String)this.configurationMap.get("toolIntegratorName"));
        } else {
            this.integratorName.setText("");
        }
        if (this.configurationMap.get("toolIntegratorE-Mail") != null) {
            this.integratorEmail.setText((String)this.configurationMap.get("toolIntegratorE-Mail"));
        } else {
            this.integratorEmail.setText("");
        }
        this.validate(true);
    }

    public void performHelp() {
        super.performHelp();
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.displayHelp(HELP_CONTEXT_ID);
    }

    @Override
    public void updatePage() {
    }

    private class DescriptionTraverseListener
    implements TraverseListener {
        private DescriptionTraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 16) {
                e.doit = true;
            }
        }
    }
}

