/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.validators.internal;

import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResultFactory;
import de.rcenvironment.core.start.common.validation.spi.DefaultInstanceValidator;
import de.rcenvironment.core.utils.common.StringUtils;

public class LauncherVersionValidator
extends DefaultInstanceValidator {
    private static final String VALIDATION_DISPLAY_NAME = "Launcher Version";
    private static final String SYSTEM_PROPERTY_KEY_RCE_LAUNCHER_VERSION = "de.rcenvironment.launcher.version";
    private static final int EXPECTED_RCE_LAUNCHER_VERSION = 810;

    public InstanceValidationResult validate() {
        String actualLauncherVersionStr = System.getProperty(SYSTEM_PROPERTY_KEY_RCE_LAUNCHER_VERSION);
        if (actualLauncherVersionStr == null) {
            return InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown((String)VALIDATION_DISPLAY_NAME, (String)"RCE was started with an unexpected application launcher (no version information provided)", (String)"RCE was started with an unexpected application launcher (no version information provided)");
        }
        try {
            int runningLauncherVersion = Integer.parseInt(actualLauncherVersionStr);
            if (runningLauncherVersion != 810) {
                String message = StringUtils.format((String)"RCE was apparently restarted after an update. Due to internal changes, a full shutdown and fresh start of the application is required instead. (Running launcher version: %d, expected version: %d)", (Object[])new Object[]{runningLauncherVersion, 810});
                return InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown((String)VALIDATION_DISPLAY_NAME, (String)message, (String)message);
            }
            return InstanceValidationResultFactory.createResultForPassed((String)VALIDATION_DISPLAY_NAME);
        }
        catch (NumberFormatException numberFormatException) {
            return InstanceValidationResultFactory.createResultForFailureWhichAllowsToProceed((String)VALIDATION_DISPLAY_NAME, (String)"RCE was started with an unknown application launcher. This can result in undefined behaviour.", (String)"RCE was started with an unknown application launcher. This can result in undefined behaviour.");
        }
    }
}

