/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.rpc.internal;

import de.rcenvironment.core.communication.common.SerializationException;
import de.rcenvironment.core.communication.rpc.ServiceCallRequest;
import de.rcenvironment.core.communication.utils.MessageUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ServiceCallSerializer {
    private static final int OUTGOING_NETWORK_PAYLOAD_SIZE_WARNING_THRESHOLD = 0x100000;
    private final boolean verboseRequestLoggingEnabled = DebugSettings.getVerboseLoggingEnabled((String)"RemoteServiceCalls");
    private final Log log = LogFactory.getLog(this.getClass());

    public byte[] getSerializedForm(ServiceCallRequest serviceCallRequest) throws SerializationException {
        byte[] serializedRequest = MessageUtils.serializeObject(serviceCallRequest);
        if (this.verboseRequestLoggingEnabled) {
            this.log.debug((Object)StringUtils.format((String)"Converted RPC for %s.%s() on %s into a network payload of %d bytes; rRPC stream: %s", (Object[])new Object[]{serviceCallRequest.getServiceName(), serviceCallRequest.getMethodName(), serviceCallRequest.getTargetNodeId(), serializedRequest.length, serviceCallRequest.getReliableRPCStreamId()}));
        }
        if (serializedRequest.length >= 0x100000) {
            this.log.debug((Object)StringUtils.format((String)"Generated a large network message for an RPC to %s.%s() on %s (payload size: %d bytes)", (Object[])new Object[]{serviceCallRequest.getServiceName(), serviceCallRequest.getMethodName(), serviceCallRequest.getTargetNodeId(), serializedRequest.length}));
        }
        return serializedRequest;
    }
}

