/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.routing.internal.v2;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.communication.routing.internal.v2.Link;
import de.rcenvironment.core.communication.routing.internal.v2.LinkState;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class LinkStateSerializer {
    private LinkStateSerializer() {
    }

    public static String serialize(LinkState state) {
        return LinkStateSerializer.serialize(state.getLinks());
    }

    public static String serialize(Collection<Link> links) {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            ArrayList<LinkStateJsonStub> stubList = new ArrayList<LinkStateJsonStub>();
            for (Link link : links) {
                stubList.add(new LinkStateJsonStub(link));
            }
            return mapper.writeValueAsString(stubList);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error serializing local link state", e);
        }
    }

    public static LinkState deserialize(String serialized) throws IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            List stubList = (List)mapper.readValue(serialized, (TypeReference)new TypeReference<List<LinkStateJsonStub>>(){});
            ArrayList<Link> links = new ArrayList<Link>();
            for (LinkStateJsonStub stub : stubList) {
                links.add(stub.toLink());
            }
            return new LinkState(links);
        }
        catch (IOException e) {
            throw new IOException("Failed to parse link state data: linkStateData", e);
        }
    }

    private static class LinkStateJsonStub {
        public String id;
        public String node;

        LinkStateJsonStub() {
        }

        LinkStateJsonStub(Link link) {
            this.id = link.getLinkId();
            this.node = link.getNodeIdString();
        }

        public Link toLink() {
            return new Link(this.id, this.node);
        }
    }
}

