/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.routing.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.model.NetworkRequest;
import de.rcenvironment.core.communication.model.NetworkResponse;
import de.rcenvironment.core.communication.model.NetworkResponseHandler;
import de.rcenvironment.core.communication.protocol.NetworkResponseFactory;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WaitForResponseBlocker
implements NetworkResponseHandler {
    private static final boolean VERBOSE_LOGGING = DebugSettings.getVerboseLoggingEnabled(WaitForResponseBlocker.class);
    private static final Log sharedLog = LogFactory.getLog(WaitForResponseBlocker.class);
    private final NetworkRequest request;
    private final InstanceNodeSessionId eventNodeId;
    private final CountDownLatch responseReceivedLatch;
    private NetworkResponse response;
    private volatile String logMarker = null;

    public WaitForResponseBlocker(NetworkRequest request, InstanceNodeSessionId localNodeId) {
        this.request = request;
        this.eventNodeId = localNodeId;
        this.responseReceivedLatch = new CountDownLatch(1);
    }

    @Override
    public void onResponseAvailable(NetworkResponse receivedResponse) {
        this.response = receivedResponse;
        this.responseReceivedLatch.countDown();
    }

    public NetworkResponse await(long requestTimeoutMsec) {
        if (VERBOSE_LOGGING) {
            sharedLog.debug((Object)("Waiting for response callback (" + this.logMarker + ")"));
        }
        try {
            if (this.responseReceivedLatch.await(requestTimeoutMsec, TimeUnit.MILLISECONDS)) {
                if (VERBOSE_LOGGING) {
                    sharedLog.debug((Object)("Received response callback (" + this.logMarker + ")"));
                }
                return this.response;
            }
            sharedLog.debug((Object)("Timeout reached while waiting for a network response to request " + this.request.getRequestId()));
            return NetworkResponseFactory.generateResponseForTimeoutWaitingForResponse(this.request, this.eventNodeId);
        }
        catch (InterruptedException e) {
            String errorId = LogUtils.logErrorAndAssignUniqueMarker((Log)sharedLog, (String)("Interrupted while waiting for a network response: " + e.toString()));
            return NetworkResponseFactory.generateResponseForErrorDuringDelivery(this.request, this.eventNodeId, errorId);
        }
    }

    public void setLogMarker(String logMarker) {
        this.logMarker = logMarker;
    }
}

