/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.connection.internal;

import de.rcenvironment.core.command.spi.AbstractCommandParameter;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandModifierInfo;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.command.spi.IntegerParameter;
import de.rcenvironment.core.command.spi.MainCommandDescription;
import de.rcenvironment.core.command.spi.ParsedCommandModifiers;
import de.rcenvironment.core.command.spi.ParsedIntegerParameter;
import de.rcenvironment.core.command.spi.ParsedStringParameter;
import de.rcenvironment.core.command.spi.StringParameter;
import de.rcenvironment.core.command.spi.SubCommandDescription;
import de.rcenvironment.core.communication.connection.api.ConnectionSetup;
import de.rcenvironment.core.communication.connection.api.ConnectionSetupService;
import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.utils.NetworkContactPointUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Collection;

public class ConnectionSetupCommandPlugin
implements CommandPlugin {
    private static final String CMD_CN = "cn";
    private static final String ID_DESC = "id";
    private static final StringParameter TARGET_PARAMETER = new StringParameter(null, "target", "target of the connection");
    private static final StringParameter DESCRIPTION_PARAMETER = new StringParameter(null, "description", "description of the connection");
    private static final IntegerParameter ID_PARAMETER = new IntegerParameter(null, "id", "id of the connection");
    private ConnectionSetupService connectionSetupService;

    public MainCommandDescription[] getCommands() {
        MainCommandDescription commands = new MainCommandDescription(CMD_CN, "manage network connections", "alias for \"cn list\"", this::performList, new SubCommandDescription[]{new SubCommandDescription("add", "add a new network connection (Example: cn add activemq-tcp:rceserver.example.com:20001 \"Our RCE Server\")", this::performAdd, new CommandModifierInfo(new AbstractCommandParameter[]{TARGET_PARAMETER, DESCRIPTION_PARAMETER})), new SubCommandDescription("list", "lists all network connections, including ids and connection states", this::performList), new SubCommandDescription("start", "starts/connects a READY or DISCONNECTED connection (use \"cn list\" to get the id)", this::performStart, new CommandModifierInfo(new AbstractCommandParameter[]{ID_PARAMETER})), new SubCommandDescription("stop", "stops/disconnects an ESTABLISHED connection (use \"cn list\" to get the id)", this::performStop, new CommandModifierInfo(new AbstractCommandParameter[]{ID_PARAMETER}))});
        return new MainCommandDescription[]{commands};
    }

    public void bindConnectionSetupService(ConnectionSetupService newInstance) {
        this.connectionSetupService = newInstance;
    }

    private void performList(CommandContext context) {
        Collection<ConnectionSetup> setups = this.connectionSetupService.getAllConnectionSetups();
        for (ConnectionSetup setup : setups) {
            String optionalSuffix = "";
            String currentChannelId = setup.getCurrentChannelId();
            if (currentChannelId != null) {
                optionalSuffix = " [" + currentChannelId + "]";
            }
            context.println((Object)StringUtils.format((String)"  (%d) '%s' [%s] - %s%s", (Object[])new Object[]{setup.getId(), setup.getDisplayName(), setup.getNetworkContactPointString(), setup.getState(), optionalSuffix}));
        }
    }

    private void performAdd(CommandContext context) {
        NetworkContactPoint ncp;
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        ParsedStringParameter descParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(0);
        String contactPointStr = ((ParsedStringParameter)modifiers.getPositionalCommandParameter(0)).getResult();
        try {
            ncp = NetworkContactPointUtils.parseStringRepresentation(contactPointStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            context.println((Object)("Invalid target description: " + contactPointStr));
            return;
        }
        String displayName = descParameter.getResult() != null ? descParameter.getResult() : "<" + contactPointStr + ">";
        if (this.connectionSetupService.connectionAlreadyExists(ncp)) {
            context.println((Object)StringUtils.format((String)"Connection setup to host '%s:%d' already exists.", (Object[])new Object[]{ncp.getHost(), ncp.getPort()}));
            return;
        }
        ConnectionSetup setup = this.connectionSetupService.createConnectionSetup(ncp, displayName, true);
        context.println((Object)("Connection added, id=" + setup.getId()));
        this.performList(context);
    }

    private void performStart(CommandContext context) {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        long id = ((ParsedIntegerParameter)modifiers.getPositionalCommandParameter(0)).getResult().intValue();
        ConnectionSetup setup = this.connectionSetupService.getConnectionSetupById(id);
        if (setup == null) {
            context.println((Object)"Error: unknown connection id");
            return;
        }
        setup.signalStartIntent();
    }

    private void performStop(CommandContext context) {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        long id = ((ParsedIntegerParameter)modifiers.getPositionalCommandParameter(0)).getResult().intValue();
        ConnectionSetup setup = this.connectionSetupService.getConnectionSetupById(id);
        if (setup == null) {
            context.println((Object)"Error: unknown connection id");
            return;
        }
        setup.signalStopIntent();
    }
}

