/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.common;

import de.rcenvironment.core.communication.api.NodeIdentifierService;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.InstanceNodeId;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.LogicalNodeSessionId;
import de.rcenvironment.core.communication.common.NodeIdentifierContextHolder;
import de.rcenvironment.core.communication.common.impl.NodeIdentifierServiceImpl;
import de.rcenvironment.toolkit.utils.common.IdGenerator;
import de.rcenvironment.toolkit.utils.common.IdGeneratorType;
import org.apache.commons.logging.LogFactory;

public final class NodeIdentifierTestUtils {
    private static NodeIdentifierService sharedTestNodeIdentifierService;
    private static boolean allowImplicitNodeIdServiceCreation;

    static {
        allowImplicitNodeIdServiceCreation = true;
    }

    private NodeIdentifierTestUtils() {
    }

    public static String createTestInstanceNodeIdString() {
        return IdGenerator.fastRandomHexString((int)32);
    }

    public static InstanceNodeId createTestInstanceNodeId() {
        return NodeIdentifierTestUtils.getTestNodeIdentifierService().generateInstanceNodeId();
    }

    public static String createTestInstanceNodeSessionIdString() {
        return NodeIdentifierTestUtils.createTestInstanceNodeSessionId().getInstanceNodeSessionIdString();
    }

    public static InstanceNodeSessionId createTestInstanceNodeSessionId() {
        return NodeIdentifierTestUtils.getTestNodeIdentifierService().generateInstanceNodeSessionId(NodeIdentifierTestUtils.getTestNodeIdentifierService().generateInstanceNodeId());
    }

    public static InstanceNodeSessionId createTestInstanceNodeSessionId(String instanceId) {
        try {
            return NodeIdentifierTestUtils.getTestNodeIdentifierService().generateInstanceNodeSessionId(NodeIdentifierTestUtils.getTestNodeIdentifierService().parseInstanceNodeIdString(instanceId));
        }
        catch (IdentifierException e) {
            throw new RuntimeException("Error creating test instance session id", e);
        }
    }

    public static InstanceNodeSessionId createTestInstanceNodeSessionIdWithDisplayName(String displayName) {
        InstanceNodeSessionId id = NodeIdentifierTestUtils.createTestInstanceNodeSessionId();
        NodeIdentifierTestUtils.getTestNodeIdentifierService().associateDisplayName(id, displayName);
        return id;
    }

    public static InstanceNodeSessionId createTestInstanceNodeSessionIdWithDisplayName(InstanceNodeId instanceId, String displayName) {
        InstanceNodeSessionId id = NodeIdentifierTestUtils.getTestNodeIdentifierService().generateInstanceNodeSessionId(instanceId);
        NodeIdentifierTestUtils.getTestNodeIdentifierService().associateDisplayName(id, displayName);
        return id;
    }

    public static LogicalNodeId createTestDefaultLogicalNodeId() {
        LogicalNodeId id = NodeIdentifierTestUtils.getTestNodeIdentifierService().generateInstanceNodeId().convertToDefaultLogicalNodeId();
        return id;
    }

    public static LogicalNodeSessionId createTestLogicalNodeSessionId(boolean useDefaultLogicalNode) {
        if (!useDefaultLogicalNode) {
            throw new IllegalArgumentException("Not supported yet");
        }
        LogicalNodeSessionId id = NodeIdentifierTestUtils.createTestInstanceNodeSessionId().convertToDefaultLogicalNodeSessionId();
        return id;
    }

    public static LogicalNodeSessionId createTestLogicalNodeSessionIdWithDisplayName(String displayName, boolean useDefaultLogicalNode) {
        if (!useDefaultLogicalNode) {
            throw new IllegalArgumentException("Not supported yet");
        }
        InstanceNodeSessionId instanceNodeSessionId = NodeIdentifierTestUtils.createTestInstanceNodeSessionId();
        LogicalNodeSessionId id = instanceNodeSessionId.convertToDefaultLogicalNodeSessionId();
        NodeIdentifierTestUtils.getTestNodeIdentifierService().associateDisplayName(instanceNodeSessionId, displayName);
        return id;
    }

    public static synchronized NodeIdentifierService getTestNodeIdentifierService() {
        if (sharedTestNodeIdentifierService == null) {
            if (!allowImplicitNodeIdServiceCreation) {
                throw new RuntimeException("Received a method call that requires a NodeIdentifierService, but implicit instance creation was forbidden");
            }
            LogFactory.getLog(NodeIdentifierTestUtils.class).debug((Object)"Creating implicit NodeIdentifierService; this message should only apppear during test execution");
            sharedTestNodeIdentifierService = new NodeIdentifierServiceImpl(IdGeneratorType.FAST);
        }
        return sharedTestNodeIdentifierService;
    }

    public static synchronized void resetTestNodeIdentifierService(boolean allowImplicitCreation) {
        sharedTestNodeIdentifierService = null;
        allowImplicitNodeIdServiceCreation = allowImplicitCreation;
    }

    public static void attachTestNodeIdentifierServiceToCurrentThread() {
        NodeIdentifierService current = NodeIdentifierContextHolder.getRawDeserializationServiceForCurrentThread();
        if (current != null) {
            if (current != NodeIdentifierTestUtils.getTestNodeIdentifierService()) {
                throw new IllegalStateException("There is already another " + NodeIdentifierService.class.getSimpleName() + " attached to the current test thread");
            }
            throw new IllegalStateException("The shared test " + NodeIdentifierService.class.getSimpleName() + " has already been attached to the current test thread; " + "most likely, a previous test did not call the clean up method after setting it");
        }
        NodeIdentifierContextHolder.setDeserializationServiceForCurrentThread(NodeIdentifierTestUtils.getTestNodeIdentifierService());
    }

    public static void removeTestNodeIdentifierServiceFromCurrentThread() {
        NodeIdentifierService current = NodeIdentifierContextHolder.getRawDeserializationServiceForCurrentThread();
        if (current != null && current != NodeIdentifierTestUtils.getTestNodeIdentifierService()) {
            throw new IllegalStateException("Unexpected " + NodeIdentifierService.class.getSimpleName() + " found attached to the current test thread");
        }
        NodeIdentifierContextHolder.setDeserializationServiceForCurrentThread(null);
    }
}

