/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.scripting;

public final class ScriptLanguage
extends Enum<ScriptLanguage> {
    public static final /* enum */ ScriptLanguage Python = new ScriptLanguage("Python", "py");
    public static final /* enum */ ScriptLanguage PythonExp = new ScriptLanguage("Python (Python Agent)", "py");
    public static final /* enum */ ScriptLanguage Jython = new ScriptLanguage("Jython", "py");
    public static final /* enum */ ScriptLanguage JavaScript = new ScriptLanguage("JavaScript", "js");
    private final String name;
    private final String extension;
    private static final /* synthetic */ ScriptLanguage[] ENUM$VALUES;

    static {
        ENUM$VALUES = new ScriptLanguage[]{Python, PythonExp, Jython, JavaScript};
    }

    private ScriptLanguage(String name, String extension) {
        this.name = name;
        this.extension = extension;
    }

    public String getName() {
        return this.name;
    }

    public String getExtension() {
        return this.extension;
    }

    public static ScriptLanguage getByName(String name) throws IllegalArgumentException {
        assert (name != null && !name.isEmpty());
        ScriptLanguage result = null;
        ScriptLanguage[] scriptLanguageArray = ScriptLanguage.values();
        int n = scriptLanguageArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScriptLanguage language = scriptLanguageArray[n2];
            if (language.name.equals(name)) {
                result = language;
                break;
            }
            ++n2;
        }
        if (result == null) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public static ScriptLanguage getByExtension(String extension) throws IllegalArgumentException {
        assert (extension != null && !extension.isEmpty());
        assert (extension.matches("^[-_a-zA-Z0-9]+$"));
        ScriptLanguage result = null;
        ScriptLanguage[] scriptLanguageArray = ScriptLanguage.values();
        int n = scriptLanguageArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScriptLanguage language = scriptLanguageArray[n2];
            if (language.extension.equals(extension)) {
                result = language;
                break;
            }
            ++n2;
        }
        if (result == null) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public static ScriptLanguage[] values() {
        ScriptLanguage[] scriptLanguageArray = ENUM$VALUES;
        int n = scriptLanguageArray.length;
        ScriptLanguage[] scriptLanguageArray2 = new ScriptLanguage[n];
        System.arraycopy(ENUM$VALUES, 0, scriptLanguageArray2, 0, n);
        return scriptLanguageArray2;
    }

    public static ScriptLanguage valueOf(String string) {
        return Enum.valueOf(ScriptLanguage.class, string);
    }

    public static class NoEngineException
    extends RuntimeException {
        private static final long serialVersionUID = -593738405021184970L;
        private final ScriptLanguage language;

        public NoEngineException(ScriptLanguage language) {
            this.language = language;
        }

        public NoEngineException(ScriptLanguage language, Throwable cause) {
            super(cause);
            this.language = language;
        }

        public NoEngineException(String message, ScriptLanguage language) {
            super(message);
            this.language = language;
        }

        public NoEngineException(String message, Throwable cause, ScriptLanguage language) {
            super(message, cause);
            this.language = language;
        }

        public ScriptLanguage getLanguage() {
            return this.language;
        }
    }
}

