/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.datamanagement.browser;

import de.rcenvironment.core.authentication.AuthenticationException;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.datamanagement.api.DefaultComponentHistoryDataItem;
import de.rcenvironment.core.datamanagement.MetaDataService;
import de.rcenvironment.core.datamanagement.commons.ComponentInstance;
import de.rcenvironment.core.datamanagement.commons.ComponentRun;
import de.rcenvironment.core.datamanagement.commons.EndpointData;
import de.rcenvironment.core.datamanagement.commons.MetaData;
import de.rcenvironment.core.datamanagement.commons.MetaDataSet;
import de.rcenvironment.core.datamanagement.commons.WorkflowRun;
import de.rcenvironment.core.datamanagement.commons.WorkflowRunDescription;
import de.rcenvironment.core.datamodel.api.FinalComponentRunState;
import de.rcenvironment.core.datamodel.api.FinalWorkflowState;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.gui.datamanagement.browser.DMBrowserImages;
import de.rcenvironment.core.gui.datamanagement.browser.DMBrowserNodeContentAvailabilityHandler;
import de.rcenvironment.core.gui.datamanagement.browser.Messages;
import de.rcenvironment.core.gui.datamanagement.browser.spi.CommonHistoryDataItemSubtreeBuilderUtils;
import de.rcenvironment.core.gui.datamanagement.browser.spi.ComponentHistoryDataItemSubtreeBuilder;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNode;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNodeType;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNodeUtils;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.VersionUtils;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncExceptionListener;
import de.rcenvironment.toolkit.modules.concurrency.api.CallablesGroup;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Version;

public class DMContentProvider
implements ITreeContentProvider {
    private static final String BRACKET_RIGHT = "]";
    private static final String BRACKET_LEFT = " [";
    private static final String FAILED = "FAILED";
    private static final String VERIFICATION_FAILED = "RESULTS_REJECTED";
    private static final String FINISHED = "FINISHED";
    private static final int HUNDRET = 100;
    private static final double FLOAT_ONE_HUNDRED = 100.0;
    private static final double FLOAT_KILO_BYTE = 1024.0;
    private static final String NODE_TEXT_FORMAT_TITLE_PLUS_STATE = "%s --> %s";
    private static final String NOT_TERMINATED_YET = "not terminated yet";
    private static final String NOT_YET_AVAILABLE = "Not yet available";
    private static final String UNKNOWN = "(unknown)";
    private static final String REMOTE = "remote";
    private static final String LOCAL = "local";
    private static final String NO_BUILDER_ERROR_MESSAGE = "No subtree builder found for history data item with identifier: ";
    private static final String NODE_TEXT_FORMAT_TITLE_PLUS_HOSTNAME = "%s <%s>";
    private static final String NODE_TEXT_FORMAT_TITLE_PLUS_TIMESTAMP_AND_HOST = "%s (%s)  <%s>";
    private static final String COMPONENT_NAME_AND_NODE_TEXT_FORMAT_TITLE_PLUS_TIMESTAMP_AND_HOST = "%s - %s (%s)  <%s>";
    private static final MetaData METADATA_COMPONENT_CONTEXT_ID = new MetaData("rce.common.component_context_uuid", true, true);
    private static final MetaData METADATA_WORKFLOW_FILES_DELETED = new MetaData("rce.common.workflow_files_deleted", true, true);
    private static final MetaData METADATA_WORKFLOW_IS_MARKED_FOR_DELETION = new MetaData("rce.common.workflow_marked_for_deletion", true, true);
    private static final MetaData METADATA_COMPONENT_CONTEXT_NAME = new MetaData("rce.common.component_context_name", true, true);
    private static final MetaData METADATA_INSTANCE_NODE_IDENTIFIER = new MetaData("rce.common.node_id", true, true);
    private static final MetaData METADATA_COMPONENT_NAME = new MetaData("rce.common.component_name", true, true);
    private static final MetaData METADATA_HISTORY_DATA_ITEM_IDENTIFIER = new MetaData("rce.history.classname", true, true);
    private static final MetaData METADATA_HISTORY_USER_INFO_TEXT = new MetaData("rce.history.infotext", true, true);
    private static final MetaData METADATA_WORKFLOW_FINAL_STATE = new MetaData("rce.common.workflow_final_state", true, true);
    private static final MetaData METADATA_HISTORY_ORDERING = new MetaData("rce.history.orderingindex", true, true);
    private static final String EXTENSION_POINT_ID_SUBTREE_BUILDER = "de.rcenvironment.core.gui.datamanagement.browser.historysubtreebuilder";
    protected final Log log = LogFactory.getLog(this.getClass());
    private final boolean verboseLogging = DebugSettings.getVerboseLoggingEnabled(this.getClass());
    private MetaDataService metaDataService;
    private Map<String, ComponentHistoryDataItemSubtreeBuilder> historySubtreeBuilders;
    private Map<DMBrowserNode, WorkflowRun> workflowMetaDataMap = new HashMap<DMBrowserNode, WorkflowRun>();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final List<DMBrowserNodeContentAvailabilityHandler> contentAvailabilityHandlers = new CopyOnWriteArrayList<DMBrowserNodeContentAvailabilityHandler>();
    private final Set<DMBrowserNode> inProgress = new CopyOnWriteArraySet<DMBrowserNode>();
    private final Set<String> warningIsShown = new CopyOnWriteArraySet<String>();
    private InstanceNodeSessionId localInstanceSessionId;
    private TypedDatumSerializer typedDatumSerializer;

    public DMContentProvider() throws AuthenticationException {
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)this);
        this.metaDataService = (MetaDataService)serviceRegistryAccess.getService(MetaDataService.class);
        this.typedDatumSerializer = ((TypedDatumService)serviceRegistryAccess.getService(TypedDatumService.class)).getSerializer();
        this.localInstanceSessionId = ((PlatformService)serviceRegistryAccess.getService(PlatformService.class)).getLocalInstanceNodeSessionId();
        this.registerBuilders();
    }

    private void registerBuilders() {
        IConfigurationElement[] config;
        this.historySubtreeBuilders = new HashMap<String, ComponentHistoryDataItemSubtreeBuilder>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID_SUBTREE_BUILDER);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object o = e.createExecutableExtension("class");
                if (o instanceof ComponentHistoryDataItemSubtreeBuilder) {
                    ComponentHistoryDataItemSubtreeBuilder builder = (ComponentHistoryDataItemSubtreeBuilder)o;
                    String[] stringArray = builder.getSupportedHistoryDataItemIdentifier();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String supported = stringArray[n4];
                        if (this.historySubtreeBuilders.containsKey(supported)) {
                            throw new IllegalStateException("More than one builder tried to register for key " + supported);
                        }
                        this.historySubtreeBuilders.put(supported, builder);
                        ++n4;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Registered subtree builder " + o.getClass()));
                    }
                }
            }
            catch (CoreException ex) {
                this.log.error((Object)("Error registering extension " + e), (Throwable)ex);
            }
            ++n2;
        }
    }

    public DMBrowserNode[] getChildren(Object parent) {
        DMBrowserNode node = (DMBrowserNode)parent;
        if (node.areChildrenKnown()) {
            return node.getChildrenAsArray();
        }
        final RetrieverTask retrieverTask = new RetrieverTask(node);
        Job job = new Job(Messages.dataManagementBrowser){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(Messages.fetchingData, 3);
                    monitor.worked(2);
                    retrieverTask.run();
                    monitor.worked(1);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.schedule();
        DMBrowserNode waitSignalNode = new DMBrowserNode(Messages.waitSignalNodeLabel);
        waitSignalNode.setType(DMBrowserNodeType.Loading);
        waitSignalNode.markAsLeaf();
        return new DMBrowserNode[]{waitSignalNode};
    }

    /*
     * Unable to fully structure code
     */
    public void fetchChildren(Object parent) {
        block3: {
            try {
                this.createChildrenForNode((DMBrowserNode)parent);
                break block3;
            }
            catch (CommunicationException e) {
                ** for (handler : this.contentAvailabilityHandlers)
            }
lbl-1000:
            // 1 sources

            {
                handler.handleContentRetrievalError((DMBrowserNode)parent, (Exception)e);
                continue;
            }
        }
    }

    private void createChildrenForNode(DMBrowserNode node) throws CommunicationException {
        switch (node.getType()) {
            case HistoryRoot: {
                this.createChildrenForHistoryRootNode(node);
                break;
            }
            case Workflow: {
                this.createChildrenForWorkflowNode(node);
                break;
            }
            case Timeline: {
                this.createChildrenForTimelineNode(node);
                break;
            }
            case Components: {
                this.createChildrenForComponentsNode(node);
                break;
            }
            case Component: 
            case HistoryObject: {
                break;
            }
            case DMDirectoryReference: {
                CommonHistoryDataItemSubtreeBuilderUtils.buildSubtreeForDirectoryItem(node.getDirectoryReferenceTD(), node, node.getParent());
                break;
            }
            default: {
                this.log.warn((Object)("Unexpected node type: " + node.getType().name()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkflowRun getMetaDataForWorkflow(DMBrowserNode workflowNode) throws CommunicationException {
        Long workflowRunID = Long.valueOf(workflowNode.getMetaData().getValue(METADATA_COMPONENT_CONTEXT_ID));
        ResolvableNodeId workflowNodeId = workflowNode.getNodeIdentifier();
        Map<DMBrowserNode, WorkflowRun> map = this.workflowMetaDataMap;
        synchronized (map) {
            if (this.workflowMetaDataMap.containsKey(workflowNode)) {
                return this.workflowMetaDataMap.get(workflowNode);
            }
        }
        long start = System.currentTimeMillis();
        WorkflowRun result = null;
        try {
            this.log.debug((Object)StringUtils.format((String)"Fetching run data of workflow #%s from %s", (Object[])new Object[]{workflowRunID, workflowNodeId}));
            result = this.metaDataService.getWorkflowRun(workflowRunID, (NetworkDestination)workflowNodeId);
            this.log.debug((Object)StringUtils.format((String)"Finished fetching run data of workflow #%s from %s", (Object[])new Object[]{workflowRunID, workflowNodeId}));
        }
        catch (CommunicationException e) {
            Map<DMBrowserNode, WorkflowRun> map2 = this.workflowMetaDataMap;
            synchronized (map2) {
                this.workflowMetaDataMap.put(workflowNode, null);
            }
            this.log.debug((Object)StringUtils.format((String)"Failed to fetch run data of workflow #%s from %s", (Object[])new Object[]{workflowRunID, workflowNodeId}));
            throw e;
        }
        long millis = System.currentTimeMillis() - start;
        if (result == null) {
            this.log.error((Object)StringUtils.format((String)"Unable to fetch meta data of workflow #%d from node %s", (Object[])new Object[]{workflowRunID, workflowNode.getName()}));
        } else if (this.verboseLogging) {
            this.log.debug((Object)StringUtils.format((String)"Meta data query for workflow #%d ('%s') took %d ms", (Object[])new Object[]{workflowRunID, result.getWorkflowTitle(), millis}));
        }
        Map<DMBrowserNode, WorkflowRun> map3 = this.workflowMetaDataMap;
        synchronized (map3) {
            this.workflowMetaDataMap.put(workflowNode, result);
        }
        return result;
    }

    private void createChildrenForHistoryRootNode(DMBrowserNode parent) throws CommunicationException {
        long start = System.currentTimeMillis();
        Set workflowDescriptions = this.metaDataService.getWorkflowRunDescriptions();
        this.log.debug((Object)StringUtils.format((String)"query for all workflow run descriptions on all known nodes took %d ms", (Object[])new Object[]{System.currentTimeMillis() - start}));
        final HashMap<String, DMBrowserNode> encounteredContexts = new HashMap<String, DMBrowserNode>();
        HashMap encounteredContextsByInstanceNode = new HashMap();
        HashMap<String, Long> workflowStarts = new HashMap<String, Long>();
        for (WorkflowRunDescription workflowRunDescription : workflowDescriptions) {
            MetaDataSet mds = new MetaDataSet();
            String contextID = workflowRunDescription.getWorkflowRunID().toString();
            mds.setValue(METADATA_COMPONENT_CONTEXT_ID, contextID);
            String contextName = workflowRunDescription.getWorkflowTitle();
            mds.setValue(METADATA_COMPONENT_CONTEXT_NAME, contextName);
            String instanceNodeId = workflowRunDescription.getStorageLogicalNodeIdString();
            mds.setValue(METADATA_INSTANCE_NODE_IDENTIFIER, instanceNodeId);
            if (workflowRunDescription.getFinalState() != null) {
                mds.setValue(METADATA_WORKFLOW_FINAL_STATE, workflowRunDescription.getFinalState().toString());
            }
            mds.setValue(METADATA_WORKFLOW_FILES_DELETED, workflowRunDescription.getAreFilesDeleted().toString());
            mds.setValue(METADATA_WORKFLOW_IS_MARKED_FOR_DELETION, workflowRunDescription.isMarkedForDeletion().toString());
            DMBrowserNode contextDMObject = null;
            if (instanceNodeId == null) {
                contextDMObject = (DMBrowserNode)encounteredContexts.get(contextID);
            } else if (encounteredContexts.containsKey(instanceNodeId)) {
                contextDMObject = (DMBrowserNode)((Map)encounteredContextsByInstanceNode.get(instanceNodeId)).get(contextID);
            }
            String startTimeValue = workflowRunDescription.getStartTime().toString();
            mds.setValue(METADATA_HISTORY_ORDERING, startTimeValue);
            boolean startTimeSet = startTimeValue != null;
            Long workflowStart = (Long)workflowStarts.get(contextID);
            long startTime = startTimeSet ? Long.parseLong(startTimeValue) : 0L;
            if (contextDMObject == null) {
                contextDMObject = new DMBrowserNode(contextName, parent);
                contextDMObject.setName(contextName);
                contextDMObject.setMetaData(mds);
                contextDMObject.setType(DMBrowserNodeType.Workflow);
                contextDMObject.setWorkflowID(contextID);
                contextDMObject.setWorkflowControllerNode(workflowRunDescription.getControllerLogicalNodeId());
                parent.addChild(contextDMObject);
                if (instanceNodeId == null) {
                    encounteredContexts.put(contextID, contextDMObject);
                } else {
                    if (!encounteredContextsByInstanceNode.containsKey(instanceNodeId)) {
                        encounteredContextsByInstanceNode.put(instanceNodeId, new HashMap());
                    }
                    ((Map)encounteredContextsByInstanceNode.get(instanceNodeId)).put(contextID, contextDMObject);
                }
                workflowStarts.put(contextID, startTime);
                continue;
            }
            if (workflowStart <= startTime) continue;
            workflowStarts.put(contextID, startTime);
        }
        for (Map.Entry entry : encounteredContexts.entrySet()) {
            this.setupWorkflowNode((DMBrowserNode)entry.getValue());
        }
        CallablesGroup callablesGroup = ConcurrencyUtils.getFactory().createCallablesGroup(Void.class);
        for (String instanceNodeId : encounteredContextsByInstanceNode.keySet()) {
            final Map encounteredContextsPerInstanceNode = (Map)encounteredContextsByInstanceNode.get(instanceNodeId);
            callablesGroup.add((Callable)new Callable<Void>(){

                @Override
                @TaskDescription(value="Fetch data reference for workflow nodes by instance node id")
                public Void call() throws Exception {
                    for (Map.Entry entry : encounteredContextsPerInstanceNode.entrySet()) {
                        DMContentProvider.this.setupWorkflowNode((DMBrowserNode)entry.getValue());
                    }
                    return null;
                }
            });
        }
        callablesGroup.add((Callable)new Callable<Void>(){

            @Override
            @TaskDescription(value="Fetch data reference for workflow nodes")
            public Void call() throws Exception {
                for (Map.Entry entry : encounteredContexts.entrySet()) {
                    DMContentProvider.this.setupWorkflowNode((DMBrowserNode)entry.getValue());
                }
                return null;
            }
        });
        callablesGroup.executeParallel(new AsyncExceptionListener(){

            public void onAsyncException(Exception e) {
                if (e.getCause() == null) {
                    DMContentProvider.this.log.warn((Object)("Asynchronous exception during parallel data reference query: " + e.toString()));
                } else {
                    DMContentProvider.this.log.warn((Object)"Asynchronous exception during parallel data reference query", (Throwable)e);
                }
            }
        });
        parent.sortChildren(DMBrowserNodeUtils.COMPARATOR_BY_HISTORY_TIMESTAMP_DESC);
    }

    private void setupWorkflowNode(DMBrowserNode workflowNode) {
        if (this.isLocalWorkflow(workflowNode.getWorkflowControllerNode())) {
            workflowNode.setWorkflowHostName(LOCAL);
        } else {
            workflowNode.setWorkflowHostName(REMOTE);
        }
        String wfNodeTitle = StringUtils.format((String)NODE_TEXT_FORMAT_TITLE_PLUS_HOSTNAME, (Object[])new Object[]{workflowNode.getName(), workflowNode.getWorkflowHostName()});
        String finalState = workflowNode.getMetaData().getValue(METADATA_WORKFLOW_FINAL_STATE);
        if (finalState == null) {
            wfNodeTitle = StringUtils.format((String)NODE_TEXT_FORMAT_TITLE_PLUS_STATE, (Object[])new Object[]{wfNodeTitle, NOT_TERMINATED_YET});
        } else {
            this.setWorkflowNodeIconFromFinalState(workflowNode, this.getFinalStateFromString(finalState));
        }
        workflowNode.setTitle(wfNodeTitle);
    }

    private boolean isLocalWorkflow(LogicalNodeId logicalNodeId) {
        return this.localInstanceSessionId.isSameInstanceNodeAs((ResolvableNodeId)logicalNodeId);
    }

    private FinalWorkflowState getFinalStateFromString(String finalState) {
        if (finalState != null) {
            return FinalWorkflowState.valueOf((String)finalState);
        }
        return null;
    }

    private void setWorkflowNodeIconFromFinalState(DMBrowserNode workflowNode, FinalWorkflowState finalState) {
        if (finalState != null) {
            switch (finalState) {
                case CANCELLED: {
                    workflowNode.setIcon(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.CANCELLED));
                    break;
                }
                case FINISHED: {
                    workflowNode.setIcon(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.FINISHED));
                    break;
                }
                case FAILED: {
                    workflowNode.setIcon(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.FAILED));
                    break;
                }
                case RESULTS_REJECTED: {
                    workflowNode.setIcon(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.RESULTS_REJECTED));
                    break;
                }
                case CORRUPTED: {
                    workflowNode.setIcon(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.CORRUPTED));
                    break;
                }
            }
        } else {
            workflowNode.setIcon(null);
        }
    }

    private void createChildrenForWorkflowNode(DMBrowserNode workflowNode) throws CommunicationException {
        LogicalNodeId nodeId;
        WorkflowRun workflowRun = this.getMetaDataForWorkflow(workflowNode);
        if (workflowRun == null) {
            workflowNode.setEnabled(false);
            return;
        }
        if (workflowRun.getFinalState() != null) {
            workflowNode.getMetaData().setValue(METADATA_WORKFLOW_FINAL_STATE, workflowRun.getFinalState().toString());
        }
        this.setupWorkflowNode(workflowNode);
        this.addWorkflowErrorLogFileNode(workflowNode, workflowRun);
        DMBrowserNode runInformation = new DMBrowserNode(Messages.runInformationTitle);
        runInformation.setType(DMBrowserNodeType.WorkflowRunInformation);
        FinalWorkflowState finalState = workflowRun.getFinalState();
        Long starttime = workflowRun.getStartTime();
        Long endtime = workflowRun.getEndTime();
        Boolean areFilesDeleted = Boolean.valueOf(workflowNode.getMetaData().getValue(METADATA_WORKFLOW_FILES_DELETED));
        if (workflowRun.getWfFileReference() != null) {
            FileReferenceTD wfFileReference = (FileReferenceTD)this.typedDatumSerializer.deserialize(workflowRun.getWfFileReference());
            DMBrowserNode wfFileNode = new DMBrowserNode(StringUtils.format((String)Messages.workflowFile, (Object[])new Object[]{wfFileReference.getFileName()}));
            wfFileNode.setType(DMBrowserNodeType.DMFileResource);
            wfFileNode.setDataReferenceId(wfFileReference.getFileReference());
            wfFileNode.setAssociatedFilename(wfFileReference.getFileName());
            wfFileNode.markAsLeaf();
            runInformation.addChild(wfFileNode);
        }
        if ((nodeId = workflowRun.getControllerLogicalNodeId()) != null) {
            DMBrowserNode.addNewLeafNode(StringUtils.format((String)Messages.runInformationControllerNode, (Object[])new Object[]{nodeId.getAssociatedDisplayName()}), DMBrowserNodeType.InformationText, runInformation);
        }
        DMBrowserNode componentHostInformation = new DMBrowserNode(Messages.componentRunInformationSubtree);
        componentHostInformation.setType(DMBrowserNodeType.ComponentHostInformation);
        runInformation.addChild(componentHostInformation);
        if (workflowRun.getComponentRuns().isEmpty()) {
            DMBrowserNode.addNewLeafNode("Not (yet) available", DMBrowserNodeType.InformationText, componentHostInformation);
        } else {
            for (ComponentInstance componentInstance : workflowRun.getComponentRuns().keySet()) {
                ComponentRun firstComponentRun;
                LogicalNodeId componentRunLogicalNodeId;
                if (((Set)workflowRun.getComponentRuns().get(componentInstance)).isEmpty() || (componentRunLogicalNodeId = (firstComponentRun = (ComponentRun)((Set)workflowRun.getComponentRuns().get(componentInstance)).iterator().next()).getLogicalNodeId()) == null) continue;
                String componentName = componentInstance.getComponentInstanceName();
                DMBrowserNode compNode = DMBrowserNode.addNewLeafNode(StringUtils.format((String)"%s: %s", (Object[])new Object[]{componentName, componentRunLogicalNodeId.getAssociatedDisplayName()}), DMBrowserNodeType.Component, componentHostInformation);
                MetaDataSet metaDataSet = new MetaDataSet();
                metaDataSet.setValue(METADATA_COMPONENT_NAME, componentName);
                metaDataSet.setValue(METADATA_HISTORY_DATA_ITEM_IDENTIFIER, componentInstance.getComponentID());
                compNode.setMetaData(metaDataSet);
                boolean failed = false;
                boolean verificationFailed = false;
                if (componentInstance.getFinalState() != null) {
                    failed = componentInstance.getFinalState().equals(FAILED);
                    verificationFailed = componentInstance.getFinalState().equals(VERIFICATION_FAILED);
                }
                this.setComponentIconForDMBrowserNode(compNode, failed, verificationFailed);
            }
            componentHostInformation.sortChildren(DMBrowserNodeUtils.COMPARATOR_BY_NODE_TITLE);
        }
        if (starttime != null) {
            DMBrowserNode.addNewLeafNode(StringUtils.format((String)Messages.runInformationStarttime, (Object[])new Object[]{this.dateFormat.format(new Date(starttime))}), DMBrowserNodeType.InformationText, runInformation);
        }
        if (endtime != null) {
            DMBrowserNode.addNewLeafNode(StringUtils.format((String)Messages.runInformationEndtime, (Object[])new Object[]{this.dateFormat.format(new Date(endtime))}), DMBrowserNodeType.InformationText, runInformation);
        } else if (finalState != null && finalState.equals((Object)FinalWorkflowState.CORRUPTED)) {
            DMBrowserNode.addNewLeafNode(StringUtils.format((String)Messages.runInformationEndtime, (Object[])new Object[]{UNKNOWN}), DMBrowserNodeType.InformationText, runInformation);
        } else {
            DMBrowserNode.addNewLeafNode(StringUtils.format((String)Messages.runInformationEndtime, (Object[])new Object[]{NOT_YET_AVAILABLE}), DMBrowserNodeType.InformationText, runInformation);
        }
        if (finalState != null) {
            DMBrowserNode.addNewLeafNode(StringUtils.format((String)Messages.runInformationFinalState, (Object[])new Object[]{finalState.getDisplayName()}), DMBrowserNodeType.InformationText, runInformation);
        } else {
            DMBrowserNode.addNewLeafNode(StringUtils.format((String)Messages.runInformationFinalState, (Object[])new Object[]{NOT_YET_AVAILABLE}), DMBrowserNodeType.InformationText, runInformation);
        }
        if (areFilesDeleted.booleanValue()) {
            DMBrowserNode.addNewLeafNode(StringUtils.format((String)Messages.additionalInformation, (Object[])new Object[]{Messages.runInformationFilesDeleted}), DMBrowserNodeType.InformationText, runInformation);
        }
        if (workflowRun.getAdditionalInformationIfAvailable() != null) {
            DMBrowserNode.addNewLeafNode(StringUtils.format((String)Messages.runInformationAdditionalInformation, (Object[])new Object[]{workflowRun.getAdditionalInformationIfAvailable()}), DMBrowserNodeType.InformationText, runInformation);
        }
        workflowNode.addChild(runInformation);
        DMBrowserNode timelineDMObject = new DMBrowserNode("Timeline");
        timelineDMObject.setType(DMBrowserNodeType.Timeline);
        workflowNode.addChild(timelineDMObject);
        DMBrowserNode componentsNode = new DMBrowserNode("Timeline by Component");
        componentsNode.setType(DMBrowserNodeType.Components);
        workflowNode.addChild(componentsNode);
        if (areFilesDeleted.booleanValue()) {
            this.setFileNodesEnabled(workflowNode, false);
        }
    }

    private void createChildrenForTimelineNode(DMBrowserNode timelineNode) throws CommunicationException {
        WorkflowRun workflowRun = this.getMetaDataForWorkflow(timelineNode.getNodeWithTypeWorkflow());
        if (workflowRun == null) {
            timelineNode.setEnabled(false);
            return;
        }
        for (ComponentInstance componentInstance : workflowRun.getComponentRuns().keySet()) {
            for (ComponentRun componentRun : (Set)workflowRun.getComponentRuns().get(componentInstance)) {
                String componentRunLocationTag = this.wasComponentRunOnLocalInstance(componentRun) ? LOCAL : REMOTE;
                MetaDataSet metaDataSet = new MetaDataSet();
                Long startTime = componentRun.getStartTime();
                metaDataSet.setValue(METADATA_HISTORY_ORDERING, startTime.toString());
                String startDateString = this.dateFormat.format(new Date(startTime));
                String componentSpecificText = this.getNodeTitleForComponentRun(componentRun);
                metaDataSet.setValue(METADATA_HISTORY_USER_INFO_TEXT, componentSpecificText);
                String componentName = componentInstance.getComponentInstanceName();
                metaDataSet.setValue(METADATA_COMPONENT_NAME, componentName);
                metaDataSet.setValue(METADATA_HISTORY_DATA_ITEM_IDENTIFIER, componentInstance.getComponentID());
                String componentRunNodeText = StringUtils.format((String)COMPONENT_NAME_AND_NODE_TEXT_FORMAT_TITLE_PLUS_TIMESTAMP_AND_HOST, (Object[])new Object[]{componentName, componentSpecificText, startDateString, componentRunLocationTag});
                if (componentRun.getFinalState() != null && componentRun.getFinalState() != FinalComponentRunState.FINISHED && componentRun.getFinalState() != FinalComponentRunState.RESULTS_APPROVED) {
                    componentRunNodeText = componentRunNodeText.concat(BRACKET_LEFT + componentRun.getFinalState() + BRACKET_RIGHT);
                }
                DMBrowserNode dmoChild = new DMBrowserNode(componentRunNodeText, timelineNode);
                dmoChild.setMetaData(metaDataSet);
                dmoChild.setType(DMBrowserNodeType.HistoryObject);
                boolean compRunFailed = false;
                boolean resultsRejected = false;
                if (componentRun.getFinalState() != null) {
                    compRunFailed = componentRun.getFinalState().equals((Object)FinalComponentRunState.FAILED);
                    resultsRejected = componentRun.getFinalState().equals((Object)FinalComponentRunState.RESULTS_REJECTED);
                }
                this.setComponentIconForDMBrowserNode(dmoChild, compRunFailed, resultsRejected);
                this.createChildrenForHistoryObjectNode(dmoChild, componentRun);
                timelineNode.addChild(dmoChild);
                this.addComponentLogFilesNode(dmoChild, componentRun);
            }
        }
        timelineNode.sortChildren(DMBrowserNodeUtils.COMPARATOR_BY_HISTORY_TIMESTAMP_DESC);
        this.setFileNodesEnabled(timelineNode, Boolean.valueOf(timelineNode.getNodeWithTypeWorkflow().getMetaData().getValue(METADATA_WORKFLOW_FILES_DELETED)) == false);
    }

    private String getNodeTitleForComponentRun(ComponentRun componentRun) {
        String componentSpecificText = componentRun.getRunCounter() == -1 ? "Tear down" : (componentRun.getRunCounter() == 0 ? "Init" : StringUtils.format((String)"Run %d", (Object[])new Object[]{componentRun.getRunCounter()}));
        return componentSpecificText;
    }

    private void createChildrenForComponentsNode(DMBrowserNode componentsNode) throws CommunicationException {
        WorkflowRun workflowRun = this.getMetaDataForWorkflow(componentsNode.getNodeWithTypeWorkflow());
        if (workflowRun == null) {
            componentsNode.setEnabled(false);
            return;
        }
        for (ComponentInstance componentInstance : workflowRun.getComponentRuns().keySet()) {
            ComponentRun firstRun;
            MetaDataSet metaDataSet = new MetaDataSet();
            String componentName = componentInstance.getComponentInstanceName();
            metaDataSet.setValue(METADATA_COMPONENT_NAME, componentName);
            metaDataSet.setValue(METADATA_HISTORY_DATA_ITEM_IDENTIFIER, componentInstance.getComponentID());
            String componentHostName = ((Set)workflowRun.getComponentRuns().get(componentInstance)).size() > 0 ? (this.wasComponentRunOnLocalInstance(firstRun = (ComponentRun)((Set)workflowRun.getComponentRuns().get(componentInstance)).iterator().next()) ? LOCAL : REMOTE) : "";
            DMBrowserNode componentNode = new DMBrowserNode("");
            componentNode.setType(DMBrowserNodeType.Component);
            componentNode.setMetaData(metaDataSet);
            boolean failed = false;
            boolean verificationFailed = false;
            if (componentInstance.getFinalState() != null) {
                failed = componentInstance.getFinalState().equals(FAILED);
                verificationFailed = componentInstance.getFinalState().equals(VERIFICATION_FAILED);
            }
            this.setComponentIconForDMBrowserNode(componentNode, failed, verificationFailed);
            boolean initIncluded = false;
            boolean tearDownIncluded = false;
            for (ComponentRun componentRun : (Set)workflowRun.getComponentRuns().get(componentInstance)) {
                String componentRunLocationTag = this.wasComponentRunOnLocalInstance(componentRun) ? LOCAL : REMOTE;
                Long startTime = componentRun.getStartTime();
                MetaDataSet metaDataSetRun = new MetaDataSet();
                metaDataSetRun.setValue(METADATA_COMPONENT_NAME, componentName);
                metaDataSetRun.setValue(METADATA_HISTORY_DATA_ITEM_IDENTIFIER, componentInstance.getComponentID());
                metaDataSetRun.setValue(METADATA_HISTORY_ORDERING, startTime.toString());
                String startDateString = this.dateFormat.format(new Date(startTime));
                String componentSpecificText = this.getNodeTitleForComponentRun(componentRun);
                metaDataSetRun.setValue(METADATA_HISTORY_USER_INFO_TEXT, componentSpecificText);
                String componentRunNodeText = StringUtils.format((String)NODE_TEXT_FORMAT_TITLE_PLUS_TIMESTAMP_AND_HOST, (Object[])new Object[]{componentSpecificText, startDateString, componentRunLocationTag});
                if (componentRun.getFinalState() != null && componentRun.getFinalState() != FinalComponentRunState.FINISHED && componentRun.getFinalState() != FinalComponentRunState.RESULTS_APPROVED) {
                    componentRunNodeText = componentRunNodeText.concat(BRACKET_LEFT + componentRun.getFinalState() + BRACKET_RIGHT);
                }
                DMBrowserNode dmoChild = new DMBrowserNode(componentRunNodeText, componentsNode);
                dmoChild.setMetaData(metaDataSetRun);
                dmoChild.setType(DMBrowserNodeType.HistoryObject);
                boolean compRunFailed = false;
                boolean resultsRejected = false;
                if (componentRun.getFinalState() != null) {
                    compRunFailed = componentRun.getFinalState().equals((Object)FinalComponentRunState.FAILED);
                    resultsRejected = componentRun.getFinalState().equals((Object)FinalComponentRunState.RESULTS_REJECTED);
                }
                this.setComponentIconForDMBrowserNode(dmoChild, compRunFailed, resultsRejected);
                this.createChildrenForHistoryObjectNode(dmoChild, componentRun);
                componentNode.addChild(dmoChild);
                this.addComponentLogFilesNode(dmoChild, componentRun);
                if (componentRun.getRunCounter() == 0) {
                    initIncluded = true;
                    continue;
                }
                if (componentRun.getRunCounter() != -1) continue;
                tearDownIncluded = true;
            }
            String finalState = componentInstance.getFinalState();
            String componentNodeText = StringUtils.format((String)"%s (Runs: %d) <%s>", (Object[])new Object[]{componentName, this.getComponentRunCount(workflowRun, componentInstance, initIncluded, tearDownIncluded), componentHostName});
            if (finalState != null && !finalState.equals(FINISHED)) {
                componentNodeText = componentNodeText.concat(BRACKET_LEFT + finalState + BRACKET_RIGHT);
            }
            componentNode.setTitle(componentNodeText);
            componentsNode.addChild(componentNode);
            componentNode.sortChildren(DMBrowserNodeUtils.COMPARATOR_BY_HISTORY_TIMESTAMP_DESC);
        }
        componentsNode.sortChildren(DMBrowserNodeUtils.COMPARATOR_BY_NODE_TITLE);
        this.setFileNodesEnabled(componentsNode, Boolean.valueOf(componentsNode.getNodeWithTypeWorkflow().getMetaData().getValue(METADATA_WORKFLOW_FILES_DELETED)) == false);
    }

    private int getComponentRunCount(WorkflowRun workflowRun, ComponentInstance componentInstance, boolean initIncluded, boolean tearDownIncluded) {
        int runCount = ((Set)workflowRun.getComponentRuns().get(componentInstance)).size();
        if (initIncluded) {
            --runCount;
        }
        if (tearDownIncluded) {
            --runCount;
        }
        return runCount;
    }

    private void addComponentLogFilesNode(DMBrowserNode parentNode, ComponentRun componentRun) {
        boolean logFilesAlwaysStored;
        String logFileRef = componentRun.getLogFile();
        String errorLogFileRef = componentRun.getErrorLogFile();
        boolean bl = logFilesAlwaysStored = VersionUtils.getCoreBundleVersion().compareTo(new Version("7.0.0")) >= 0;
        if (logFilesAlwaysStored || logFileRef != null || errorLogFileRef != null) {
            DMBrowserNode executionLogNode = null;
            for (DMBrowserNode node : parentNode.getChildren()) {
                if (!node.getTitle().equals("Execution Log")) continue;
                executionLogNode = node;
                break;
            }
            if (executionLogNode != null) {
                parentNode.removeChild(executionLogNode);
            } else {
                executionLogNode = new DMBrowserNode("Execution Log");
                executionLogNode.setType(DMBrowserNodeType.LogFolder);
            }
            if (logFilesAlwaysStored || logFileRef != null) {
                executionLogNode.addChild(this.createLogFileNode(logFileRef, false));
            }
            if (logFilesAlwaysStored || errorLogFileRef != null) {
                executionLogNode.addChild(this.createLogFileNode(errorLogFileRef, true));
            }
            parentNode.addChild(executionLogNode);
        }
    }

    private void addWorkflowErrorLogFileNode(DMBrowserNode parentNode, WorkflowRun workflowRun) {
        boolean logFilesAlwaysStored = VersionUtils.getCoreBundleVersion().compareTo(new Version("7.0.0")) >= 0;
        String errorLogRef = workflowRun.getErrorLogFileReference();
        if (logFilesAlwaysStored || errorLogRef != null) {
            DMBrowserNode errorLogNode = this.createLogFileNode(errorLogRef, true);
            parentNode.addChild(errorLogNode);
        }
    }

    private DMBrowserNode createLogFileNode(String logFileRef, boolean errorLog) {
        DMBrowserNode logFileNode;
        if (logFileRef != null) {
            FileReferenceTD logFileReference = (FileReferenceTD)this.typedDatumSerializer.deserialize(logFileRef);
            logFileNode = new DMBrowserNode(this.getTitleForLogFileDMBrowserNode(logFileReference));
            logFileNode.setType(DMBrowserNodeType.DMFileResource);
            logFileNode.setDataReferenceId(logFileReference.getFileReference());
            logFileNode.setAssociatedFilename(logFileReference.getFileName());
        } else {
            logFileNode = errorLog ? new DMBrowserNode("[no error log]") : new DMBrowserNode("[no log]");
            logFileNode.setType(DMBrowserNodeType.Custom);
            logFileNode.setIcon(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.DATATYPE_FILE_16));
            logFileNode.setEnabled(false);
        }
        logFileNode.markAsLeaf();
        return logFileNode;
    }

    private String getTitleForLogFileDMBrowserNode(FileReferenceTD logFileReference) {
        double fileSizeInKB = (double)logFileReference.getFileSizeInBytes() / 1024.0;
        String nodeTitle = fileSizeInKB == 0.0 ? StringUtils.format((String)"%s [0 KB]", (Object[])new Object[]{logFileReference.getFileName()}) : (fileSizeInKB < 1.0 ? StringUtils.format((String)"%s [%.2f KB]", (Object[])new Object[]{logFileReference.getFileName(), (double)Math.round(fileSizeInKB * 100.0) / 100.0}) : StringUtils.format((String)"%s [%d KB]", (Object[])new Object[]{logFileReference.getFileName(), Math.round(fileSizeInKB)}));
        return nodeTitle;
    }

    private void setComponentIconForDMBrowserNode(DMBrowserNode node, boolean isFailed, boolean isVerificationFailed) {
        String identifier = node.getMetaData().getValue(METADATA_HISTORY_DATA_ITEM_IDENTIFIER);
        ComponentHistoryDataItemSubtreeBuilder builder = this.getComponentHistoryDataItemSubtreeBuilder(node);
        if (builder != null) {
            ImageDescriptor overlayIconDescriptor;
            Image componentIcon;
            Image decoratedImage = componentIcon = builder.getComponentIcon(identifier);
            if (isFailed) {
                ImageDescriptor overlayIconDescriptor2 = DMBrowserImages.FAILED_SMALL;
                if (overlayIconDescriptor2 != null) {
                    DecorationOverlayIcon decorationOverlayIcon = new DecorationOverlayIcon(componentIcon, overlayIconDescriptor2, 1);
                    decoratedImage = decorationOverlayIcon.createImage();
                }
            } else if (isVerificationFailed && (overlayIconDescriptor = DMBrowserImages.VERIFICATION_FAILED_SMALL) != null) {
                DecorationOverlayIcon decorationOverlayIcon = new DecorationOverlayIcon(componentIcon, overlayIconDescriptor, 1);
                decoratedImage = decorationOverlayIcon.createImage();
            }
            node.setIcon(decoratedImage);
        } else {
            this.log.warn((Object)(NO_BUILDER_ERROR_MESSAGE + identifier));
        }
    }

    private void createChildrenForHistoryObjectNode(final DMBrowserNode node, ComponentRun componentRun) {
        String historyDataItem;
        ComponentHistoryDataItemSubtreeBuilder builder = this.getComponentHistoryDataItemSubtreeBuilder(node);
        LogicalNodeId componentRunNodeId = componentRun.getLogicalNodeId();
        if (componentRunNodeId != null) {
            DMBrowserNode.addNewLeafNode(StringUtils.format((String)Messages.componentRunInformationNode, (Object[])new Object[]{componentRunNodeId.getAssociatedDisplayName()}), DMBrowserNodeType.InformationText, node);
        }
        if ((historyDataItem = componentRun.getHistoryDataItem()) != null) {
            if (builder == null) {
                String identifier = node.getMetaData().getValue(METADATA_HISTORY_DATA_ITEM_IDENTIFIER);
                String message = NO_BUILDER_ERROR_MESSAGE + identifier;
                this.log.warn((Object)message);
                Display.getDefault().asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Set<String> set = DMContentProvider.this.warningIsShown;
                        synchronized (set) {
                            if (DMContentProvider.this.warningIsShown.contains(node.getPath())) {
                                return;
                            }
                            DMContentProvider.this.warningIsShown.add(node.getPath());
                        }
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.historyNodeWarningTitle, (String)StringUtils.format((String)Messages.historyNodeWarningMessage, (Object[])new Object[]{node.getTitle()}));
                        set = DMContentProvider.this.warningIsShown;
                        synchronized (set) {
                            DMContentProvider.this.warningIsShown.remove(node.getPath());
                        }
                    }
                });
            } else {
                builder.buildInitialHistoryDataItemSubtree((Serializable)((Object)historyDataItem), node);
            }
        }
        DefaultComponentHistoryDataItem defaultHistoryDataItem = new DefaultComponentHistoryDataItem();
        if (componentRun.getEndpointData() != null && !componentRun.getEndpointData().isEmpty()) {
            ArrayList ed = new ArrayList();
            ed.addAll(componentRun.getEndpointData());
            Collections.sort(ed);
            for (EndpointData endpointData : ed) {
                Map metaData = endpointData.getEndpointInstance().getMetaData();
                TypedDatum td = this.typedDatumSerializer.deserialize(endpointData.getDatum());
                switch (endpointData.getEndpointInstance().getEndpointType()) {
                    case INPUT: {
                        defaultHistoryDataItem.addInput(endpointData.getEndpointInstance().getEndpointName(), td);
                        defaultHistoryDataItem.setInputMetaData(endpointData.getEndpointInstance().getEndpointName(), metaData);
                        break;
                    }
                    case OUTPUT: {
                        defaultHistoryDataItem.addOutput(endpointData.getEndpointInstance().getEndpointName(), td);
                        defaultHistoryDataItem.setOutputMetaData(endpointData.getEndpointInstance().getEndpointName(), metaData);
                        break;
                    }
                }
            }
            CommonHistoryDataItemSubtreeBuilderUtils.buildDefaultHistoryDataItemSubtrees(defaultHistoryDataItem, node);
        }
    }

    private void setFileNodesEnabled(DMBrowserNode node, boolean enable) {
        if (!node.isLeafNode().booleanValue() && node.areChildrenKnown()) {
            for (DMBrowserNode childNode : node.getChildren()) {
                this.setFileNodesEnabled(childNode, enable);
            }
        } else if (node.getType().equals((Object)DMBrowserNodeType.DMFileResource) || node.getType().equals((Object)DMBrowserNodeType.DMDirectoryReference)) {
            node.setEnabled(enable);
        }
    }

    public DMBrowserNode[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        DMBrowserNode dmo = (DMBrowserNode)element;
        if (element == null) {
            return null;
        }
        return dmo.getParent();
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof DMBrowserNode) {
            DMBrowserNode dmo = (DMBrowserNode)parent;
            if (!dmo.areChildrenKnown()) {
                return true;
            }
            return dmo.getNumChildren() != 0;
        }
        return true;
    }

    protected boolean deleteWorkflowRun(DMBrowserNode browserNode) {
        try {
            this.metaDataService.deleteWorkflowRun(Long.valueOf(browserNode.getWorkflowID()), (NetworkDestination)browserNode.getWorkflowControllerNode());
            return true;
        }
        catch (CommunicationException e) {
            this.log.error((Object)"Could not delete workflow run in the database.", (Throwable)e);
            return false;
        }
    }

    protected void deleteWorkflowRunFiles(DMBrowserNode browserNode) {
        try {
            this.metaDataService.deleteWorkflowRunFiles(Long.valueOf(browserNode.getWorkflowID()), (NetworkDestination)browserNode.getWorkflowControllerNode());
            browserNode.getMetaData().setValue(METADATA_WORKFLOW_FILES_DELETED, String.valueOf(true));
        }
        catch (CommunicationException e) {
            this.log.error((Object)"Could not delete workflow run files in the database.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<DMBrowserNode, WorkflowRun> map = this.workflowMetaDataMap;
        synchronized (map) {
            this.workflowMetaDataMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(DMBrowserNode node) {
        DMBrowserNode wfNode = node.getNodeWithTypeWorkflow();
        if (wfNode != null) {
            Map<DMBrowserNode, WorkflowRun> map = this.workflowMetaDataMap;
            synchronized (map) {
                this.workflowMetaDataMap.remove(node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<DMBrowserNode, WorkflowRun> map = this.workflowMetaDataMap;
        synchronized (map) {
            this.workflowMetaDataMap.clear();
        }
    }

    public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
    }

    public void addContentAvailabilityHandler(DMBrowserNodeContentAvailabilityHandler contentAvailabilityHandler) {
        this.contentAvailabilityHandlers.add(contentAvailabilityHandler);
    }

    public void removeContentAvailabilityHandler(DMBrowserNodeContentAvailabilityHandler contentAvailabilityHandler) {
        this.contentAvailabilityHandlers.remove(contentAvailabilityHandler);
    }

    private ComponentHistoryDataItemSubtreeBuilder getComponentHistoryDataItemSubtreeBuilder(DMBrowserNode node) {
        String identifier = node.getMetaData().getValue(METADATA_HISTORY_DATA_ITEM_IDENTIFIER).split("/")[0];
        for (String supportedIdentifier : this.historySubtreeBuilders.keySet()) {
            if (!identifier.matches(supportedIdentifier)) continue;
            return this.historySubtreeBuilders.get(supportedIdentifier);
        }
        return null;
    }

    private boolean wasComponentRunOnLocalInstance(ComponentRun firstRun) {
        return this.localInstanceSessionId.convertToDefaultLogicalNodeId().equals(firstRun.getLogicalNodeId());
    }

    private class RetrieverTask
    implements Runnable {
        private final DMBrowserNode node;

        RetrieverTask(DMBrowserNode node) {
            this.node = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            block31: {
                block30: {
                    var1_1 = DMContentProvider.this.inProgress;
                    synchronized (var1_1) {
                        if (DMContentProvider.this.inProgress.contains(this.node)) {
                            return;
                        }
                        DMContentProvider.this.inProgress.add(this.node);
                    }
                    try {
                        DMContentProvider.this.createChildrenForNode(this.node);
                        if (Thread.currentThread().isInterrupted()) {
                        }
                        ** GOTO lbl-1000
                    }
                    catch (RuntimeException e) {
                        var3_12 = DMContentProvider.this.contentAvailabilityHandlers.iterator();
                    }
                    while (true) {
                        if (!var3_12.hasNext()) break;
                        handler = var3_12.next();
                        handler.handleContentRetrievalError(this.node, e);
                    }
                    var5_5 = DMContentProvider.this.inProgress;
                    synchronized (var5_5) {
                        DMContentProvider.this.inProgress.remove(this.node);
                        return;
                    }
                    catch (CommunicationException e) {
                        try {
                            for (DMBrowserNodeContentAvailabilityHandler handler : DMContentProvider.this.contentAvailabilityHandlers) {
                                handler.handleContentRetrievalError(this.node, (Exception)e);
                            }
                            break block30;
                        }
                        catch (Throwable var4_14) {
                            var5_7 = DMContentProvider.this.inProgress;
                            synchronized (var5_7) {
                                DMContentProvider.this.inProgress.remove(this.node);
                                throw var4_14;
                            }
                        }
                    }
                    var5_4 = DMContentProvider.this.inProgress;
                    synchronized (var5_4) {
                        DMContentProvider.this.inProgress.remove(this.node);
                        return;
                    }
lbl-1000:
                    // 2 sources

                    {
                        for (DMBrowserNodeContentAvailabilityHandler handler : DMContentProvider.this.contentAvailabilityHandlers) {
                            handler.handleContentAvailable(this.node);
                        }
                        break block31;
                    }
                }
                var5_6 = DMContentProvider.this.inProgress;
                synchronized (var5_6) {
                    DMContentProvider.this.inProgress.remove(this.node);
                    return;
                }
            }
            var5_8 = DMContentProvider.this.inProgress;
            synchronized (var5_8) {
                DMContentProvider.this.inProgress.remove(this.node);
                return;
            }
        }
    }
}

