/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.swt.events.KeyEvent;

public class GraphicalViewerKeyHandler
extends KeyHandler {
    int counter;
    private WeakReference<GraphicalEditPart> cachedNode;
    private GraphicalViewer viewer;

    public GraphicalViewerKeyHandler(GraphicalViewer viewer) {
        this.viewer = viewer;
    }

    boolean acceptConnection(KeyEvent event) {
        return event.character == '/' || event.character == '?' || event.character == '\\' || event.character == '\u001c' || event.character == '|';
    }

    boolean acceptIntoContainer(KeyEvent event) {
        return (event.stateMask & 0x10000) != 0 && event.keyCode == 0x1000002;
    }

    boolean acceptLeaveConnection(KeyEvent event) {
        int key = event.keyCode;
        return this.getFocusEditPart() instanceof ConnectionEditPart && (key == 0x1000001 || key == 0x1000004 || key == 0x1000002 || key == 0x1000003);
    }

    boolean acceptLeaveContents(KeyEvent event) {
        int key = event.keyCode;
        return this.getFocusEditPart() == this.getViewer().getContents() && (key == 0x1000001 || key == 0x1000004 || key == 0x1000002 || key == 0x1000003);
    }

    boolean acceptOutOf(KeyEvent event) {
        return (event.stateMask & 0x10000) != 0 && event.keyCode == 0x1000001;
    }

    boolean acceptScroll(KeyEvent event) {
        return (event.stateMask & 0x40000) != 0 && (event.stateMask & 0x20000) != 0 && (event.keyCode == 0x1000002 || event.keyCode == 0x1000003 || event.keyCode == 0x1000004 || event.keyCode == 0x1000001);
    }

    ConnectionEditPart findConnection(GraphicalEditPart node, ConnectionEditPart current, boolean forward) {
        List connections = new ArrayList(node.getSourceConnections());
        connections.addAll(node.getTargetConnections());
        connections = this.getValidNavigationTargets(connections);
        if (connections.isEmpty()) {
            return null;
        }
        this.counter = forward ? ++this.counter : --this.counter;
        while (this.counter < 0) {
            this.counter += connections.size();
        }
        this.counter %= connections.size();
        return (ConnectionEditPart)connections.get(this.counter % connections.size());
    }

    private List getValidNavigationTargets(List candidateEditParts) {
        ArrayList<EditPart> validNavigationTargetEditParts = new ArrayList<EditPart>();
        int i = 0;
        while (i < candidateEditParts.size()) {
            EditPart candidate = (EditPart)candidateEditParts.get(i);
            if (this.isValidNavigationTarget(candidate)) {
                validNavigationTargetEditParts.add(candidate);
            }
            ++i;
        }
        return validNavigationTargetEditParts;
    }

    GraphicalEditPart findSibling(List siblings, Point pStart, int direction, EditPart exclude) {
        GraphicalEditPart epFinal = null;
        int distance = Integer.MAX_VALUE;
        for (GraphicalEditPart epCurrent : this.getValidNavigationTargets(siblings)) {
            int d;
            if (epCurrent == exclude) continue;
            IFigure figure = epCurrent.getFigure();
            Point pCurrent = this.getNavigationPoint(figure);
            figure.translateToAbsolute((Translatable)pCurrent);
            if (pStart.getPosition(pCurrent) != direction || (d = pCurrent.getDistanceOrthogonal(pStart)) >= distance) continue;
            distance = d;
            epFinal = epCurrent;
        }
        return epFinal;
    }

    Point getNavigationPoint(IFigure figure) {
        return figure.getBounds().getCenter();
    }

    private GraphicalEditPart getCachedNode() {
        if (this.cachedNode == null) {
            return null;
        }
        return (GraphicalEditPart)this.cachedNode.get();
    }

    protected GraphicalEditPart getFocusEditPart() {
        return (GraphicalEditPart)this.getViewer().getFocusEditPart();
    }

    protected List getNavigationSiblings() {
        GraphicalEditPart focusPart = this.getFocusEditPart();
        if (focusPart.getParent() != null) {
            return focusPart.getParent().getChildren();
        }
        ArrayList<GraphicalEditPart> list = new ArrayList<GraphicalEditPart>();
        list.add(focusPart);
        return list;
    }

    protected GraphicalViewer getViewer() {
        return this.viewer;
    }

    protected boolean isViewerMirrored() {
        return (this.viewer.getControl().getStyle() & 0x8000000) != 0;
    }

    @Override
    public boolean keyPressed(KeyEvent event) {
        if (event.keyCode == 32) {
            this.processSelect(event);
            return true;
        }
        if (this.acceptIntoContainer(event)) {
            this.navigateIntoContainer(event);
            return true;
        }
        if (this.acceptOutOf(event)) {
            this.navigateOut(event);
            return true;
        }
        if (this.acceptConnection(event)) {
            this.navigateConnections(event);
            return true;
        }
        if (this.acceptScroll(event)) {
            this.scrollViewer(event);
            return true;
        }
        if (this.acceptLeaveConnection(event)) {
            this.navigateOutOfConnection(event);
            return true;
        }
        if (this.acceptLeaveContents(event)) {
            this.navigateIntoContainer(event);
            return true;
        }
        switch (event.keyCode) {
            case 0x1000003: {
                if (!this.navigateNextSibling(event, this.isViewerMirrored() ? 16 : 8)) break;
                return true;
            }
            case 0x1000004: {
                if (!this.navigateNextSibling(event, this.isViewerMirrored() ? 8 : 16)) break;
                return true;
            }
            case 0x1000001: {
                if (!this.navigateNextSibling(event, 1)) break;
                return true;
            }
            case 0x1000002: {
                if (!this.navigateNextSibling(event, 4)) break;
                return true;
            }
            case 0x1000007: {
                if (!this.navigateJumpSibling(event, 8)) break;
                return true;
            }
            case 0x1000008: {
                if (!this.navigateJumpSibling(event, 16)) break;
                return true;
            }
            case 0x1000006: {
                if (!this.navigateJumpSibling(event, 4)) break;
                return true;
            }
            case 0x1000005: {
                if (!this.navigateJumpSibling(event, 1)) break;
                return true;
            }
        }
        return super.keyPressed(event);
    }

    void navigateConnections(KeyEvent event) {
        GraphicalEditPart focus = this.getFocusEditPart();
        ConnectionEditPart current = null;
        GraphicalEditPart node = this.getCachedNode();
        if (focus instanceof ConnectionEditPart) {
            current = (ConnectionEditPart)focus;
            if (node == null || node != current.getSource() && node != current.getTarget()) {
                node = (GraphicalEditPart)current.getSource();
                this.counter = 0;
            }
        } else {
            node = focus;
        }
        this.setCachedNode(node);
        boolean forward = event.character == '/' || event.character == '?';
        ConnectionEditPart next = this.findConnection(node, current, forward);
        this.navigateTo(next, event);
    }

    private boolean isValidNavigationTarget(EditPart editPart) {
        return editPart.isSelectable();
    }

    void navigateIntoContainer(KeyEvent event) {
        GraphicalEditPart focus = this.getFocusEditPart();
        List childList = this.getValidNavigationTargets(focus.getChildren());
        Point tl = focus.getContentPane().getBounds().getTopLeft();
        int minimum = Integer.MAX_VALUE;
        GraphicalEditPart closestPart = null;
        int i = 0;
        while (i < childList.size()) {
            GraphicalEditPart child = (GraphicalEditPart)childList.get(i);
            Rectangle childBounds = child.getFigure().getBounds();
            int current = childBounds.x - tl.x + (childBounds.y - tl.y);
            if (current < minimum) {
                minimum = current;
                closestPart = child;
            }
            ++i;
        }
        if (closestPart != null) {
            this.navigateTo(closestPart, event);
        }
    }

    boolean navigateJumpSibling(KeyEvent event, int direction) {
        return false;
    }

    boolean navigateNextSibling(KeyEvent event, int direction) {
        return this.navigateNextSibling(event, direction, this.getNavigationSiblings());
    }

    boolean navigateNextSibling(KeyEvent event, int direction, List list) {
        GraphicalEditPart epStart = this.getFocusEditPart();
        IFigure figure = epStart.getFigure();
        Point pStart = this.getNavigationPoint(figure);
        figure.translateToAbsolute((Translatable)pStart);
        GraphicalEditPart next = this.findSibling(list, pStart, direction, epStart);
        if (next == null) {
            return false;
        }
        this.navigateTo(next, event);
        return true;
    }

    void navigateOut(KeyEvent event) {
        if (this.getFocusEditPart() == null || this.getFocusEditPart() == this.getViewer().getContents()) {
            return;
        }
        EditPart editPart = this.getFocusEditPart().getParent();
        while (editPart != null && editPart != this.getViewer().getContents() && !this.isValidNavigationTarget(editPart)) {
            editPart = editPart.getParent();
        }
        if (editPart != null && this.isValidNavigationTarget(editPart)) {
            this.navigateTo(editPart, event);
        }
    }

    void navigateOutOfConnection(KeyEvent event) {
        GraphicalEditPart cached = this.getCachedNode();
        ConnectionEditPart conn = (ConnectionEditPart)this.getFocusEditPart();
        if (cached != null && (cached == conn.getSource() || cached == conn.getTarget())) {
            this.navigateTo(cached, event);
        } else {
            this.navigateTo(conn.getSource(), event);
        }
    }

    protected void navigateTo(EditPart part, KeyEvent event) {
        if (part == null) {
            return;
        }
        if ((event.stateMask & 0x20000) != 0) {
            this.getViewer().appendSelection(part);
            this.getViewer().setFocus(part);
        } else if ((event.stateMask & 0x40000) != 0) {
            this.getViewer().setFocus(part);
        } else {
            this.getViewer().select(part);
        }
        this.getViewer().reveal(part);
    }

    protected void processSelect(KeyEvent event) {
        EditPart part = this.getViewer().getFocusEditPart();
        if (part != this.getViewer().getContents()) {
            if ((event.stateMask & 0x40000) != 0 && part.getSelected() != 0) {
                this.getViewer().deselect(part);
            } else {
                this.getViewer().appendSelection(part);
            }
            this.getViewer().setFocus(part);
        }
    }

    void scrollViewer(KeyEvent event) {
        if (!(this.getViewer().getControl() instanceof FigureCanvas)) {
            return;
        }
        FigureCanvas figCanvas = (FigureCanvas)this.getViewer().getControl();
        Point loc = figCanvas.getViewport().getViewLocation();
        Rectangle area = figCanvas.getViewport().getClientArea(Rectangle.SINGLETON).scale(0.1);
        switch (event.keyCode) {
            case 0x1000002: {
                figCanvas.scrollToY(loc.y + area.height);
                break;
            }
            case 0x1000001: {
                figCanvas.scrollToY(loc.y - area.height);
                break;
            }
            case 0x1000003: {
                if (this.isViewerMirrored()) {
                    figCanvas.scrollToX(loc.x + area.width);
                    break;
                }
                figCanvas.scrollToX(loc.x - area.width);
                break;
            }
            case 0x1000004: {
                if (this.isViewerMirrored()) {
                    figCanvas.scrollToX(loc.x - area.width);
                    break;
                }
                figCanvas.scrollToX(loc.x + area.width);
            }
        }
    }

    private void setCachedNode(GraphicalEditPart node) {
        this.cachedNode = node == null ? null : new WeakReference<GraphicalEditPart>(node);
    }
}

