/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.inputprovider.execution;

import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.ShortTextTD;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class InputProviderComponent
extends DefaultComponent {
    private static final String BACKSLASH = "\\";
    private static final String FRONTSLASH = "/";
    private ComponentContext componentContext;
    private TypedDatumFactory typedDatumFactory;
    private ComponentDataManagementService dataManagementService;

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    public boolean treatStartAsComponentRun() {
        return this.componentContext.getOutputs().size() > 0;
    }

    public void start() throws ComponentException {
        this.typedDatumFactory = ((TypedDatumService)this.componentContext.getService(TypedDatumService.class)).getFactory();
        this.dataManagementService = (ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class);
        for (String outputName : this.componentContext.getOutputs()) {
            ShortTextTD datum;
            String value = this.componentContext.getOutputMetaDataValue(outputName, "startValue");
            if (this.componentContext.getConfigurationKeys().contains(outputName)) {
                value = this.componentContext.getConfigurationValue(outputName);
            }
            DataType type = this.componentContext.getOutputDataType(outputName);
            switch (this.componentContext.getOutputDataType(outputName)) {
                case ShortText: {
                    datum = this.typedDatumFactory.createShortText(value);
                    break;
                }
                case Boolean: {
                    datum = this.typedDatumFactory.createBoolean(Boolean.parseBoolean(value));
                    break;
                }
                case Float: {
                    datum = this.typedDatumFactory.createFloat(Double.parseDouble(value));
                    break;
                }
                case Integer: {
                    datum = this.typedDatumFactory.createInteger(Long.parseLong(value));
                    break;
                }
                case FileReference: {
                    datum = this.getTypedDatumForFile(value, outputName);
                    break;
                }
                case DirectoryReference: {
                    datum = this.getTypedDatumForDirectory(value, outputName);
                    break;
                }
                default: {
                    throw new ComponentException("Internal error: Given data type is not supported: " + type);
                }
            }
            this.componentContext.writeOutput(outputName, (TypedDatum)datum);
            this.componentContext.getLog().componentInfo("Wrote to output '" + outputName + "': " + value);
        }
    }

    private TypedDatum getTypedDatumForFile(String value, String outputName) throws ComponentException {
        File file = this.createFileObject(value);
        if (file == null) {
            throw new ComponentException(StringUtils.format((String)"Internal error: No file given for output '%s'", (Object[])new Object[]{outputName}));
        }
        if (!file.exists()) {
            throw new ComponentException(StringUtils.format((String)"Given path doesn't refer to a file on node %s: %s", (Object[])new Object[]{this.componentContext.getNodeId().getAssociatedDisplayName(), file.getAbsolutePath()}));
        }
        try {
            return this.dataManagementService.createFileReferenceTDFromLocalFile(this.componentContext, file, file.getName());
        }
        catch (IOException e) {
            throw new ComponentException("Failed to store file into the data management - if it is not stored in the data management, it can not be sent as output value: " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    private TypedDatum getTypedDatumForDirectory(String value, String outputName) throws ComponentException {
        File dir = this.createFileObject(value);
        if (dir == null) {
            throw new ComponentException(StringUtils.format((String)"No directory given for output '%s'", (Object[])new Object[]{outputName}));
        }
        if (!dir.exists()) {
            throw new ComponentException(StringUtils.format((String)"Directory doesn't exist on node %s: %s", (Object[])new Object[]{this.componentContext.getNodeId().getAssociatedDisplayName(), dir.getAbsolutePath()}));
        }
        if (!dir.isDirectory()) {
            throw new ComponentException(StringUtils.format((String)"Given path doesn't refer to a directory on node %s: %s", (Object[])new Object[]{this.componentContext.getNodeId().getAssociatedDisplayName(), dir.getAbsolutePath()}));
        }
        try {
            return this.dataManagementService.createDirectoryReferenceTDFromLocalDirectory(this.componentContext, dir, dir.getName());
        }
        catch (IOException e) {
            throw new ComponentException("Failed to store directory into the data management - if it is not stored in the data management, it can not be sent as output value: " + dir.getAbsolutePath(), (Throwable)e);
        }
    }

    private File createFileObject(String value) throws ComponentException {
        if (value.isEmpty()) {
            return null;
        }
        if (value.contains(FRONTSLASH) && value.contains(BACKSLASH)) {
            throw new ComponentException(StringUtils.format((String)"Given path to file or directory could not be resolved, as it contains front and backslash as well: %s", (Object[])new Object[]{value}));
        }
        String usedSeparator = "";
        if (value.contains(FRONTSLASH)) {
            usedSeparator = FRONTSLASH;
        } else if (value.contains(BACKSLASH)) {
            usedSeparator = BACKSLASH;
        } else {
            throw new ComponentException(StringUtils.format((String)"Given path to file or directory does not exist on node %s: %s", (Object[])new Object[]{this.componentContext.getNodeId().getAssociatedDisplayName(), value}));
        }
        File file = new File(value);
        if (!file.isAbsolute()) {
            String projectName = value.split(usedSeparator)[0];
            String pathToFileWithinProject = value.substring(projectName.length());
            IPath projectLocation = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation();
            if (projectLocation == null) {
                throw new ComponentException("Given project not found: " + projectName);
            }
            file = new File(String.valueOf(projectLocation.toFile().getAbsolutePath()) + usedSeparator + pathToFileWithinProject);
        }
        return file;
    }
}

