/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.gui;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.switchcmp.common.SwitchComponentHistoryDataItem;
import de.rcenvironment.components.switchcmp.common.SwitchCondition;
import de.rcenvironment.components.switchcmp.gui.Messages;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.datamanagement.api.DefaultComponentHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.gui.datamanagement.browser.spi.CommonHistoryDataItemSubtreeBuilderUtils;
import de.rcenvironment.core.gui.datamanagement.browser.spi.ComponentHistoryDataItemSubtreeBuilder;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNode;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNodeType;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class SwitchHistoryDataItemSubtreeBuilder
implements ComponentHistoryDataItemSubtreeBuilder {
    private static final Image COMPONENT_ICON;
    private static final String EXCEPTION_MESSAGE_READING = "Unexpected Exception occured, while reading JSON content String.";

    static {
        String bundleName = "de.rcenvironment.components.switch.common";
        String iconName = "switch_16.png";
        URL url = ComponentUtils.readIconURL((String)bundleName, (String)iconName);
        COMPONENT_ICON = url != null ? ImageDescriptor.createFromURL((URL)url).createImage() : null;
    }

    public String[] getSupportedHistoryDataItemIdentifier() {
        return new String[]{"de.rcenvironment.switchcmp"};
    }

    public Serializable deserializeHistoryDataItem(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        return (Serializable)ois.readObject();
    }

    public void buildInitialHistoryDataItemSubtree(Serializable historyDataItem, DMBrowserNode parentNode) {
        ServiceRegistryAccess registryAccess = ServiceRegistry.createAccessFor((Object)this);
        TypedDatumSerializer serializer = ((TypedDatumService)registryAccess.getService(TypedDatumService.class)).getSerializer();
        if (historyDataItem instanceof String) {
            SwitchComponentHistoryDataItem historyData;
            try {
                historyData = SwitchComponentHistoryDataItem.fromString((String)((String)((Object)historyDataItem)), (TypedDatumSerializer)serializer);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            String storedFormatVersion = historyData.getStoredFormatVersion();
            String storedFV = storedFormatVersion.split(":")[1];
            String currentFV = historyData.getFormatVersion().split(":")[1];
            CommonHistoryDataItemSubtreeBuilderUtils.buildDefaultHistoryDataItemSubtrees((DefaultComponentHistoryDataItem)historyData, (DMBrowserNode)parentNode);
            if (storedFormatVersion.equals(historyData.getFormatVersion()) && currentFV.equals("2")) {
                DMBrowserNode conditionsNode = DMBrowserNode.addNewChildNode((String)"Conditions", (DMBrowserNodeType)DMBrowserNodeType.Custom, (DMBrowserNode)parentNode);
                conditionsNode.setIcon(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.QUESTION_MARK_16));
                DMBrowserNode writeToFirstConditionNode = DMBrowserNode.addNewLeafNode((String)(String.valueOf(Messages.writeOutputLabel) + ": " + org.apache.commons.lang3.StringUtils.abbreviate((String)historyData.getWriteToFirstCondition(), (int)30)), (DMBrowserNodeType)DMBrowserNodeType.InformationText, (DMBrowserNode)conditionsNode);
                writeToFirstConditionNode.setFileContentAndName(historyData.getWriteToFirstCondition(), Messages.writeOutputLabel);
                ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
                HashMap actualConditions = new HashMap();
                try {
                    actualConditions = (HashMap)mapper.readValue(historyData.getActualCondition(), Map.class);
                }
                catch (IOException e) {
                    throw new RuntimeException(EXCEPTION_MESSAGE_READING, e);
                }
                ArrayList templateConditions = (ArrayList)SwitchCondition.getSwitchConditionList((String)historyData.getConditionPattern());
                for (Map.Entry entry : actualConditions.entrySet()) {
                    int key = Integer.parseInt((String)entry.getKey());
                    String scriptTemplate = ((SwitchCondition)templateConditions.get(key - 1)).getConditionScript();
                    DMBrowserNode conditionNode = DMBrowserNode.addNewChildNode((String)("Condition " + key + ": " + scriptTemplate), (DMBrowserNodeType)DMBrowserNodeType.Custom, (DMBrowserNode)conditionsNode);
                    conditionNode.setIcon(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.QUESTION_MARK_16));
                    DMBrowserNode actualConditionnode = DMBrowserNode.addNewLeafNode((String)("Actual: " + org.apache.commons.lang3.StringUtils.abbreviate((String)((String)entry.getValue()), (int)30)), (DMBrowserNodeType)DMBrowserNodeType.CommonText, (DMBrowserNode)conditionNode);
                    actualConditionnode.setFileContentAndName((String)entry.getValue(), "Actual Condition " + key);
                }
            } else if (storedFV.equals("1")) {
                DMBrowserNode conditionNode = DMBrowserNode.addNewChildNode((String)"Condition", (DMBrowserNodeType)DMBrowserNodeType.Custom, (DMBrowserNode)parentNode);
                conditionNode.setIcon(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.QUESTION_MARK_16));
                DMBrowserNode actualConditionnode = DMBrowserNode.addNewLeafNode((String)("Actual: " + org.apache.commons.lang3.StringUtils.abbreviate((String)historyData.getActualCondition(), (int)30)), (DMBrowserNodeType)DMBrowserNodeType.CommonText, (DMBrowserNode)conditionNode);
                actualConditionnode.setFileContentAndName(historyData.getActualCondition(), "Actual condition");
                DMBrowserNode templateConditionnode = DMBrowserNode.addNewLeafNode((String)("Pattern: " + org.apache.commons.lang3.StringUtils.abbreviate((String)historyData.getConditionPattern(), (int)30)), (DMBrowserNodeType)DMBrowserNodeType.CommonText, (DMBrowserNode)conditionNode);
                templateConditionnode.setFileContentAndName(historyData.getConditionPattern(), "Condition pattern");
            }
        } else {
            String exceptionInformationText = "";
            exceptionInformationText = historyDataItem != null ? StringUtils.format((String)"Parsing history data point failed: Expected type %s, but was of type %s", (Object[])new Object[]{String.class.getCanonicalName(), historyDataItem.getClass().getCanonicalName()}) : StringUtils.format((String)"Parsing history data point failed: Expected type %s, actual type not available.", (Object[])new Object[]{String.class.getCanonicalName()});
            throw new IllegalArgumentException(exceptionInformationText);
        }
    }

    public Image getComponentIcon(String historyDataItemIdentifier) {
        return COMPONENT_ICON;
    }
}

