/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.gui;

import de.rcenvironment.components.switchcmp.gui.SwitchConditionSection;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.EditDynamicEndpointCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;

public class SwitchEditDynamicEndpointCommand
extends EditDynamicEndpointCommand {
    SwitchEditDynamicEndpointCommand(EndpointType direction, EndpointDescription oldDescription, EndpointDescription newDescription, Refreshable[] refreshable) {
        super(direction, oldDescription, newDescription, refreshable);
    }

    public void execute() {
        super.execute();
        if (!this.newDesc.getName().equals(this.oldDesc.getName()) || !this.newDesc.getDataType().equals((Object)this.oldDesc.getDataType())) {
            this.setDataToOutput(this.oldDesc.getName(), this.newDesc.getName(), this.newDesc.getDataType());
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }

    public void undo() {
        super.undo();
        if (!this.newDesc.getName().equals(this.oldDesc.getName()) || !this.newDesc.getDataType().equals((Object)this.oldDesc.getDataType())) {
            this.setDataToOutput(this.newDesc.getName(), this.oldDesc.getName(), this.oldDesc.getDataType());
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }

    public void setDataToOutput(String oldName, String newName, DataType dataType) {
        WorkflowNode workflowNode = this.getWorkflowNode();
        String conTable = workflowNode.getConfigurationDescription().getConfigurationValue("conditionKey");
        int numOfCon = SwitchConditionSection.getTableContentLength(conTable);
        if (numOfCon != 0) {
            EndpointDescriptionsManager outputManager = workflowNode.getOutputDescriptionsManager();
            int i = 1;
            while (i <= numOfCon) {
                EndpointDescription endpointCondition = outputManager.getEndpointDescription(String.valueOf(oldName) + "_condition" + " " + i);
                workflowNode.getOutputDescriptionsManager().editDynamicEndpointDescription(String.valueOf(oldName) + "_condition" + " " + i, String.valueOf(newName) + "_condition" + " " + i, dataType, endpointCondition.getMetaData());
                if (i == 1) {
                    EndpointDescription endpointNoMatch = outputManager.getEndpointDescription(String.valueOf(oldName) + "_no match");
                    workflowNode.getOutputDescriptionsManager().editDynamicEndpointDescription(String.valueOf(oldName) + "_no match", String.valueOf(newName) + "_no match", dataType, endpointNoMatch.getMetaData());
                }
                ++i;
            }
        }
    }
}

