/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.properties;

import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointSelectionPane;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class EndpointPropertySection
extends ValidatingWorkflowNodePropertySection
implements PropertyChangeListener {
    private static final int OFFSET_ENPOINTPANES = 20;
    protected Composite endpointsComposite;
    protected Composite parentComposite;
    private boolean listenerRegistered = false;
    private EndpointSelectionPane[] panes;
    private int columns;

    @Override
    public void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createCompositeContent(parent, aTabbedPropertySheetPage);
        this.parentComposite = parent;
        TabbedPropertySheetWidgetFactory toolkit = aTabbedPropertySheetPage.getWidgetFactory();
        WorkflowNodePropertySection.LayoutComposite content = new WorkflowNodePropertySection.LayoutComposite(parent, 0);
        this.endpointsComposite = toolkit.createFlatFormComposite((Composite)content);
        GridLayout layout = new GridLayout(this.columns, true);
        this.endpointsComposite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        EndpointSelectionPane[] endpointSelectionPaneArray = this.panes;
        int n = this.panes.length;
        int n2 = 0;
        while (n2 < n) {
            EndpointSelectionPane pane = endpointSelectionPaneArray[n2];
            pane.createControl(this.endpointsComposite, pane.paneTitle, (FormToolkit)toolkit);
            pane.getControl().setLayoutData((Object)layoutData);
            ++n2;
        }
    }

    @Override
    public void refreshSection() {
        super.refreshSection();
        ComponentInstanceProperties configuration = this.getConfiguration();
        if (this.panes != null) {
            EndpointSelectionPane[] endpointSelectionPaneArray = this.panes;
            int n = this.panes.length;
            int n2 = 0;
            while (n2 < n) {
                EndpointSelectionPane pane = endpointSelectionPaneArray[n2];
                pane.setConfiguration(configuration);
                ++n2;
            }
        }
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.refreshSection();
        if (this.endpointsComposite != null) {
            if (this.panes.length > 1) {
                this.endpointsComposite.setSize(this.endpointsComposite.getSize().x - 20, this.endpointsComposite.getSize().y);
                this.endpointsComposite.pack();
            } else {
                this.endpointsComposite.setSize(this.parentComposite.getSize().x, this.endpointsComposite.getSize().y);
            }
            this.parentComposite.getParent().layout(this.endpointsComposite.getChildren());
        }
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (this.node != null && !this.listenerRegistered) {
            this.node.addPropertyChangeListener((PropertyChangeListener)this);
            this.listenerRegistered = true;
        }
    }

    public EndpointSelectionPane[] getPanes() {
        return this.panes;
    }

    public void setPanes(EndpointSelectionPane ... panes) {
        this.panes = panes;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("de.rcenvironment.rce.component.endpoint.ComponentDescriptionsEndpoint")) {
            this.refreshSection();
        }
    }

    @Override
    protected void beforeTearingDownModelBinding() {
        if (this.node != null) {
            this.node.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.listenerRegistered = false;
        super.beforeTearingDownModelBinding();
    }
}

