/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;

public class PDFExponential
extends PDFGenericFunction
implements PDFFunction {
    private float[] C0 = new float[]{0.0f};
    private float[] C1 = new float[]{1.0f};
    private float N;
    int returnValues;

    public PDFExponential(float f, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        super(fArray3, fArray4);
        this.N = f;
        if (fArray != null) {
            this.C0 = fArray;
        }
        if (fArray2 != null) {
            this.C1 = fArray2;
        }
        this.returnValues = this.C0.length;
    }

    public float[] computeStitch(float[] fArray) {
        return this.compute(fArray);
    }

    public float[] compute(float[] fArray) {
        float[] fArray2 = new float[this.returnValues];
        float[] fArray3 = new float[this.returnValues];
        float f = PDFExponential.min(PDFExponential.max(fArray[0], this.domain[0]), this.domain[1]);
        if (this.N == 1.0f) {
            for (int i = 0; i < this.C0.length; ++i) {
                fArray2[i] = this.C0[i] + f * (this.C1[i] - this.C0[i]);
                if (this.range != null) {
                    fArray2[i] = PDFExponential.min(PDFExponential.max(fArray2[i], this.range[i * 2]), this.range[i * 2 + 1]);
                }
                fArray3[i] = fArray2[i];
            }
        } else {
            for (int i = 0; i < this.C0.length; ++i) {
                fArray2[i] = this.C0[i] + (float)Math.pow(f, this.N) * (this.C1[i] - this.C0[i]);
                if (this.range != null) {
                    fArray2[i] = PDFExponential.min(PDFExponential.max(fArray2[i], this.range[i * 2]), this.range[i * 2 + 1]);
                }
                fArray3[i] = fArray2[i];
            }
        }
        return fArray3;
    }
}

