/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.component.datamanagement.api.CommonComponentHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;

public class SwitchComponentHistoryDataItem
extends CommonComponentHistoryDataItem {
    public static final String FORMAT_VERSION_1 = "1";
    public static final String FORMAT_VERSION_2 = "2";
    private static final String CURRENT_FORMAT_VERSION = "2";
    private static final long serialVersionUID = 7371817804674417738L;
    private static final String ACTUAL_CONDITION = "ac";
    private static final String CONDITION_PATTERN = "cp";
    private static final String WRITE_TO_FIRST_CONDITION = "wriOutCb";
    private String actualCondition;
    private String conditionPattern;
    private String writeToFirstCondition;
    private String storedFormatVersion;

    public void setActualCondition(String actualCondition) {
        this.actualCondition = actualCondition;
    }

    public String getActualCondition() {
        return this.actualCondition;
    }

    public void setConditionPattern(String conditionPattern) {
        this.conditionPattern = conditionPattern;
    }

    public String getConditionPattern() {
        return this.conditionPattern;
    }

    public void setWriteToFirstCondition(String writeToFirstCondition) {
        this.writeToFirstCondition = writeToFirstCondition;
    }

    public String getWriteToFirstCondition() {
        return this.writeToFirstCondition;
    }

    public String getStoredFormatVersion() {
        return this.storedFormatVersion;
    }

    public void setStoredFormatVersion(String storedformatVersion) {
        this.storedFormatVersion = storedformatVersion;
    }

    public String getFormatVersion() {
        return StringUtils.escapeAndConcat((String[])new String[]{super.getFormatVersion(), "2"});
    }

    public String serialize(TypedDatumSerializer serializer) throws IOException {
        JsonNode rootNode;
        String data = super.serialize(serializer);
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            rootNode = mapper.readTree(data);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        ((ObjectNode)rootNode).put(ACTUAL_CONDITION, this.actualCondition);
        ((ObjectNode)rootNode).put(CONDITION_PATTERN, this.conditionPattern);
        ((ObjectNode)rootNode).put(WRITE_TO_FIRST_CONDITION, this.writeToFirstCondition);
        ((ObjectNode)rootNode).put("f_v", this.getFormatVersion());
        return rootNode.toString();
    }

    public static SwitchComponentHistoryDataItem fromString(String historyData, TypedDatumSerializer serializer) throws IOException {
        SwitchComponentHistoryDataItem historyDataItem = new SwitchComponentHistoryDataItem();
        CommonComponentHistoryDataItem.initializeCommonHistoryDataFromString((CommonComponentHistoryDataItem)historyDataItem, (String)historyData, (TypedDatumSerializer)serializer);
        SwitchComponentHistoryDataItem.readReferenceFromString(historyData, historyDataItem);
        return historyDataItem;
    }

    private static void readReferenceFromString(String historyData, SwitchComponentHistoryDataItem historyDataItem) throws IOException {
        JsonNode rootNode;
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            rootNode = mapper.readTree(historyData);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        historyDataItem.actualCondition = ((ObjectNode)rootNode).get(ACTUAL_CONDITION).textValue();
        historyDataItem.conditionPattern = ((ObjectNode)rootNode).get(CONDITION_PATTERN).textValue();
        if (((ObjectNode)rootNode).get(WRITE_TO_FIRST_CONDITION) != null) {
            historyDataItem.writeToFirstCondition = ((ObjectNode)rootNode).get(WRITE_TO_FIRST_CONDITION).textValue();
        }
        historyDataItem.storedFormatVersion = ((ObjectNode)rootNode).get("f_v").textValue();
    }
}

