/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.datamanagement.commons;

import de.rcenvironment.core.authorization.AuthorizationException;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.datamanagement.DataManagementService;
import de.rcenvironment.core.gui.datamanagement.browser.Activator;
import de.rcenvironment.core.gui.utils.common.EditorsHelper;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;

public final class DataManagementWorkbenchUtils {
    private static final DataManagementWorkbenchUtils INSTANCE = new DataManagementWorkbenchUtils();
    private final DataManagementService dataManagementService;
    private final Log log = LogFactory.getLog(DataManagementWorkbenchUtils.class);

    private DataManagementWorkbenchUtils() {
        this.dataManagementService = (DataManagementService)ServiceRegistry.createAccessFor((Object)this).getService(DataManagementService.class);
    }

    public static DataManagementWorkbenchUtils getInstance() {
        return INSTANCE;
    }

    public DataManagementService getDataManagementService() {
        return this.dataManagementService;
    }

    public void saveReferenceToFile(String dataReferenceId, String fileReferencePath, String filename, ResolvableNodeId rceNodeIdentifier) throws AuthorizationException, IOException {
        File file = new File(filename);
        if (dataReferenceId != null && fileReferencePath == null) {
            try {
                this.dataManagementService.copyReferenceToLocalFile(dataReferenceId, file, (NetworkDestination)rceNodeIdentifier);
            }
            catch (CommunicationException e) {
                throw new RuntimeException(String.valueOf(StringUtils.format((String)"Failed to copy data reference from remote node @%s to local file: ", (Object[])new Object[]{rceNodeIdentifier})) + e.getMessage(), e);
            }
        } else if (dataReferenceId == null && fileReferencePath != null) {
            File tempFile = new File(fileReferencePath);
            Files.copy(tempFile.toPath(), file.toPath(), StandardCopyOption.COPY_ATTRIBUTES);
        } else if (dataReferenceId != null && fileReferencePath != null) {
            this.log.debug((Object)"When saving file both data reference ID and file reference path are set. Only one of these should be set.");
        } else if (dataReferenceId == null && fileReferencePath == null) {
            this.log.debug((Object)"When saving file neither data reference ID nor file reference path are set. One of these should be set.");
        }
    }

    public void tryOpenDataReferenceInReadonlyEditor(final String dataReferenceId, final String fileReferencePath, final String filename, final ResolvableNodeId rceNodeIdentifier, final boolean inTiglViewer) {
        if (dataReferenceId != null && fileReferencePath == null) {
            Job openJob = new Job("Loading data"){

                protected IStatus run(IProgressMonitor monitor) {
                    File tempFile = null;
                    try {
                        File tempDir = new File(Activator.getInstance().getBundleSpecificTempDir(), dataReferenceId);
                        tempDir.mkdir();
                        if (!tempDir.mkdir() && !tempDir.exists()) {
                            DataManagementWorkbenchUtils.this.log.error((Object)("Temp directory could not be created or did already exist as file: " + tempDir));
                            return Status.OK_STATUS;
                        }
                        tempFile = new File(tempDir, filename);
                        if (!tempDir.exists() || tempDir.list().length != 1 || !tempDir.list()[0].equals(filename)) {
                            DataManagementWorkbenchUtils.this.dataManagementService.copyReferenceToLocalFile(dataReferenceId, tempFile, (NetworkDestination)rceNodeIdentifier);
                        }
                        if (inTiglViewer) {
                            DataManagementWorkbenchUtils.this.openInTigl(tempFile);
                        } else {
                            DataManagementWorkbenchUtils.this.openInEditor(tempFile);
                        }
                    }
                    catch (AuthorizationException e) {
                        DataManagementWorkbenchUtils.this.log.error((Object)"Failed to copy datamanagement reference to local file.", (Throwable)e);
                    }
                    catch (IOException e) {
                        DataManagementWorkbenchUtils.this.log.error((Object)"Failed to copy datamanagement reference to local file.", (Throwable)e);
                    }
                    catch (CommunicationException e) {
                        throw new RuntimeException(String.valueOf(StringUtils.format((String)"Failed to copy data reference from remote node @%s to local file: ", (Object[])new Object[]{rceNodeIdentifier})) + e.getMessage(), e);
                    }
                    return Status.OK_STATUS;
                }
            };
            openJob.setUser(true);
            openJob.schedule();
        } else if (dataReferenceId == null && fileReferencePath != null) {
            Job openJob = new Job("Loading data"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (inTiglViewer) {
                        DataManagementWorkbenchUtils.this.openInTigl(new File(fileReferencePath));
                    } else {
                        DataManagementWorkbenchUtils.this.openInEditor(new File(fileReferencePath));
                    }
                    return Status.OK_STATUS;
                }
            };
            openJob.setUser(true);
            openJob.schedule();
        } else if (dataReferenceId != null && fileReferencePath != null) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Open in Editor", (String)"Failed to open data in editor. Refresh the workflow entry and try again.");
            this.log.error((Object)"When opening in editor both data reference ID and file reference path are set. Only one of these should be set.");
        } else if (dataReferenceId == null && fileReferencePath == null) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Open in Editor", (String)"Failed to open data in editor. Refresh the workflow entry and try again.");
            this.log.warn((Object)"When opening in editor neither data reference ID nor file reference path are set. One of these should be set.");
        }
    }

    private void openInEditor(final File tempFile) {
        tempFile.setWritable(false);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    String fileName = tempFile.getName();
                    String fileExtension = EditorsHelper.getExtension((String)fileName);
                    if (fileExtension.equals("wf")) {
                        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(tempFile.getAbsolutePath()));
                        FileStoreEditorInput editorInput = new FileStoreEditorInput(fileStore);
                        final IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, "de.rcenvironment.rce.gui.workflow.editor.ReadOnlyWorkflowEditor");
                        if (editor != null) {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.PropertySheet");
                            PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                                public boolean preShutdown(IWorkbench workbench, boolean arg1) {
                                    EditorsHelper.closeEditor((IEditorPart)editor, (boolean)false);
                                    return true;
                                }

                                public void postShutdown(IWorkbench workbench) {
                                }
                            });
                        }
                    } else {
                        EditorsHelper.openExternalFileInEditor((File)tempFile, (Runnable[])new Runnable[0]);
                    }
                }
                catch (PartInitException e) {
                    DataManagementWorkbenchUtils.this.log.error((Object)"Failed to open datamanagement reference copied to local file in an editor.", (Throwable)e);
                }
            }
        });
    }

    private void openInTigl(final File tempFile) {
        tempFile.setWritable(false);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    String secondId = null;
                    try {
                        secondId = tempFile.getCanonicalPath();
                        secondId = secondId.replaceAll(":", "&#38");
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("de.rcenvironment.core.gui.tiglviewer.views.TIGLViewer", secondId, 1);
                    }
                    catch (IOException e) {
                        DataManagementWorkbenchUtils.this.log.error((Object)e);
                    }
                }
                catch (PartInitException e) {
                    DataManagementWorkbenchUtils.this.log.error((Object)e);
                    DataManagementWorkbenchUtils.this.log.error((Object)"Failed to open datamanagement reference copied to local file in the TiGL.", (Throwable)e);
                }
            }
        });
    }
}

