/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.toolintegration.api;

import de.rcenvironment.core.datamodel.api.EndpointActionType;
import java.util.Map;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;

public abstract class ToolIntegrationWizardPage
extends WizardPage {
    protected MenuItem itemAdd;
    protected MenuItem itemEdit;
    protected MenuItem itemRemove;

    protected ToolIntegrationWizardPage(String pageName) {
        super(pageName);
    }

    protected void fillContextMenu(Table tab) {
        Menu menu = new Menu((Control)tab);
        this.itemAdd = new MenuItem(menu, 8);
        this.itemAdd.setText(EndpointActionType.ADD.toString());
        this.itemEdit = new MenuItem(menu, 8);
        this.itemEdit.setText(EndpointActionType.EDIT.toString());
        this.itemRemove = new MenuItem(menu, 8);
        this.itemRemove.setText(EndpointActionType.REMOVE.toString());
        final ButtonSelectionAdapter buttonListener = new ButtonSelectionAdapter(this.itemAdd, this.itemEdit, this.itemRemove, tab);
        this.itemRemove.addSelectionListener((SelectionListener)buttonListener);
        this.itemEdit.addSelectionListener((SelectionListener)buttonListener);
        this.itemAdd.addSelectionListener((SelectionListener)buttonListener);
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent arg0) {
                ((ButtonSelectionAdapter)buttonListener).updateContextActivation();
            }

            public void menuHidden(MenuEvent arg0) {
            }
        });
        tab.setMenu(menu);
        buttonListener.updateContextActivation();
    }

    public abstract void setConfigMap(Map<String, Object> var1);

    protected void onAddClicked() {
    }

    protected void onEditClicked() {
    }

    protected void onRemoveClicked() {
    }

    public abstract void updatePage();

    private class ButtonSelectionAdapter
    extends SelectionAdapter {
        private MenuItem itemAdd;
        private MenuItem itemEdit;
        private MenuItem itemRemove;
        private Table table;

        ButtonSelectionAdapter(MenuItem itemAdd, MenuItem itemEdit, MenuItem itemRemove, Table tab) {
            this.itemAdd = itemAdd;
            this.itemEdit = itemEdit;
            this.itemRemove = itemRemove;
            this.table = tab;
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.itemAdd) {
                ToolIntegrationWizardPage.this.onAddClicked();
            } else if (e.widget == this.itemEdit) {
                ToolIntegrationWizardPage.this.onEditClicked();
            } else if (e.widget == this.itemRemove) {
                ToolIntegrationWizardPage.this.onRemoveClicked();
            }
            this.updateContextActivation();
        }

        private void updateContextActivation() {
            this.itemEdit.setEnabled(this.table.getSelectionCount() > 0);
            this.itemRemove.setEnabled(this.table.getSelectionCount() > 0);
        }
    }
}

