/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.toolkitbridge.internal;

import de.rcenvironment.core.toolkitbridge.internal.DefaultToolkitConfiguration;
import de.rcenvironment.core.utils.common.VersionUtils;
import de.rcenvironment.toolkit.core.api.ToolkitException;
import de.rcenvironment.toolkit.core.setup.ToolkitSetup;
import de.rcenvironment.toolkit.modules.concurrency.setup.ConcurrencyModule;
import de.rcenvironment.toolkit.modules.concurrency.setup.ConcurrencyModuleConfiguration;
import de.rcenvironment.toolkit.modules.statistics.api.StatisticsFilterLevel;
import de.rcenvironment.toolkit.modules.statistics.setup.StatisticsModule;
import de.rcenvironment.toolkit.modules.statistics.setup.StatisticsModuleConfiguration;

public final class LiveToolkitConfiguration
extends DefaultToolkitConfiguration {
    private static final String SYSTEM_PROPERTY_COMMMON_THREAD_POOL_SIZE = "rce.threadpool.common.size";
    private static final String SYSTEM_PROPERTY_ENABLE_PERIODIC_DEBUG_TASK_LOGGING = "rce.threadpool.enableDebugLogging";
    private static final int PERIODIC_DEBUG_TASK_LOGGING_INTERVAL_MSEC = 60000;

    @Override
    public void configure(ToolkitSetup setup) throws ToolkitException {
        super.configure(setup);
        this.applyConcurrencySettings((ConcurrencyModuleConfiguration)setup.configureModule(ConcurrencyModule.class));
        StatisticsFilterLevel statisticsLevel = VersionUtils.isReleaseOrReleaseCandidate() ? StatisticsFilterLevel.RELEASE : StatisticsFilterLevel.DEVELOPMENT;
        ((StatisticsModuleConfiguration)setup.configureModule(StatisticsModule.class)).setStatisticsFilterLevel(statisticsLevel);
    }

    private void applyConcurrencySettings(ConcurrencyModuleConfiguration configuration) {
        if (System.getProperty(SYSTEM_PROPERTY_COMMMON_THREAD_POOL_SIZE) != null) {
            int commonPoolSize = Integer.parseInt(System.getProperty(SYSTEM_PROPERTY_COMMMON_THREAD_POOL_SIZE));
            if (commonPoolSize < 1) {
                throw new IllegalArgumentException("Invalid thread pool size value: " + commonPoolSize);
            }
            configuration.setThreadPoolSize(commonPoolSize);
        }
        configuration.setThreadPoolName("MainThreadPool");
        if (System.getProperty(SYSTEM_PROPERTY_ENABLE_PERIODIC_DEBUG_TASK_LOGGING) != null) {
            configuration.setPeriodicTaskLoggingIntervalMsec(60000);
        }
    }
}

