/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.database.execution;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import de.rcenvironment.components.database.common.DatabaseComponentConstants;
import de.rcenvironment.components.database.common.DatabaseComponentHistoryDataItem;
import de.rcenvironment.components.database.common.DatabaseStatement;
import de.rcenvironment.components.database.common.jdbc.JDBCDriverInformation;
import de.rcenvironment.components.database.common.jdbc.JDBCDriverService;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.execution.api.Component;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.model.api.LocalExecutionOnly;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.BooleanTD;
import de.rcenvironment.core.datamodel.types.api.FloatTD;
import de.rcenvironment.core.datamodel.types.api.IntegerTD;
import de.rcenvironment.core.datamodel.types.api.ShortTextTD;
import de.rcenvironment.core.datamodel.types.api.SmallTableTD;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@LocalExecutionOnly
public class DatabaseComponent
extends DefaultComponent {
    private static final String ERROR_FILLING_SMALL_TABLE = "Error when filling the output '%s' of type small table.";
    private static final String FULL_STOP = ".";
    private static final String SAVEPOINT = "RCEdatabaseTrancactionSavepoint";
    private static final int MINUS_ONE = -1;
    private static final String SEMICOLON = ";";
    private static final String JDBC = "jdbc";
    private static final String SLASH = "/";
    private static final String DOUBLE_SLASH = "//";
    private static final String COLON = ":";
    private static TypedDatumService typedDatumService;
    private static JDBCDriverService jdbcDriverService;
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Savepoint transactionSavepoint;
    private List<Object> inputOrder = new ArrayList<Object>();
    private ComponentContext componentContext;
    private List<DatabaseStatement> databaseStatements;
    private Connection jdbcConnection = null;
    private DatabaseComponentHistoryDataItem databaseWorkflowDataItem;

    private void initializeNewWorkflowDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.databaseWorkflowDataItem = new DatabaseComponentHistoryDataItem("de.rcenvironment.database");
        }
    }

    private void writeFinalWorkflowDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.componentContext.writeFinalHistoryDataItem((ComponentHistoryDataItem)this.databaseWorkflowDataItem);
        }
    }

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    public void start() throws ComponentException {
        jdbcDriverService = (JDBCDriverService)this.componentContext.getService(JDBCDriverService.class);
        typedDatumService = (TypedDatumService)this.componentContext.getService(TypedDatumService.class);
        super.start();
        if (this.componentContext.getInputs().isEmpty()) {
            this.runDatabaseComponent();
        }
    }

    public void processInputs() throws ComponentException {
        this.runDatabaseComponent();
        super.processInputs();
    }

    public boolean treatStartAsComponentRun() {
        return this.componentContext.getInputs().isEmpty();
    }

    private void runDatabaseComponent() throws ComponentException {
        this.initializeNewWorkflowDataItem();
        this.databaseStatements = this.parseAndValidateStatements();
        HashMap<String, TypedDatum> inputValues = new HashMap<String, TypedDatum>();
        if (this.componentContext != null && this.componentContext.getInputsWithDatum() != null) {
            for (String inputName : this.componentContext.getInputsWithDatum()) {
                inputValues.put(inputName, this.componentContext.readInput(inputName));
            }
        }
        String statementPart = " statement";
        if (this.databaseStatements.size() > 1) {
            statementPart = " statements";
        }
        this.componentContext.getLog().componentInfo("Executing " + this.databaseStatements.size() + statementPart + FULL_STOP);
        boolean autoCommit = false;
        try {
            try {
                try {
                    if (this.jdbcConnection == null || this.jdbcConnection.isClosed()) {
                        this.jdbcConnection = this.getConnection();
                    }
                    autoCommit = this.jdbcConnection.getAutoCommit();
                    this.jdbcConnection.setAutoCommit(false);
                    this.transactionSavepoint = this.jdbcConnection.setSavepoint(SAVEPOINT);
                }
                catch (SQLException e) {
                    throw new ComponentException("Failed to initialize database connection. Database response: " + e.getMessage());
                }
                for (DatabaseStatement databaseStatement : this.databaseStatements) {
                    if (!databaseStatement.getStatement().isEmpty()) {
                        boolean statementTypeSupported = this.statementTypeIsSupportedGeneral(databaseStatement.getStatement());
                        if (statementTypeSupported) {
                            String preparedStatementString;
                            boolean statementContainsSmalltablePlaceholder = this.statementContainsSmalltablePlaceholder(databaseStatement.getStatement(), inputValues);
                            if (!statementContainsSmalltablePlaceholder) {
                                preparedStatementString = this.replaceStringAndFillInputOrder(databaseStatement.getStatement(), inputValues);
                                databaseStatement.setStatement(preparedStatementString);
                                try {
                                    try {
                                        this.runSqlStatementUsingPreparedStatement(databaseStatement);
                                        continue;
                                    }
                                    catch (SQLException e) {
                                        throw new ComponentException("Failure during execution of database statement '" + databaseStatement.getName() + "' (" + databaseStatement.getStatement() + "). Database response: " + e.getMessage());
                                    }
                                }
                                finally {
                                    this.inputOrder.clear();
                                }
                            }
                            if (this.statementTypeIsSupportedForSmalltable(databaseStatement.getStatement())) {
                                preparedStatementString = this.replaceStringAndFillInputOrder(databaseStatement.getStatement(), inputValues);
                                databaseStatement.setStatement(preparedStatementString);
                                try {
                                    try {
                                        this.runSqlStatementUsingPreparedStatementForSmalltables(databaseStatement, inputValues);
                                        continue;
                                    }
                                    catch (SQLException e) {
                                        throw new ComponentException("Failure during execution of database statement '" + databaseStatement.getName() + "' (" + databaseStatement.getStatement() + "). Database response: " + e.getMessage());
                                    }
                                }
                                finally {
                                    this.inputOrder.clear();
                                }
                            }
                            this.componentContext.getLog().componentWarn("Database query '" + databaseStatement.getName() + "' could not be matched to the allowed query types that use small table inputs. " + "The query will be skipped. Currently 'Insert' is supported for small table inputs.");
                            continue;
                        }
                        this.componentContext.getLog().componentWarn("Database query '" + databaseStatement.getStatement() + "' could not be matched to the allowed query types and will be skipped. " + "Currently 'Select', 'Insert', 'Update' and 'Delete' are supported.");
                        continue;
                    }
                    this.componentContext.getLog().componentWarn("Database query with name '" + databaseStatement.getName() + "' is empty and will be skipped.");
                }
                try {
                    this.jdbcConnection.commit();
                }
                catch (SQLException e) {
                    throw new ComponentException("Failed to commit transaction. Database response: " + e.getMessage());
                }
            }
            catch (ComponentException e) {
                try {
                    this.jdbcConnection.rollback(this.transactionSavepoint);
                }
                catch (SQLException e2) {
                    throw new ComponentException("Failed to rollback database. " + e2.getMessage());
                }
                throw e;
            }
        }
        finally {
            if (this.jdbcConnection == null) {
                String host = this.componentContext.getConfigurationValue("databaseHost");
                String port = this.componentContext.getConfigurationValue("databasePort");
                String scheme = this.componentContext.getConfigurationValue("databaseScheme");
                throw new ComponentException("Failed to establish database connection. Is the database, username and password correctly defined? You entered -> Host: '" + host + "'; Port: '" + port + "'; Default Scheme: '" + scheme + "'. " + "Note that username and password are not stated here for security reasons.");
            }
            try {
                if (!this.jdbcConnection.isClosed()) {
                    if (this.transactionSavepoint != null) {
                        this.jdbcConnection.releaseSavepoint(this.transactionSavepoint);
                    }
                    this.jdbcConnection.setAutoCommit(autoCommit);
                    this.jdbcConnection.close();
                }
            }
            catch (SQLException e) {
                throw new ComponentException("Failed to release database resources. Database response: " + e.getMessage());
            }
        }
        this.componentContext.writeOutput("Success", (TypedDatum)typedDatumService.getFactory().createBoolean(true));
        this.writeFinalWorkflowDataItem();
    }

    private String buildInsertPlaceholderWithSize(int size) {
        String placeholder = " (";
        int i = 0;
        while (i < size) {
            placeholder = String.valueOf(placeholder) + "?";
            placeholder = String.valueOf(placeholder) + ",";
            ++i;
        }
        placeholder = placeholder.substring(0, placeholder.length() - 1);
        placeholder = String.valueOf(placeholder) + ") ";
        return placeholder;
    }

    public Connection getConnection() throws SQLException, ComponentException {
        String databaseHost = this.componentContext.getConfigurationValue("databaseHost");
        String databasePort = this.componentContext.getConfigurationValue("databasePort");
        String databaseConnector = this.componentContext.getConfigurationValue("databaseConnector");
        String databaseScheme = this.componentContext.getConfigurationValue("databaseScheme");
        String databaseUser = this.componentContext.getConfigurationValue("authUser");
        String databasePassword = this.componentContext.getConfigurationValue("authPhrase");
        if (jdbcDriverService.getRegisteredJDBCDrivers().isEmpty()) {
            String noRegisteredDriversWarning = "Failed to establish connection because no JDBC driver is registered. Please make sure the subfolder '.../configuration/jdbc' in your installation directory contains the desired driver file";
            this.componentContext.getLog().componentError(noRegisteredDriversWarning);
            throw new ComponentException(noRegisteredDriversWarning);
        }
        String urlScheme = "";
        for (JDBCDriverInformation driverInformation : jdbcDriverService.getRegisteredJDBCDrivers()) {
            if (!databaseConnector.equals(driverInformation.getDisplayName())) continue;
            urlScheme = driverInformation.getUrlScheme();
            break;
        }
        if (urlScheme.isEmpty()) {
            String urlSchemeEmptyWarning = "Failed to establish connection because no JDBC driver for the selected connector was found. Please make sure the subfolder '.../extras/database_connectors' in your installation directory contains the desired driver file";
            this.componentContext.getLog().componentError(urlSchemeEmptyWarning);
            throw new ComponentException(urlSchemeEmptyWarning);
        }
        String url = "jdbc:" + urlScheme + COLON + DOUBLE_SLASH + databaseHost + COLON + databasePort + SLASH + databaseScheme;
        Connection connection = null;
        if (databasePassword.isEmpty()) {
            databasePassword = null;
        }
        connection = jdbcDriverService.getConnectionWithCredentials(url, databaseUser, databasePassword);
        return connection;
    }

    private void runSqlStatementUsingPreparedStatement(DatabaseStatement databaseStatement) throws SQLException, ComponentException {
        boolean isManipulation;
        PreparedStatement preparedStatement = null;
        String sqlStatement = databaseStatement.getStatement();
        if (!sqlStatement.endsWith(SEMICOLON)) {
            sqlStatement = String.valueOf(sqlStatement) + SEMICOLON;
        }
        preparedStatement = this.jdbcConnection.prepareStatement(sqlStatement);
        if (!this.inputOrder.isEmpty()) {
            int i = 1;
            while (i < this.inputOrder.size() + 1) {
                Object inputToSet;
                if (this.inputOrder.get(i - 1) instanceof String) {
                    inputToSet = (String)this.inputOrder.get(i - 1);
                    preparedStatement.setString(i, (String)inputToSet);
                } else if (this.inputOrder.get(i - 1) instanceof Long) {
                    inputToSet = ((Long)this.inputOrder.get(i - 1)).intValue();
                    preparedStatement.setInt(i, (Integer)inputToSet);
                } else if (this.inputOrder.get(i - 1) instanceof Float) {
                    inputToSet = (Float)this.inputOrder.get(i - 1);
                    preparedStatement.setFloat(i, ((Float)inputToSet).floatValue());
                } else if (this.inputOrder.get(i - 1) instanceof Double) {
                    inputToSet = (Double)this.inputOrder.get(i - 1);
                    preparedStatement.setDouble(i, (Double)inputToSet);
                } else if (this.inputOrder.get(i - 1) instanceof Boolean) {
                    inputToSet = (Boolean)this.inputOrder.get(i - 1);
                    preparedStatement.setBoolean(i, (Boolean)inputToSet);
                }
                ++i;
            }
        }
        String effectiveQuery = preparedStatement.toString().substring(preparedStatement.toString().indexOf(COLON) + 2);
        if (this.databaseWorkflowDataItem != null) {
            this.databaseWorkflowDataItem.addDatabaseStatementHistoryData(databaseStatement.getIndex(), databaseStatement.getName(), sqlStatement, effectiveQuery);
        }
        this.componentContext.getLog().componentInfo("Sending query '" + effectiveQuery + "' to database.");
        ResultSet resultSet = null;
        boolean bl = isManipulation = effectiveQuery.toLowerCase().startsWith("insert") || effectiveQuery.toLowerCase().startsWith("update") || effectiveQuery.toLowerCase().startsWith("delete");
        if (isManipulation) {
            preparedStatement.executeUpdate();
        } else {
            resultSet = preparedStatement.executeQuery();
        }
        boolean hasResultSet = false;
        if (resultSet != null && resultSet.isBeforeFirst()) {
            if (resultSet.next()) {
                hasResultSet = true;
            }
            resultSet.beforeFirst();
        }
        if (resultSet != null && hasResultSet && databaseStatement.isWillWriteToOutput() && !databaseStatement.getOutputToWriteTo().isEmpty()) {
            this.distributeResults(databaseStatement.getOutputToWriteTo(), resultSet);
            if (!resultSet.isClosed()) {
                resultSet.close();
            }
        }
        if (!preparedStatement.isClosed()) {
            preparedStatement.close();
        }
    }

    private void runSqlStatementUsingPreparedStatementForSmalltables(DatabaseStatement databaseStatement, Map<String, TypedDatum> inputValues) throws SQLException, ComponentException {
        SmallTableTD smallTableToHandle = null;
        String smallTablePlaceholder = "";
        for (String key : inputValues.keySet()) {
            TypedDatum td = inputValues.get(key);
            String possiblePlaceholder = StringUtils.format((String)"${in:%s}", (Object[])new Object[]{key});
            if (!(td instanceof SmallTableTD) || !databaseStatement.getStatement().contains(possiblePlaceholder)) continue;
            if (smallTableToHandle == null) {
                smallTableToHandle = (SmallTableTD)td;
                smallTablePlaceholder = possiblePlaceholder;
                continue;
            }
            throw new ComponentException("Placeholder for small table input '" + key + "' is just allowed once per statement.");
        }
        if (smallTableToHandle == null) {
            throw new ComponentException("Could not find a small table in statement.");
        }
        PreparedStatement preparedStatement = null;
        int row = 0;
        while (row < smallTableToHandle.getRowCount()) {
            String sqlStatement = databaseStatement.getStatement();
            ArrayList<String> smallTableReplacements = new ArrayList<String>();
            int col = 0;
            while (col < smallTableToHandle.getColumnCount()) {
                String value = "";
                TypedDatum cell = smallTableToHandle.getTypedDatumOfCell(row, col);
                DataType dataType = cell.getDataType();
                if (dataType == DataType.Float) {
                    FloatTD floatTD = (FloatTD)cell;
                    value = String.valueOf(floatTD.getFloatValue());
                } else if (dataType == DataType.Integer) {
                    IntegerTD integerTD = (IntegerTD)cell;
                    value = String.valueOf(integerTD.getIntValue());
                } else if (dataType == DataType.ShortText) {
                    ShortTextTD shortTextTD = (ShortTextTD)cell;
                    value = shortTextTD.getShortTextValue();
                } else if (dataType == DataType.Boolean) {
                    BooleanTD booleanTD = (BooleanTD)cell;
                    value = String.valueOf(booleanTD.getBooleanValue());
                } else if (dataType == DataType.Empty) {
                    value = "";
                }
                smallTableReplacements.add(value);
                ++col;
            }
            int placeholdersLocation = sqlStatement.indexOf(smallTablePlaceholder);
            sqlStatement = String.valueOf(sqlStatement.substring(0, placeholdersLocation)) + sqlStatement.substring(placeholdersLocation + smallTablePlaceholder.length());
            String replace = this.buildInsertPlaceholderWithSize(smallTableToHandle.getColumnCount());
            if (!(sqlStatement = String.valueOf(sqlStatement.substring(0, placeholdersLocation)) + replace + sqlStatement.substring(placeholdersLocation)).trim().endsWith(SEMICOLON)) {
                sqlStatement = String.valueOf(sqlStatement) + SEMICOLON;
            }
            preparedStatement = this.jdbcConnection.prepareStatement(sqlStatement);
            int index = 1;
            for (String insertion : smallTableReplacements) {
                preparedStatement.setString(index, insertion);
                ++index;
            }
            String effectiveQuery = preparedStatement.toString().substring(preparedStatement.toString().indexOf(COLON) + 2);
            if (this.databaseWorkflowDataItem != null) {
                this.databaseWorkflowDataItem.addDatabaseStatementHistoryData(databaseStatement.getIndex(), databaseStatement.getName(), sqlStatement, effectiveQuery);
            }
            preparedStatement.executeUpdate();
            ++row;
        }
        if (preparedStatement == null) {
            throw new ComponentException("Error while executing Insert statement. Maybe the small table input is empty?");
        }
    }

    private List<DatabaseStatement> parseAndValidateStatements() throws ComponentException {
        List<DatabaseStatement> statementsToValidate = new ArrayList();
        String statementsString = this.componentContext.getConfigurationValue("databaseStatements");
        if (statementsString != null) {
            ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
            try {
                CollectionType javaType = mapper.getTypeFactory().constructCollectionType(List.class, DatabaseStatement.class);
                statementsToValidate = (List)mapper.readValue(statementsString, (JavaType)javaType);
            }
            catch (IOException e) {
                throw new ComponentException("Failed to parse SQL statements while initializing execution.", (Throwable)e);
            }
        } else {
            throw new ComponentException("An error occured while loading statements from configuration.");
        }
        for (DatabaseStatement statement : statementsToValidate) {
            boolean statementTypeSupported;
            String exceptionMessage = "The statement '" + statement.getName() + "' is configured to write to an output but no output is selected.";
            if (statement.isWillWriteToOutput()) {
                if (statement.getOutputToWriteTo() == null) {
                    throw new ComponentException(exceptionMessage);
                }
                if (statement.getOutputToWriteTo().isEmpty()) {
                    throw new ComponentException(exceptionMessage);
                }
            }
            if (statementTypeSupported = this.statementTypeIsSupportedGeneral(statement.getStatement())) continue;
            String errorMessage = "Statement '" + statement.getName() + "'" + " (" + statement.getStatement() + ") could not be matched to the allowed query types. " + "Currently 'Select', 'Insert', 'Update' and 'Delete' are supported.";
            throw new ComponentException(errorMessage);
        }
        this.componentContext.getLog().componentInfo("Statements validation successfully passed.");
        return statementsToValidate;
    }

    private boolean statementTypeIsSupportedGeneral(String statement) {
        for (String allowedStatement : Arrays.asList(DatabaseComponentConstants.STATEMENT_PREFIX_WHITELIST_GENERAL)) {
            if (!statement.toLowerCase().startsWith(allowedStatement)) continue;
            return true;
        }
        return false;
    }

    private boolean statementTypeIsSupportedForSmalltable(String statement) {
        for (String allowedStatement : Arrays.asList(DatabaseComponentConstants.STATEMENT_PREFIX_WHITELIST_SMALLTABLE)) {
            if (!statement.toLowerCase().startsWith(allowedStatement)) continue;
            return true;
        }
        return false;
    }

    private boolean statementContainsSmalltablePlaceholder(String databaseStatement, Map<String, TypedDatum> inputValues) {
        for (String key : inputValues.keySet()) {
            String possiblePlaceholder;
            if (inputValues.get(key).getDataType() != DataType.SmallTable || !databaseStatement.contains(possiblePlaceholder = StringUtils.format((String)"${in:%s}", (Object[])new Object[]{key}))) continue;
            return true;
        }
        return false;
    }

    public void completeStartOrProcessInputsAfterFailure() throws ComponentException {
        this.writeFinalWorkflowDataItem();
    }

    private String replaceStringAndFillInputOrder(String originalStatement, Map<String, TypedDatum> inputValues) {
        String currentStatement = originalStatement;
        HashMap<Integer, String> tempOccuranceToInputMapping = new HashMap<Integer, String>();
        for (String inputName : inputValues.keySet()) {
            String possiblePlaceholder;
            int firstIndex;
            if (inputValues.get(inputName).getDataType() != DataType.ShortText && inputValues.get(inputName).getDataType() != DataType.Float && inputValues.get(inputName).getDataType() != DataType.Integer && inputValues.get(inputName).getDataType() != DataType.Boolean || (firstIndex = currentStatement.indexOf(possiblePlaceholder = StringUtils.format((String)"${in:%s}", (Object[])new Object[]{inputName}))) == -1) continue;
            tempOccuranceToInputMapping.put(firstIndex, inputName);
        }
        if (tempOccuranceToInputMapping.size() > 0) {
            int minIndex = this.findMin(tempOccuranceToInputMapping.keySet());
            String firstAppearingInputName = (String)tempOccuranceToInputMapping.get(minIndex);
            TypedDatum firstAppearingTypedDatum = inputValues.get(firstAppearingInputName);
            if (firstAppearingTypedDatum.getDataType() == DataType.ShortText) {
                String stringToAdd = ((ShortTextTD)inputValues.get(firstAppearingInputName)).getShortTextValue();
                this.inputOrder.add(stringToAdd);
            } else if (firstAppearingTypedDatum.getDataType() == DataType.Float) {
                double floatToAdd = ((FloatTD)inputValues.get(firstAppearingInputName)).getFloatValue();
                this.inputOrder.add(floatToAdd);
            } else if (firstAppearingTypedDatum.getDataType() == DataType.Integer) {
                long integerToAdd = ((IntegerTD)inputValues.get(firstAppearingInputName)).getIntValue();
                this.inputOrder.add(integerToAdd);
            } else if (firstAppearingTypedDatum.getDataType() == DataType.Boolean) {
                Boolean booleanToAdd = ((BooleanTD)inputValues.get(firstAppearingInputName)).getBooleanValue();
                this.inputOrder.add(booleanToAdd);
            }
            String possiblePlaceholder = StringUtils.format((String)"${in:%s}", (Object[])new Object[]{firstAppearingInputName});
            String replacement = "?";
            String replacedStatement = String.valueOf(currentStatement.substring(0, minIndex)) + replacement + currentStatement.substring(minIndex + possiblePlaceholder.length());
            currentStatement = this.replaceStringAndFillInputOrder(replacedStatement, inputValues);
        }
        return currentStatement;
    }

    private int findMin(Set<Integer> indices) {
        int currentMin = Integer.MAX_VALUE;
        for (int index : indices) {
            if (index >= currentMin) continue;
            currentMin = index;
        }
        return currentMin;
    }

    private int determineResultSetsRowCount(ResultSet resultSet) throws ComponentException {
        int rowCount = 0;
        try {
            while (resultSet.next()) {
                ++rowCount;
            }
            resultSet.beforeFirst();
        }
        catch (SQLException e1) {
            throw new ComponentException("Failed to determine result set's row count.", (Throwable)e1);
        }
        return rowCount;
    }

    private int determineResultSetsColumnCount(ResultSet resultSet) throws ComponentException {
        try {
            return resultSet.getMetaData().getColumnCount();
        }
        catch (SQLException e1) {
            throw new ComponentException("Failed to determine result set's column count.", (Throwable)e1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TypedDatum convertResultSetToTypedDatum(ResultSet resultSet, String outputToWriteTo) throws SQLException, ComponentException {
        int columnCount = this.determineResultSetsColumnCount(resultSet);
        int rowCount = this.determineResultSetsRowCount(resultSet);
        this.componentContext.getLog().componentInfo("Processing result set with " + rowCount + " row(s) and " + columnCount + " column(s).");
        DataType dataType = this.componentContext.getOutputDataType(outputToWriteTo);
        TypedDatumFactory tdFactory = typedDatumService.getFactory();
        SmallTableTD result = null;
        if (columnCount == 0) throw new ComponentException("The database returned an empty result set although writing the result to an output was activated.");
        if (rowCount == 0) {
            throw new ComponentException("The database returned an empty result set although writing the result to an output was activated.");
        }
        if (columnCount == 1 && rowCount == 1) {
            if (dataType == DataType.SmallTable) {
                return this.convertResultSetToSmallTableTD(rowCount, columnCount, outputToWriteTo, resultSet);
            }
            resultSet.next();
            if (dataType == DataType.Float) {
                if (resultSet.getObject(1) instanceof Float) return tdFactory.createFloat(resultSet.getDouble(1));
                if (resultSet.getObject(1) instanceof Double) {
                    return tdFactory.createFloat(resultSet.getDouble(1));
                }
                if (resultSet.getObject(1) instanceof Integer) return tdFactory.createFloat((double)resultSet.getLong(1));
                if (!(resultSet.getObject(1) instanceof Long)) throw new ComponentException("Failed to convert result set to single float value.");
                return tdFactory.createFloat((double)resultSet.getLong(1));
            }
            if (dataType == DataType.Integer) {
                if (resultSet.getObject(1) instanceof Integer) return tdFactory.createInteger(resultSet.getLong(1));
                if (!(resultSet.getObject(1) instanceof Long)) throw new ComponentException("Failed to convert result set to single integer value.");
                return tdFactory.createInteger(resultSet.getLong(1));
            }
            if (dataType == DataType.ShortText) {
                if (!(resultSet.getObject(1) instanceof String)) throw new ComponentException("Failed to convert result set to single short text value.");
                return tdFactory.createShortText(resultSet.getString(1));
            }
            if (dataType != DataType.Boolean) return result;
            if (!(resultSet.getObject(1) instanceof Boolean)) throw new ComponentException("Failed to convert result set to single boolean value.");
            return tdFactory.createBoolean(resultSet.getBoolean(1));
        }
        if (columnCount <= 1) {
            if (rowCount <= 1) return result;
        }
        if (dataType == DataType.SmallTable) {
            return this.convertResultSetToSmallTableTD(rowCount, columnCount, outputToWriteTo, resultSet);
        }
        if (dataType == DataType.Float) throw new ComponentException("The result set contains " + rowCount + " rows and " + columnCount + " columns " + "and thus cannot be written into selected datatype " + dataType.getDisplayName() + FULL_STOP);
        if (dataType == DataType.Integer) throw new ComponentException("The result set contains " + rowCount + " rows and " + columnCount + " columns " + "and thus cannot be written into selected datatype " + dataType.getDisplayName() + FULL_STOP);
        if (dataType == DataType.ShortText) throw new ComponentException("The result set contains " + rowCount + " rows and " + columnCount + " columns " + "and thus cannot be written into selected datatype " + dataType.getDisplayName() + FULL_STOP);
        if (dataType != DataType.Boolean) throw new ComponentException("The output's datatype is " + dataType.getDisplayName() + " and is currently not supported for the component.");
        throw new ComponentException("The result set contains " + rowCount + " rows and " + columnCount + " columns " + "and thus cannot be written into selected datatype " + dataType.getDisplayName() + FULL_STOP);
    }

    private SmallTableTD convertResultSetToSmallTableTD(int rowCount, int columnCount, String outputToWriteTo, ResultSet resultSet) throws ComponentException {
        TypedDatumFactory tdFactory = typedDatumService.getFactory();
        SmallTableTD smallTableTD = tdFactory.createSmallTable(rowCount, columnCount);
        try {
            while (resultSet.next()) {
                int i = 1;
                while (i <= columnCount) {
                    int rowInTable = resultSet.getRow() - 1;
                    int colInTable = i - 1;
                    if (resultSet.getObject(i) instanceof String) {
                        smallTableTD.setTypedDatumForCell((TypedDatum)tdFactory.createShortText(resultSet.getString(i)), rowInTable, colInTable);
                    } else if (resultSet.getObject(i) instanceof Integer) {
                        smallTableTD.setTypedDatumForCell((TypedDatum)tdFactory.createInteger((long)resultSet.getInt(i)), rowInTable, colInTable);
                    } else if (resultSet.getObject(i) instanceof Long) {
                        smallTableTD.setTypedDatumForCell((TypedDatum)tdFactory.createInteger(resultSet.getLong(i)), rowInTable, colInTable);
                    } else if (resultSet.getObject(i) instanceof Float) {
                        smallTableTD.setTypedDatumForCell((TypedDatum)tdFactory.createFloat((double)resultSet.getFloat(i)), rowInTable, colInTable);
                    } else if (resultSet.getObject(i) instanceof Double) {
                        smallTableTD.setTypedDatumForCell((TypedDatum)tdFactory.createFloat(resultSet.getDouble(i)), rowInTable, colInTable);
                    } else if (resultSet.getObject(i) instanceof Boolean) {
                        smallTableTD.setTypedDatumForCell((TypedDatum)tdFactory.createBoolean(resultSet.getBoolean(i)), rowInTable, colInTable);
                    } else if (resultSet.getObject(i) == null) {
                        smallTableTD.setTypedDatumForCell((TypedDatum)tdFactory.createEmpty(), rowInTable, colInTable);
                    } else {
                        if (resultSet.getObject(i) instanceof BigDecimal) {
                            throw new ComponentException(String.valueOf(StringUtils.format((String)ERROR_FILLING_SMALL_TABLE, (Object[])new Object[]{outputToWriteTo})) + "Note that currently no internal data type represents 'big decimal' values.");
                        }
                        if (resultSet.getObject(i) instanceof BigInteger) {
                            throw new ComponentException(String.valueOf(StringUtils.format((String)ERROR_FILLING_SMALL_TABLE, (Object[])new Object[]{outputToWriteTo})) + "Note that currently no internal data type represents 'big integer' values.");
                        }
                        throw new ComponentException(String.valueOf(StringUtils.format((String)ERROR_FILLING_SMALL_TABLE, (Object[])new Object[]{outputToWriteTo})) + "The given data type '" + resultSet.getObject(i).getClass().getName() + "' is currently not supported.");
                    }
                    ++i;
                }
            }
        }
        catch (SQLException e) {
            throw new ComponentException("Failed to distribute result set. Database response: " + e.getMessage());
        }
        return smallTableTD;
    }

    protected void distributeResults(String outputToWriteTo, ResultSet resultSet) throws SQLException, ComponentException {
        TypedDatum convertedTypedDatum = this.convertResultSetToTypedDatum(resultSet, outputToWriteTo);
        if (convertedTypedDatum != null) {
            this.componentContext.writeOutput(outputToWriteTo, convertedTypedDatum);
        } else {
            this.componentContext.getLog().componentError("Failed to convert the database result set into to the given output " + outputToWriteTo + FULL_STOP);
        }
    }

    public void dispose() {
        this.closeConnection();
    }

    public void tearDown(Component.FinalComponentState state) {
        switch (state) {
            case FINISHED: {
                this.closeConnection();
            }
        }
        super.tearDown(state);
    }

    protected void closeConnection() {
        if (this.jdbcConnection != null) {
            try {
                if (!this.jdbcConnection.isClosed()) {
                    this.jdbcConnection.close();
                }
            }
            catch (SQLException e) {
                this.componentContext.getLog().componentError("Database connection could not be closed. " + e.getMessage());
            }
            this.jdbcConnection = null;
        }
    }
}

