/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.datamanagement.internal;

import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementUtil;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.datamanagement.DataManagementService;
import de.rcenvironment.core.datamanagement.commons.MetaDataSet;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.IOException;

public class ComponentDataManagementServiceImpl
implements ComponentDataManagementService {
    private TypedDatumFactory typedDatumFactory;
    private DataManagementService dataManagementService;

    public String createTaggedReferenceFromLocalFile(ComponentContext componentContext, File file, String filename) throws IOException {
        MetaDataSet mds = new MetaDataSet();
        ComponentDataManagementUtil.setComponentMetaData((MetaDataSet)mds, (ComponentContext)componentContext);
        if (filename != null) {
            String effectiveFilename = filename == "*ATTACH_AUTOMATIC_FILENAME*" ? file.getName() : filename;
            ComponentDataManagementUtil.setAssociatedFilename((MetaDataSet)mds, (String)effectiveFilename);
        }
        try {
            return this.dataManagementService.createReferenceFromLocalFile(file, mds, this.getStorageNetworkDestination(componentContext));
        }
        catch (CommunicationException | InterruptedException e) {
            throw new IOException(e);
        }
    }

    public String createTaggedReferenceFromString(ComponentContext componentContext, String stringValue) throws IOException {
        MetaDataSet mds = new MetaDataSet();
        ComponentDataManagementUtil.setComponentMetaData((MetaDataSet)mds, (ComponentContext)componentContext);
        try {
            return this.dataManagementService.createReferenceFromString(stringValue, mds, this.getStorageNetworkDestination(componentContext));
        }
        catch (CommunicationException | InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void copyReferenceToLocalFile(String reference, File targetFile, NetworkDestination nodeId) throws IOException {
        this.copyReferenceToLocalFile(reference, targetFile, nodeId, true);
    }

    public void copyReferenceToLocalFile(String reference, File targetFile, NetworkDestination nodeId, boolean decompress) throws IOException {
        try {
            this.dataManagementService.copyReferenceToLocalFile(reference, targetFile, nodeId);
        }
        catch (CommunicationException e) {
            throw new RuntimeException(String.valueOf(StringUtils.format((String)"Failed to copy data reference from remote node @%s to local file: ", (Object[])new Object[]{nodeId})) + e.getMessage(), e);
        }
    }

    public String retrieveStringFromReference(String reference, NetworkDestination nodeId) throws IOException {
        try {
            return this.dataManagementService.retrieveStringFromReference(reference, nodeId);
        }
        catch (CommunicationException e) {
            throw new RuntimeException(String.valueOf(StringUtils.format((String)"Failed to retrieve string from data reference from remote node @%s: ", (Object[])new Object[]{nodeId})) + e.getMessage(), e);
        }
    }

    public FileReferenceTD createFileReferenceTDFromLocalFile(ComponentContext componentContext, File file, String filename) throws IOException {
        String reference;
        if (!file.exists()) {
            throw new IOException("File doesn't exist: " + file.getAbsolutePath());
        }
        try {
            MetaDataSet mds = new MetaDataSet();
            ComponentDataManagementUtil.setComponentMetaData((MetaDataSet)mds, (ComponentContext)componentContext);
            reference = this.dataManagementService.createReferenceFromLocalFile(file, mds, this.getStorageNetworkDestination(componentContext));
        }
        catch (CommunicationException | InterruptedException e) {
            throw new IOException(e);
        }
        return this.typedDatumFactory.createFileReference(reference, filename);
    }

    public DirectoryReferenceTD createDirectoryReferenceTDFromLocalDirectory(ComponentContext componentContext, File dir, String dirname) throws IOException {
        String reference;
        if (!dir.exists()) {
            throw new IOException("Directory doesn't exist: " + dir.getAbsolutePath());
        }
        if (!dir.isDirectory()) {
            throw new IOException("Path doesn't refer to directory: " + dir.getAbsolutePath());
        }
        try {
            MetaDataSet mds = new MetaDataSet();
            ComponentDataManagementUtil.setComponentMetaData((MetaDataSet)mds, (ComponentContext)componentContext);
            reference = this.dataManagementService.createReferenceFromLocalDirectory(dir, mds, this.getStorageNetworkDestination(componentContext));
        }
        catch (CommunicationException | IOException | InterruptedException e) {
            throw new IOException(e);
        }
        return this.typedDatumFactory.createDirectoryReference(reference, dirname);
    }

    public void copyFileReferenceTDToLocalFile(ComponentContext componentContext, FileReferenceTD fileReference, File targetFile) throws IOException {
        this.copyReferenceToLocalFile(fileReference.getFileReference(), targetFile, this.getStorageNetworkDestination(componentContext));
    }

    public void copyReferenceTDToLocalCompressedFile(ComponentContext componentContext, TypedDatum fileReference, File targetFile) throws IOException {
        if (fileReference instanceof FileReferenceTD) {
            this.copyReferenceToLocalFile(((FileReferenceTD)fileReference).getFileReference(), targetFile, this.getStorageNetworkDestination(componentContext), false);
        } else if (fileReference instanceof DirectoryReferenceTD) {
            this.copyReferenceToLocalFile(((DirectoryReferenceTD)fileReference).getDirectoryReference(), targetFile, this.getStorageNetworkDestination(componentContext), false);
        }
    }

    public void copyDirectoryReferenceTDToLocalDirectory(ComponentContext componentContext, DirectoryReferenceTD dirReference, File targetDir) throws IOException {
        try {
            this.dataManagementService.copyReferenceToLocalDirectory(dirReference.getDirectoryReference(), targetDir, this.getStorageNetworkDestination(componentContext));
        }
        catch (CommunicationException e) {
            throw new RuntimeException(String.valueOf(StringUtils.format((String)"Failed to copy directory reference from remote node @%s to local directory: ", (Object[])new Object[]{componentContext.getNodeId()})) + e.getMessage(), e);
        }
    }

    public void copyDirectoryReferenceTDToLocalDirectory(DirectoryReferenceTD dirReference, File targetDir, NetworkDestination node) throws IOException {
        try {
            this.dataManagementService.copyReferenceToLocalDirectory(dirReference.getDirectoryReference(), targetDir, node);
        }
        catch (CommunicationException e) {
            throw new RuntimeException(String.valueOf(StringUtils.format((String)"Failed to copy directory reference from remote node @%s to local directory: ", (Object[])new Object[]{node})) + e.getMessage(), e);
        }
    }

    public FileReferenceTD createFileReferenceTDFromLocalCompressedFile(ComponentContext componentContext, File file, String filename) throws IOException {
        String reference;
        if (!file.exists()) {
            throw new IOException("File doesn't exist: " + file.getAbsolutePath());
        }
        try {
            MetaDataSet mds = new MetaDataSet();
            ComponentDataManagementUtil.setComponentMetaData((MetaDataSet)mds, (ComponentContext)componentContext);
            reference = this.dataManagementService.createReferenceFromLocalFile(file, mds, this.getStorageNetworkDestination(componentContext), true);
        }
        catch (CommunicationException | InterruptedException e) {
            throw new IOException(e);
        }
        return this.typedDatumFactory.createFileReference(reference, filename);
    }

    public DirectoryReferenceTD createDirectoryReferenceTDFromLocalCompressedFile(ComponentContext componentContext, File dir, String dirname) throws IOException {
        String reference;
        if (!dir.exists()) {
            throw new IOException("Directory doesn't exist: " + dir.getAbsolutePath());
        }
        try {
            MetaDataSet mds = new MetaDataSet();
            ComponentDataManagementUtil.setComponentMetaData((MetaDataSet)mds, (ComponentContext)componentContext);
            reference = this.dataManagementService.createReferenceFromLocalFile(dir, mds, this.getStorageNetworkDestination(componentContext), true);
        }
        catch (CommunicationException | InterruptedException e) {
            throw new IOException(e);
        }
        return this.typedDatumFactory.createDirectoryReference(reference, dirname);
    }

    protected void bindTypedDatumService(TypedDatumService typedDatumService) {
        this.typedDatumFactory = typedDatumService.getFactory();
    }

    protected void bindDataManagementService(DataManagementService newDataManagementService) {
        this.dataManagementService = newDataManagementService;
    }

    private NetworkDestination getStorageNetworkDestination(ComponentContext componentContext) {
        return componentContext.getStorageNetworkDestination();
    }
}

