/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.workflow.execution.function.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.workflow.execution.SynchronousWorkflowExecutionService;
import de.rcenvironment.core.workflow.execution.function.WorkflowFunction;
import de.rcenvironment.core.workflow.execution.function.WorkflowFunctionService;
import de.rcenvironment.core.workflow.execution.function.internal.FileUtils;
import de.rcenvironment.core.workflow.execution.function.internal.WorkflowFunctionImpl;
import java.io.File;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class WorkflowFunctionServiceImpl
implements WorkflowFunctionService {
    private ComponentDataManagementService componentDataManagementService;
    private PlatformService platformService;
    private TypedDatumService typedDatumService;
    private SynchronousWorkflowExecutionService workflowExecutionService;
    private TempFileService tempFileService;
    private Supplier<ObjectWriter> writerSupplier = () -> new ObjectMapper().writer();
    private BiFunction<File, String, File> fileCreator = (parent, child) -> new File((File)parent, (String)child);
    private Supplier<ObjectMapper> mapperSupplier = () -> new ObjectMapper();

    @Override
    public WorkflowFunction.Builder createBuilder() {
        FileUtils fileUtils = new FileUtils();
        fileUtils.setCreateObjectWriter(this.writerSupplier);
        fileUtils.setCreateObjectMapper(this.mapperSupplier);
        fileUtils.setCreateFile(this.fileCreator);
        if (this.tempFileService != null) {
            fileUtils.setTempFileService(this.tempFileService);
        } else {
            fileUtils.setTempFileService(TempFileServiceAccess.getInstance());
        }
        WorkflowFunctionImpl.Builder builder = new WorkflowFunctionImpl.Builder().bindComponentDataManagementService(this.componentDataManagementService).bindPlatformService(this.platformService).bindTypedDatumSerializer(this.typedDatumService.getSerializer()).bindWorkflowExecutionService(this.workflowExecutionService).bindFileUtils(fileUtils);
        return builder;
    }

    @Reference
    public void bindComponentDataManagementService(ComponentDataManagementService service) {
        this.componentDataManagementService = service;
    }

    @Reference
    public void bindPlatformService(PlatformService service) {
        this.platformService = service;
    }

    @Reference
    public void bindTypedDatumService(TypedDatumService service) {
        this.typedDatumService = service;
    }

    @Reference
    public void bindSynchronousWorkflowExecutionService(SynchronousWorkflowExecutionService service) {
        this.workflowExecutionService = service;
    }

    public void bindTempFileService(TempFileService tempFileServiceParam) {
        this.tempFileService = tempFileServiceParam;
    }

    public void bindObjectWriterSupplier(Supplier<ObjectWriter> writerSupplierParam) {
        this.writerSupplier = writerSupplierParam;
    }

    public void bindFileCreator(BiFunction<File, String, File> fileCreatorParam) {
        this.fileCreator = fileCreatorParam;
    }

    public void bindObjectMapperSupplier(Supplier<ObjectMapper> objectMapper) {
        this.mapperSupplier = objectMapper;
    }
}

