/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.workflow.execution.function.internal;

import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.component.api.ComponentConstants;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInstallationBuilder;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.api.ComponentInterfaceBuilder;
import de.rcenvironment.core.component.model.api.ComponentRevisionBuilder;
import de.rcenvironment.core.component.model.configuration.api.ComponentConfigurationModelFactory;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDefinition;
import de.rcenvironment.core.component.model.endpoint.api.ComponentEndpointModelFactory;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinitionsProvider;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.workflow.execution.function.OutputAdapterComponent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;

class OutputAdapterNodeBuilder {
    private LogicalNodeId hostId;
    private String outputDirectoryAbsolutePath;
    private Map<String, DataType> externalOutputs = new HashMap<String, DataType>();

    OutputAdapterNodeBuilder() {
    }

    public OutputAdapterNodeBuilder setHostId(LogicalNodeId hostIdParam) {
        this.hostId = hostIdParam;
        return this;
    }

    public OutputAdapterNodeBuilder setOutputDirectory(String outputDirectoryAbsolutePathParam) {
        this.outputDirectoryAbsolutePath = outputDirectoryAbsolutePathParam;
        return this;
    }

    public OutputAdapterNodeBuilder addExternalOutputName(String externalInputName, DataType externalInputType) {
        this.externalOutputs.put(externalInputName, externalInputType);
        return this;
    }

    public WorkflowNode build() {
        Objects.requireNonNull(this.hostId);
        Objects.requireNonNull(this.outputDirectoryAbsolutePath);
        HashMap<String, String> readOnlyConfiguration = new HashMap<String, String>();
        readOnlyConfiguration.put("toolName", "outputAdapter");
        readOnlyConfiguration.put("version", "1.0");
        readOnlyConfiguration.put("hostId", this.hostId.toString());
        readOnlyConfiguration.put("hostName", "awesomeHostName");
        readOnlyConfiguration.put("isWorkflow", Boolean.TRUE.toString());
        readOnlyConfiguration.put("outputFolder", this.outputDirectoryAbsolutePath);
        ConfigurationDefinition configuration = ComponentConfigurationModelFactory.createConfigurationDefinition(new LinkedList(), new LinkedList(), new LinkedList(), readOnlyConfiguration);
        HashSet<EndpointDefinition> outputAdapterInputs = new HashSet<EndpointDefinition>();
        for (Map.Entry<String, DataType> externalOutput : this.externalOutputs.entrySet()) {
            EndpointDefinition singleEndpointDefinition = EndpointDefinition.inputBuilder().name(externalOutput.getKey()).allowedDatatype(externalOutput.getValue()).defaultDatatype(externalOutput.getValue()).inputExecutionConstraints(Arrays.asList(EndpointDefinition.InputExecutionContraint.Required)).defaultInputExecutionConstraint(EndpointDefinition.InputExecutionContraint.Required).inputHandlings(Arrays.asList(EndpointDefinition.InputDatumHandling.Single)).defaultInputHandling(EndpointDefinition.InputDatumHandling.Single).build();
            outputAdapterInputs.add(singleEndpointDefinition);
        }
        EndpointDefinitionsProvider inputAdapterProvider = ComponentEndpointModelFactory.createEndpointDefinitionsProvider(outputAdapterInputs);
        HashSet outputAdapterOutputs = new HashSet();
        EndpointDefinitionsProvider outputAdapterProvider = ComponentEndpointModelFactory.createEndpointDefinitionsProvider(outputAdapterOutputs);
        ComponentInterface componentInterface = new ComponentInterfaceBuilder().setIdentifier("OutputAdapter").setIcon16(new byte[0]).setIcon32(new byte[0]).setGroupName("Dummy Tools").setVersion("0.0").setInputDefinitionsProvider(inputAdapterProvider).setOutputDefinitionsProvider(outputAdapterProvider).setConfigurationDefinition(configuration).setConfigurationExtensionDefinitions(new HashSet()).setColor(ComponentConstants.COMPONENT_COLOR_STANDARD).setShape(ComponentConstants.COMPONENT_SHAPE_STANDARD).setSize(ComponentConstants.COMPONENT_SIZE_STANDARD).setDisplayName("Output Adapter").build();
        ComponentInstallation ci = new ComponentInstallationBuilder().setComponentRevision(new ComponentRevisionBuilder().setComponentInterface(componentInterface).setClassName(OutputAdapterComponent.class.getCanonicalName()).build()).setNodeId(this.hostId).setInstallationId(componentInterface.getIdentifierAndVersion()).build();
        ComponentDescription componentDescription = new ComponentDescription(ci);
        WorkflowNode nodeToAdd = new WorkflowNode(componentDescription);
        nodeToAdd.setEnabled(true);
        nodeToAdd.setChecked(false);
        nodeToAdd.setImitiationModeActive(false);
        nodeToAdd.setInit(true);
        nodeToAdd.setName("Output Adapter");
        nodeToAdd.setLocation(200, 0);
        return nodeToAdd;
    }
}

