/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.internal;

import de.rcenvironment.core.component.integration.ConfigurationMap;
import de.rcenvironment.core.component.integration.internal.FileAccessService;
import de.rcenvironment.core.component.integration.internal.HashingService;
import de.rcenvironment.core.component.integration.internal.ImageService;
import de.rcenvironment.core.component.integration.internal.ToolIntegrationServiceImpl;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={IconHelper.class})
public final class IconHelper {
    private static final Log LOGGER = LogFactory.getLog(IconHelper.class);
    private FileAccessService fileAccess;
    private HashingService hashingService;
    private ImageService imageService;

    public void prescaleAndCopyIcon(ConfigurationMap configurationMap, File toolConfigFile) {
        File destination;
        boolean sourceIconCanBeCopied;
        String md5Hash;
        BufferedImage iconImage;
        boolean toolIconPathSpecified;
        String toolIconPath = configurationMap.getIconPath();
        boolean bl = toolIconPathSpecified = toolIconPath != null && !toolIconPath.isEmpty();
        if (!toolIconPathSpecified) {
            return;
        }
        File icon = this.getIconFile(toolIconPath, toolConfigFile);
        try {
            iconImage = this.imageService.readImage(icon);
            byte[] iconContent = this.fileAccess.readToByteArray(icon);
            md5Hash = this.hashingService.md5Hex(iconContent);
        }
        catch (IOException e) {
            LOGGER.debug((Object)"IOException during reading tool icon", (Throwable)e);
            return;
        }
        Boolean uploadIconSelection = configurationMap.shouldUploadIcon();
        boolean sourceIconShallBeCopied = uploadIconSelection != null && uploadIconSelection != false;
        boolean bl2 = sourceIconCanBeCopied = icon.exists() && icon.isFile() && icon.isAbsolute();
        if (sourceIconShallBeCopied && sourceIconCanBeCopied && !(destination = this.fileAccess.createFile(toolConfigFile, icon.getName())).equals(icon)) {
            try {
                this.fileAccess.copyFile(icon, destination);
                configurationMap.setIconPath(icon.getName());
            }
            catch (IOException e) {
                LOGGER.warn((Object)"Could not copy icon to tool directory: ", (Throwable)e);
            }
            configurationMap.doNotUploadIcon();
        }
        if (iconImage != null) {
            ToolIntegrationServiceImpl.IconSize[] iconSizeArray = ToolIntegrationServiceImpl.IconSize.values();
            int n = iconSizeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ToolIntegrationServiceImpl.IconSize iconSize = iconSizeArray[n2];
                this.tryPrescaleAndStoreIcon(iconImage, iconSize, toolConfigFile);
                ++n2;
            }
        }
        configurationMap.setIconHash(md5Hash);
        configurationMap.setIconModificationDate(icon.lastModified());
    }

    private boolean tryPrescaleAndStoreIcon(BufferedImage iconImage, ToolIntegrationServiceImpl.IconSize iconSize, File toolConfigFile) {
        BufferedImage resizedIcon = this.imageService.resize(iconImage, iconSize.getSize());
        String format = iconSize.getPath().substring(iconSize.getPath().lastIndexOf(46) + 1);
        File destination = this.fileAccess.createFile(toolConfigFile, iconSize.getPath());
        try {
            this.imageService.write(resizedIcon, format, destination);
            return true;
        }
        catch (IOException iOException) {
            String errorMessage = String.format("Unable to write resized tool icon to file %s.", destination.toString());
            LOGGER.debug((Object)errorMessage);
            return false;
        }
    }

    public byte[] getIcon(ToolIntegrationServiceImpl.IconSize iconSize, ConfigurationMap configurationMap, File toolDirFile) {
        byte[] prescaledIcon = this.tryGetPrescaledIcon(iconSize, configurationMap, toolDirFile);
        if (prescaledIcon != null) {
            return prescaledIcon;
        }
        byte[] livescaledIcon = this.getLivescaledIcon(iconSize.getSize(), configurationMap, toolDirFile);
        if (livescaledIcon != null) {
            return livescaledIcon;
        }
        byte[] defaultIcon = this.getDefaultIcon(iconSize.getSize());
        if (defaultIcon != null) {
            return defaultIcon;
        }
        return null;
    }

    private byte[] tryGetPrescaledIcon(ToolIntegrationServiceImpl.IconSize iconSize, ConfigurationMap configurationMap, File toolDirFile) {
        String iconPath = configurationMap.getIconPath();
        if (iconPath == null || iconPath.isEmpty()) {
            return null;
        }
        File icon = this.getIconFile(iconPath, toolDirFile);
        Long storedModifiedDate = configurationMap.getIconModificationDate();
        if (storedModifiedDate == null || !storedModifiedDate.equals(icon.lastModified())) {
            return null;
        }
        String actualMd5Hash = this.tryComputeMd5Hash(icon);
        if (actualMd5Hash == null) {
            return null;
        }
        String storedMd5Hash = configurationMap.getIconHash();
        if (actualMd5Hash.equals(storedMd5Hash)) {
            return this.readPrescaledIconFile(toolDirFile, iconSize.getPath());
        }
        return null;
    }

    private String tryComputeMd5Hash(File file) {
        try {
            byte[] iconContent = this.fileAccess.readToByteArray(file);
            return this.hashingService.md5Hex(iconContent);
        }
        catch (IOException iOException) {
            LOGGER.warn((Object)"Could not read tool icon, using default icon instead");
            return null;
        }
    }

    private byte[] readPrescaledIconFile(File toolDirFile, String path) {
        File iconFile = this.fileAccess.createFile(toolDirFile, path);
        if (iconFile.exists()) {
            return this.tryReadToByteArray(iconFile);
        }
        return null;
    }

    private byte[] getLivescaledIcon(int size, ConfigurationMap configurationMap, File toolDirFile) {
        File tempFile;
        boolean iconAvailable;
        String iconPath = configurationMap.getIconPath();
        if (iconPath == null || iconPath.isEmpty()) {
            return null;
        }
        File sourceIcon = this.getIconFile(iconPath, toolDirFile);
        boolean bl = iconAvailable = sourceIcon.exists() && sourceIcon.isFile();
        if (!iconAvailable) {
            return null;
        }
        try {
            tempFile = TempFileServiceAccess.getInstance().createTempFileFromPattern("icon_" + size + "*.png");
        }
        catch (IOException iOException) {
            LOGGER.debug((Object)"Could not create temporary file for rescaling icon, using default icon");
            return null;
        }
        BufferedImage image = this.tryReadToImage(sourceIcon);
        if (image == null) {
            LOGGER.debug((Object)"Could not read tool icon, using default icon");
            return null;
        }
        try {
            BufferedImage bi = this.imageService.resize(image, size);
            if (bi != null && tempFile != null) {
                this.imageService.write(bi, "PNG", tempFile);
                byte[] iconArray = this.fileAccess.readToByteArray(tempFile);
                TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(tempFile);
                return iconArray;
            }
            return null;
        }
        catch (IOException iOException) {
            LOGGER.debug((Object)"Could not resize tool icon, using default icon");
            return null;
        }
    }

    private BufferedImage tryReadToImage(File iconFile) {
        try {
            return this.imageService.readImage(iconFile);
        }
        catch (IOException iOException) {
            LOGGER.debug((Object)"IOException during reading tool icon, using default icon");
            return null;
        }
    }

    private byte[] tryReadToByteArray(File iconFile) {
        try {
            return this.fileAccess.readToByteArray(iconFile);
        }
        catch (IOException e) {
            String message = String.format("Error when reading icon at %s: ", iconFile.getAbsolutePath());
            LOGGER.warn((Object)message, (Throwable)e);
            return null;
        }
    }

    private File getIconFile(String iconPath, File toolDirFile) {
        boolean iconPathIsAbsolute = this.fileAccess.createFile(iconPath).isAbsolute();
        if (iconPathIsAbsolute) {
            return this.fileAccess.createFile(iconPath);
        }
        return this.fileAccess.createFile(toolDirFile, iconPath);
    }

    private byte[] getDefaultIcon(int iconSize) {
        String iconPath = String.format("/resources/icons/tool%s.png", iconSize);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inputStream = ToolIntegrationServiceImpl.class.getResourceAsStream(iconPath);){
                return this.fileAccess.toByteArray(inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            String warningMessage = String.format("Could not load default icon of size %sx%s, expected at %s: ", iconSize, iconSize, iconPath);
            LOGGER.warn((Object)warningMessage, (Throwable)e);
            return null;
        }
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    void bindFileAccessService(FileAccessService newInstance) {
        this.fileAccess = newInstance;
    }

    void unbindFileAccessService(FileAccessService oldInstance) {
        this.fileAccess = null;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    void bindHashingService(HashingService newInstance) {
        this.hashingService = newInstance;
    }

    void unbindHashingService(HashingService oldInstance) {
        this.hashingService = null;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    void bindImageService(ImageService newInstance) {
        this.imageService = newInstance;
    }

    void unbindImageService(ImageService oldInstance) {
        this.imageService = null;
    }
}

