/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.common.configuration;

import de.rcenvironment.core.gui.utils.common.configuration.PropertyDescriptorFactory;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;

public abstract class BeanPropertySourceAdapter
implements IPropertySource2 {
    private final Object bean;
    private final BeanInfo beanInfo;
    private final Map<String, PropertyDescriptor> beanDescriptors = new HashMap<String, PropertyDescriptor>();
    private final Map<String, IPropertyDescriptor> propertyDescriptors = new HashMap<String, IPropertyDescriptor>();
    private final Map<Object, Object> defaultValues = new HashMap<Object, Object>();
    private final Map<Object, Boolean> sets = new HashMap<Object, Boolean>();
    private IPropertyDescriptor[] propertyDescriptorsArray;

    public BeanPropertySourceAdapter(Object source) {
        this.bean = source;
        try {
            this.beanInfo = Introspector.getBeanInfo(source.getClass());
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        this.parse();
    }

    protected BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    private void parse() {
        PropertyDescriptor[] propertyDescriptorArray = this.beanInfo.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> propertyType;
            IPropertyDescriptor propertyDescriptor;
            PropertyDescriptor descriptor = propertyDescriptorArray[n2];
            String name = descriptor.getName();
            if (this.isProperty(descriptor) && (propertyDescriptor = this.createPropertyDescriptor(propertyType = descriptor.getPropertyType(), name, descriptor.getDisplayName())) != null) {
                this.addProperty(descriptor, propertyDescriptor);
            }
            ++n2;
        }
        this.updatePropertyDescriptors();
    }

    protected IPropertyDescriptor createPropertyDescriptor(Class<?> propertyType, String name, String displayName) {
        return PropertyDescriptorFactory.createPropertyDescriptor(propertyType, name, displayName);
    }

    protected boolean isProperty(PropertyDescriptor descriptor) {
        return !"class".equals(descriptor.getName()) && descriptor.getPropertyType() != null;
    }

    private void addProperty(PropertyDescriptor descriptor, IPropertyDescriptor propertyDescriptor) {
        String name = descriptor.getName();
        this.addDescriptor(descriptor);
        this.propertyDescriptors.put(name, propertyDescriptor);
        this.updatePropertyDescriptors();
    }

    protected void removeProperty(PropertyDescriptor descriptor) {
        String name = descriptor.getName();
        this.removeDescriptor(descriptor);
        this.propertyDescriptors.remove(name);
        this.updatePropertyDescriptors();
    }

    private void updatePropertyDescriptors() {
        this.propertyDescriptorsArray = this.propertyDescriptors.values().toArray(new IPropertyDescriptor[0]);
    }

    protected Object getBean() {
        return this.bean;
    }

    public Object getEditableValue() {
        return this.bean.toString();
    }

    protected boolean isManaged(Object id) {
        String key = id.toString();
        return this.hasDescriptor(key);
    }

    private boolean hasDescriptor(Object id) {
        String key = id.toString();
        return this.beanDescriptors.containsKey(key);
    }

    private PropertyDescriptor getDescriptor(Object id) {
        String key = id.toString();
        return this.beanDescriptors.get(key);
    }

    private void addDescriptor(PropertyDescriptor descriptor) {
        String name = descriptor.getName();
        this.beanDescriptors.put(name, descriptor);
    }

    private void removeDescriptor(PropertyDescriptor descriptor) {
        String name = descriptor.getName();
        this.beanDescriptors.remove(name);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptorsArray;
    }

    protected IPropertyDescriptor getPropertyDescriptor(String propertyName) {
        return this.propertyDescriptors.get(propertyName);
    }

    public Object getPropertyValue(Object id) {
        String key = id.toString();
        PropertyDescriptor descriptor = this.getDescriptor(key);
        Object result = null;
        if (descriptor != null) {
            Object value;
            result = value = this.getValue(descriptor);
        }
        return result;
    }

    private Object getValue(PropertyDescriptor descriptor) {
        try {
            return descriptor.getReadMethod().invoke(this.bean, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isPropertyResettable(Object id) {
        return true;
    }

    public void resetPropertyValue(Object id) {
        if (this.isPropertySet(id)) {
            this.setPropertyValue(id, this.defaultValues.get(id));
            this.defaultValues.remove(id);
            this.sets.put(id, false);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        String key = id.toString();
        PropertyDescriptor descriptor = this.getDescriptor(key);
        if (descriptor != null) {
            Class<?> propertyType = descriptor.getPropertyType();
            Object newValue = value;
            if (value != null) {
                if (String.class.equals(propertyType)) {
                    newValue = value.toString();
                } else if (Number.class.isAssignableFrom(propertyType)) {
                    newValue = this.createValue(propertyType, value.toString());
                } else if (Boolean.class.equals(propertyType) || Boolean.TYPE.equals(propertyType)) {
                    if (value instanceof Boolean) {
                        newValue = (Boolean)value;
                    }
                } else if (propertyType.isPrimitive()) {
                    newValue = this.createValue(propertyType, value.toString());
                }
            }
            this.setValue(descriptor, newValue);
            if (!this.isPropertySet(id)) {
                this.defaultValues.put(id, this.getPropertyValue(id));
                this.sets.put(id, true);
            }
        }
    }

    private Object createValue(Class<?> type, Object ... args) {
        Object value;
        Class[] argsTypes = new Class[args.length];
        int index = 0;
        while (index < args.length) {
            argsTypes[index] = args[index].getClass();
            ++index;
        }
        try {
            value = type.getConstructor(argsTypes).newInstance(args);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return value;
    }

    private void setValue(PropertyDescriptor descriptor, Object value) {
        Method setter = descriptor.getWriteMethod();
        try {
            setter.invoke(this.bean, value);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isPropertySet(Object id) {
        return this.sets.get(id) != null && this.sets.get(id) != false;
    }
}

