/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.gui.view;

import de.rcenvironment.components.optimizer.common.Dimension;
import de.rcenvironment.components.optimizer.common.Measure;
import de.rcenvironment.components.optimizer.common.OptimizerResultSet;
import de.rcenvironment.components.optimizer.gui.properties.Messages;
import de.rcenvironment.components.optimizer.gui.view.ChartConfiguration;
import de.rcenvironment.components.optimizer.gui.view.OptimizerDatastore;
import de.rcenvironment.components.optimizer.gui.view.PipedPropertyChangeListener;
import de.rcenvironment.core.gui.utils.common.configuration.BeanConfigurationDialog;
import de.rcenvironment.core.gui.utils.common.configuration.BeanConfigurationSourceAdapter;
import de.rcenvironment.core.gui.utils.common.configuration.ConfigurationViewer;
import de.rcenvironment.core.gui.utils.common.configuration.ConfigurationViewerContentProvider;
import de.rcenvironment.core.gui.utils.common.configuration.ConfigurationViewerLabelProvider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.nebula.visualization.xygraph.dataprovider.AbstractDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.ISample;
import org.eclipse.nebula.visualization.xygraph.dataprovider.Sample;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Tree;

public class ChartConfigurationComposite
extends Composite
implements ISelectionProvider {
    private static final int WEIGHT = 100;
    private static final int WEIGHT_CHART = 66;
    private final ChartConfiguration configuration = new ChartConfiguration();
    private final Set<DataProvider> dataProviders = new HashSet<DataProvider>();
    private XYGraph graph;
    private Canvas chartCanvas;
    private LightweightSystem lightweightSystem;
    private OptimizerDatastore studyDatastore;
    private ConfigurationViewer treeViewer;
    private final ConfigurationViewerContentProvider contentProvider = new ConfigurationViewerContentProvider();
    private Tree tree;
    private final List<Trace> traces = new LinkedList<Trace>();
    private final List<ISelectionChangedListener> selectionChangedListeners = new LinkedList<ISelectionChangedListener>();
    private ISelection selection;

    public ChartConfigurationComposite(Composite parent, int style) {
        super(parent, style);
        BeanConfigurationSourceAdapter.initialize();
    }

    public void createControls() {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginBottom = 5;
        this.setLayout((Layout)layout);
        SashForm sash = new SashForm((Composite)this, 256);
        GridData layoutData = new GridData(1808);
        sash.setLayoutData((Object)layoutData);
        this.treeViewer = new ConfigurationViewer((Composite)sash);
        final RemoveTraceAction removeTraceAction = new RemoveTraceAction();
        this.treeViewer.addContextMenuItem((IAction)removeTraceAction);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection newSelection = event.getSelection();
                if (newSelection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)newSelection;
                    Object element = structuredSelection.getFirstElement();
                    if (element instanceof ChartConfiguration.Trace) {
                        ChartConfiguration.Trace trace = (ChartConfiguration.Trace)element;
                        removeTraceAction.setTrace(trace);
                        removeTraceAction.setEnabled(true);
                        removeTraceAction.setVisible(true);
                    } else {
                        removeTraceAction.setTrace(null);
                        removeTraceAction.setEnabled(false);
                        removeTraceAction.setVisible(false);
                    }
                }
            }
        });
        this.tree = this.treeViewer.getTree();
        this.treeViewer.setAutoExpandLevel(2);
        this.chartCanvas = new Canvas((Composite)sash, 0);
        this.lightweightSystem = new LightweightSystem(this.chartCanvas);
        sash.setWeights(new int[]{34, 66});
        Button addTraceButton = new Button((Composite)this, 0);
        addTraceButton.setText(Messages.addTraceButtonLabel);
        addTraceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final BeanConfigurationDialog dialog = new BeanConfigurationDialog(Display.getCurrent().getActiveShell());
                final ChartConfiguration.Trace trace = new ChartConfiguration.Trace(ChartConfigurationComposite.this.configuration);
                dialog.setObject((Object)trace);
                dialog.create();
                trace.addPropertyChangeListener("name", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        try {
                            dialog.getShell().setText(trace.toString());
                        }
                        catch (RuntimeException runtimeException) {
                        }
                    }
                });
                if (dialog.open() == 0) {
                    if (trace.getXAxis() != null && trace.getYAxis() != null) {
                        ChartConfigurationComposite.this.configuration.addTrace(trace);
                    } else {
                        MessageBox errorDialog = new MessageBox(Display.getCurrent().getActiveShell(), 33);
                        errorDialog.setText(Messages.noDataErrorTitle);
                        errorDialog.setMessage(Messages.noDataError);
                        errorDialog.open();
                    }
                }
            }
        });
    }

    public void dispose() {
        for (DataProvider dataProvider : this.dataProviders) {
            try {
                dataProvider.close();
            }
            catch (RuntimeException runtimeException) {
            }
        }
        this.dataProviders.clear();
        this.contentProvider.removeViewer((StructuredViewer)this.treeViewer);
    }

    public void setStudyDatastore(OptimizerDatastore studyDatastore) {
        if (this.studyDatastore == studyDatastore) {
            return;
        }
        if (this.studyDatastore == null) {
            this.studyDatastore = studyDatastore;
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationViewerLabelProvider());
            this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
            this.contentProvider.addViewer((StructuredViewer)this.treeViewer);
            this.initializeConfiguration();
            this.treeViewer.setInput((Object)this.configuration);
        }
    }

    private void initializeConfiguration() {
        this.configuration.setTitle(this.studyDatastore.getTitle());
        for (Dimension dimension : this.studyDatastore.getStructure().getDimensions()) {
            ChartConfiguration.XAxis xAxis = new ChartConfiguration.XAxis();
            xAxis.setTitle(dimension.getName());
            xAxis.setAutoScale(true);
            this.configuration.addXAxis(xAxis);
        }
        for (Measure measure : this.studyDatastore.getStructure().getMeasures()) {
            ChartConfiguration.YAxis yAxis = new ChartConfiguration.YAxis();
            yAxis.setTitle(measure.getName());
            yAxis.setAutoScale(true);
            this.configuration.addYAxis(yAxis);
        }
        this.updateGraph();
        this.setSelection((ISelection)new StructuredSelection((Object)this.configuration));
    }

    private void updateGraph() {
        this.graph = new XYGraph();
        this.configuration.addPropertyChangeListener(new PipedPropertyChangeListener(this.graph));
        this.graph.setTitle(this.configuration.getTitle());
        this.graph.setShowTitle(this.configuration.getShowTitle());
        this.graph.setShowLegend(this.configuration.isShowLegend());
        this.createXAxes();
        this.createYAxes();
        this.createTraces();
        this.configuration.addPropertyChangeListener("traces", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ChartConfigurationComposite.this.createTraces();
                ChartConfigurationComposite.this.chartCanvas.update();
            }
        });
        this.lightweightSystem.setContents((IFigure)this.graph);
    }

    private void createXAxes() {
        boolean first = true;
        ChartConfiguration.XAxis[] xAxisArray = this.configuration.getXAxes();
        int n = xAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            Axis axis;
            ChartConfiguration.XAxis xAxis = xAxisArray[n2];
            if (first) {
                first = false;
                axis = this.graph.primaryXAxis;
                axis.setTitle(xAxis.getTitle());
                axis.setYAxis(false);
            } else {
                axis = new Axis(xAxis.getTitle(), false);
                this.graph.addAxis(axis);
            }
            PipedPropertyChangeListener propertyChangeListener = new PipedPropertyChangeListener(axis);
            propertyChangeListener.addGetterNameMapping("logScale", "logScaleEnabled");
            xAxis.addPropertyChangeListener(propertyChangeListener);
            axis.setAutoFormat(xAxis.isAutoFormat());
            axis.setAutoScale(xAxis.isAutoScale());
            ++n2;
        }
    }

    private void createYAxes() {
        boolean first = true;
        ChartConfiguration.YAxis[] yAxisArray = this.configuration.getYAxes();
        int n = yAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            Axis axis;
            ChartConfiguration.YAxis yAxis = yAxisArray[n2];
            if (first) {
                first = false;
                axis = this.graph.primaryYAxis;
                axis.setTitle(yAxis.getTitle());
                axis.setYAxis(true);
            } else {
                axis = new Axis(yAxis.getTitle(), true);
                this.graph.addAxis(axis);
            }
            PipedPropertyChangeListener propertyChangeListener = new PipedPropertyChangeListener(axis);
            propertyChangeListener.addGetterNameMapping("logScale", "logScaleEnabled");
            yAxis.addPropertyChangeListener(propertyChangeListener);
            axis.setAutoFormat(yAxis.isAutoFormat());
            axis.setAutoScale(yAxis.isAutoScale());
            ++n2;
        }
    }

    private void createTraces() {
        for (Trace trace : this.traces) {
            this.graph.removeTrace(trace);
        }
        PropertyChangeListener axisListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ChartConfigurationComposite.this.createTraces();
            }
        };
        ChartConfiguration.Trace[] traceArray = this.configuration.getTraces();
        int n = traceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChartConfiguration.Trace configurationTrace = traceArray[n2];
            configurationTrace.addPropertyChangeListener("xAxis", axisListener);
            configurationTrace.addPropertyChangeListener("yAxis", axisListener);
            Dimension dimension = this.studyDatastore.getStructure().getDimension(configurationTrace.getXAxis().getTitle());
            Measure measure = this.studyDatastore.getStructure().getMeasure(configurationTrace.getYAxis().getTitle());
            DataProvider dataProvider = new DataProvider(dimension, measure);
            this.dataProviders.add(dataProvider);
            dataProvider.initialize();
            Trace graphTrace = new Trace(configurationTrace.getName(), this.getAxis(false, configurationTrace.getXAxis().getTitle()), this.getAxis(true, configurationTrace.getYAxis().getTitle()), (IDataProvider)dataProvider);
            PipedPropertyChangeListener propertyChangeListener = new PipedPropertyChangeListener(graphTrace);
            propertyChangeListener.addNameMapping("type", "traceType");
            propertyChangeListener.addNameMapping("color", "traceColor");
            propertyChangeListener.addConverterMapping("color", new PipedPropertyChangeListener.AbstractConverter(){

                @Override
                public Object convert(Object object) {
                    RGB rgb = (RGB)object;
                    Color swtColor = new Color((Device)Display.getDefault(), rgb);
                    return swtColor;
                }
            });
            configurationTrace.addPropertyChangeListener(propertyChangeListener);
            Trace.TraceType traceType = configurationTrace.getType();
            configurationTrace.setType(traceType);
            graphTrace.setTraceType(traceType);
            RGB color = configurationTrace.getColor();
            if (color != null) {
                configurationTrace.setColor(color);
                graphTrace.setTraceColor(new Color((Device)Display.getDefault(), color));
            }
            graphTrace.setPointStyle(Trace.PointStyle.CROSS);
            this.traces.add(graphTrace);
            this.graph.addTrace(graphTrace);
            if (color == null) {
                configurationTrace.setColor(graphTrace.getTraceColor().getRGB());
            }
            ++n2;
        }
    }

    private Axis getAxis(boolean yAxis, String name) {
        for (Axis axis : this.graph.getAxisList()) {
            if (yAxis != axis.isYAxis() || !name.equals(axis.getTitle())) continue;
            return axis;
        }
        return null;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            try {
                listener.selectionChanged(event);
            }
            catch (RuntimeException runtimeException) {
            }
        }
    }

    private final class DataProvider
    extends AbstractDataProvider {
        private final List<ISample> samples;
        private final Dimension dimension;
        private final Measure measure;
        private double minX;
        private double maxX;
        private double minY;
        private double maxY;
        private final OptimizerDatastore.OptimizerResultSetAddListener listener;

        private DataProvider(Dimension dimension, Measure measure) {
            super(false);
            this.samples = new LinkedList<ISample>();
            this.listener = new OptimizerDatastore.OptimizerResultSetAddListener(){

                @Override
                public void handleStudyDatasetAdd(OptimizerResultSet dataset) {
                    DataProvider.this.addDataset(dataset);
                }
            };
            if (dimension == null || measure == null) {
                throw new IllegalArgumentException();
            }
            this.dimension = dimension;
            this.measure = measure;
        }

        private void initialize() {
            ChartConfigurationComposite.this.studyDatastore.addDatasetAddListener(this.listener);
            for (OptimizerResultSet dataset : ChartConfigurationComposite.this.studyDatastore.getDatasets()) {
                this.addDataset(dataset);
            }
        }

        private void addDataset(OptimizerResultSet dataset) {
            double xdata = 0.0;
            xdata = dataset.getValue(this.dimension.getName());
            double ydata = dataset.getValue(this.measure.getName());
            Sample sample = new Sample(xdata, ydata);
            this.addSample((ISample)sample);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    DataProvider.this.fireDataChange();
                }
            });
        }

        private void addSample(ISample sample) {
            for (ISample storedSample : this.samples) {
                if (sample.getXValue() != storedSample.getXValue()) continue;
                return;
            }
            boolean dataChanged = false;
            if (this.samples.size() == 0) {
                this.minX = sample.getXValue();
                this.maxX = sample.getXValue();
                this.minY = sample.getYValue();
                this.maxY = sample.getYValue();
                dataChanged = true;
            } else {
                if (sample.getXValue() < this.minX) {
                    this.minX = sample.getXValue();
                    dataChanged = true;
                }
                if (sample.getXValue() > this.maxX) {
                    this.maxX = sample.getXValue();
                    dataChanged = true;
                }
                if (sample.getYValue() < this.minY) {
                    this.minY = sample.getYValue();
                    dataChanged = true;
                }
                if (sample.getYValue() > this.maxY) {
                    this.maxY = sample.getYValue();
                    dataChanged = true;
                }
            }
            this.samples.add(sample);
            Collections.sort(this.samples, SampleComparator.INSTANCE);
            if (dataChanged) {
                this.updateDataRange();
            }
        }

        public int getSize() {
            return this.samples.size();
        }

        public ISample getSample(int index) {
            return this.samples.get(index);
        }

        protected void innerUpdate() {
        }

        protected void updateDataRange() {
            this.xDataMinMax = new Range(this.minX, this.maxX);
            this.yDataMinMax = new Range(this.minY, this.maxY);
        }

        private void close() {
            ChartConfigurationComposite.this.studyDatastore.removeDatasetAddListener(this.listener);
        }
    }

    private static final class RemoveTraceAction
    extends Action
    implements ConfigurationViewer.VisibilityAction {
        private ChartConfiguration.Trace trace;
        private boolean visible;

        private RemoveTraceAction() {
            super(Messages.removeTraceActionLabel);
        }

        private void setTrace(ChartConfiguration.Trace trace) {
            this.trace = trace;
        }

        private ChartConfiguration.Trace getTrace() {
            return this.trace;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void run() {
            this.getTrace().getChartConfiguration().removeTrace(this.trace);
        }
    }

    private static final class SampleComparator
    implements Comparator<ISample> {
        private static final SampleComparator INSTANCE = new SampleComparator();

        private SampleComparator() {
        }

        @Override
        public int compare(ISample sample1, ISample sample2) {
            return Double.compare(sample1.getXValue(), sample2.getXValue());
        }
    }
}

