/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.execution;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.rcenvironment.components.switchcmp.common.SwitchComponentConstants;
import de.rcenvironment.components.switchcmp.common.SwitchCondition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.component.update.api.PersistentComponentDescriptionUpdaterUtils;
import de.rcenvironment.core.component.update.spi.PersistentComponentDescriptionUpdater;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;

public class SwitchPersistentComponentDescriptionUpdater
implements PersistentComponentDescriptionUpdater {
    private static final String V1_1 = "1.1";
    private static final String V2_0 = "2.0";
    private static final String CURRENT_VERSION = "2.0";
    private static ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();

    public String[] getComponentIdentifiersAffectedByUpdate() {
        return SwitchComponentConstants.COMPONENT_IDS;
    }

    public int getFormatVersionsAffectedByUpdate(String persistentComponentDescriptionVersion, boolean silent) {
        int versionsToUpdate = 0;
        if (persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo("2.0") < 0) {
            versionsToUpdate |= 4;
        }
        return versionsToUpdate;
    }

    public PersistentComponentDescription performComponentDescriptionUpdate(int formatVersion, PersistentComponentDescription description, boolean silent) throws IOException {
        if (silent) {
            if (formatVersion == 4 && description.getComponentVersion().compareTo(V1_1) < 0) {
                description = this.updateToComponentVersion11(description);
            }
        } else if (formatVersion == 4 && description.getComponentVersion().compareTo("2.0") < 0) {
            description = this.updateToComponentVersion20(description);
        }
        return description;
    }

    private PersistentComponentDescription updateToComponentVersion20(PersistentComponentDescription description) throws IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        JsonNode staticInput = node.get("staticInputs");
        JsonNode staticOutputs = node.get("staticOutputs");
        String inputName = null;
        ObjectNode metaData = null;
        if (staticInput != null) {
            JsonNode endpoint = staticInput.get(0);
            inputName = endpoint.get("name").asText();
            String dataType = endpoint.get("datatype").asText();
            JsonNode identifier = endpoint.get("identifier");
            metaData = (ObjectNode)endpoint.get("metadata");
            if (metaData == null) {
                metaData = JsonNodeFactory.instance.objectNode();
                metaData.put("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.Required.name());
                metaData.put("inputHandling_73b1056e", EndpointDefinition.InputDatumHandling.Queue.name());
            }
            description = PersistentComponentDescriptionUpdaterUtils.addDynamicInput((PersistentComponentDescription)description, (String)inputName, (String)dataType, (ObjectNode)metaData, (JsonNode)identifier, (String)"dataToInput");
        }
        if (staticOutputs != null && inputName != null) {
            for (JsonNode endpoint : staticOutputs) {
                JsonNode identifier;
                String dataType;
                String outputName;
                String name = endpoint.get("name").asText();
                if (name.equals("True")) {
                    outputName = String.valueOf(inputName) + "_condition" + " 1";
                    dataType = endpoint.get("datatype").asText();
                    identifier = endpoint.get("identifier");
                    description = PersistentComponentDescriptionUpdaterUtils.addDynamicOutput((PersistentComponentDescription)description, (String)outputName, (String)dataType, (ObjectNode)metaData, (JsonNode)identifier, (String)"dataToOutput");
                }
                if (!name.equals("False")) continue;
                outputName = String.valueOf(inputName) + "_no match";
                dataType = endpoint.get("datatype").asText();
                identifier = endpoint.get("identifier");
                description = PersistentComponentDescriptionUpdaterUtils.addDynamicOutput((PersistentComponentDescription)description, (String)outputName, (String)dataType, (ObjectNode)metaData, (JsonNode)identifier, (String)"dataToOutput");
            }
        }
        node = mapper.readTree(description.getComponentDescriptionAsString());
        ((ObjectNode)node).remove("staticInputs");
        ((ObjectNode)node).remove("staticOutputs");
        JsonNode config = node.get("configuration");
        if (config != null) {
            ((ObjectNode)config).set("closeOutputsOnNoMatch", (JsonNode)TextNode.valueOf((String)config.get("closeOutputsOnFalse").asText()));
            ((ObjectNode)config).remove("closeOutputsOnFalse");
            ((ObjectNode)config).set("closeOutputsOnConditionNumber", (JsonNode)TextNode.valueOf((String)config.get("closeOutputsOnTrue").asText()));
            ((ObjectNode)config).remove("closeOutputsOnTrue");
            ((ObjectNode)config).set("selectedCondition", (JsonNode)TextNode.valueOf((String)"0"));
            ((ObjectNode)config).set("writeOutputKey", (JsonNode)TextNode.valueOf((String)"false"));
            ArrayList<SwitchCondition> arr = new ArrayList<SwitchCondition>();
            SwitchCondition switchCondition = new SwitchCondition(1, config.get("conditionKey").asText());
            arr.add(switchCondition);
            String conditionString = mapper.writeValueAsString(arr);
            ((ObjectNode)config).set("conditionKey", (JsonNode)TextNode.valueOf((String)conditionString));
        }
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion("2.0");
        return description;
    }

    private PersistentComponentDescription updateToComponentVersion11(PersistentComponentDescription description) throws IOException {
        JsonNode dynamicInputs;
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        JsonNode staticInputs = node.get("staticInputs");
        if (staticInputs != null) {
            for (JsonNode endpoint : staticInputs) {
                ObjectNode metaData = (ObjectNode)endpoint.get("metadata");
                if (metaData == null) continue;
                metaData.put("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.Required.name());
            }
        }
        if ((dynamicInputs = node.get("dynamicInputs")) != null) {
            for (JsonNode endpoint : dynamicInputs) {
                ObjectNode metaData = (ObjectNode)endpoint.get("metadata");
                String currentConstraint = metaData.get("inputExecutionConstraint_4aae3eea").textValue();
                if (!currentConstraint.equals(EndpointDefinition.InputExecutionContraint.NotRequired.name())) continue;
                metaData.put("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.RequiredIfConnected.name());
            }
        }
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion(V1_1);
        return description;
    }
}

