/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.common;

import de.rcenvironment.core.utils.testing.ParameterizedTestUtils;
import de.rcenvironment.core.utils.testing.TestParametersProvider;
import java.io.File;
import java.io.IOException;

public final class CommonTestConfiguration {
    private static CommonTestConfiguration instance;
    private final TestParametersProvider testParameters;

    private CommonTestConfiguration(String propertiesFileLocation) throws IOException {
        this.testParameters = new ParameterizedTestUtils().readPropertiesFile(new File(propertiesFileLocation));
    }

    public static void initialize(String propertiesFileLocation) throws IOException {
        instance = new CommonTestConfiguration(propertiesFileLocation);
    }

    public static TestParametersProvider getParameters() {
        return CommonTestConfiguration.getInstance().testParameters;
    }

    private static CommonTestConfiguration getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Tried to access common configuration before calling initialize()");
        }
        return instance;
    }
}

