/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal;

import com.googlecode.lanterna.input.InputProvider;
import com.googlecode.lanterna.terminal.TerminalSize;

public interface Terminal
extends InputProvider {
    public void enterPrivateMode();

    public void exitPrivateMode();

    public void clearScreen();

    public void moveCursor(int var1, int var2);

    public void setCursorVisible(boolean var1);

    public void putCharacter(char var1);

    public void applySGR(SGR ... var1);

    public void applyForegroundColor(Color var1);

    public void applyForegroundColor(int var1, int var2, int var3);

    public void applyForegroundColor(int var1);

    public void applyBackgroundColor(Color var1);

    public void applyBackgroundColor(int var1, int var2, int var3);

    public void applyBackgroundColor(int var1);

    public void addResizeListener(ResizeListener var1);

    public void removeResizeListener(ResizeListener var1);

    @Deprecated
    public TerminalSize queryTerminalSize();

    public TerminalSize getTerminalSize();

    public void flush();

    public static interface ResizeListener {
        public void onResized(TerminalSize var1);
    }

    public static enum Color {
        BLACK(0),
        RED(1),
        GREEN(2),
        YELLOW(3),
        BLUE(4),
        MAGENTA(5),
        CYAN(6),
        WHITE(7),
        DEFAULT(9);

        private int index;

        private Color(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum SGR {
        RESET_ALL,
        ENTER_BOLD,
        ENTER_REVERSE,
        ENTER_UNDERLINE,
        ENTER_BLINK,
        EXIT_BOLD,
        EXIT_REVERSE,
        EXIT_UNDERLINE,
        EXIT_BLINK;

    }
}

