/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui;

import com.googlecode.lanterna.terminal.Terminal;
import java.util.EnumMap;
import java.util.Map;

public class Theme {
    private static final Definition DEFAULT = new Definition(Terminal.Color.BLACK, Terminal.Color.WHITE, false);
    private static final Definition SELECTED = new Definition(Terminal.Color.WHITE, Terminal.Color.BLUE, true);
    private Map<Category, Definition> styles = new EnumMap<Category, Definition>(Category.class);
    private static final Theme DEFAULT_INSTANCE = new Theme();

    protected Theme() {
        this.setDefinition(Category.DIALOG_AREA, DEFAULT);
        this.setDefinition(Category.SCREEN_BACKGROUND, new Definition(Terminal.Color.CYAN, Terminal.Color.BLUE, true));
        this.setDefinition(Category.SHADOW, new Definition(Terminal.Color.BLACK, Terminal.Color.BLACK, true));
        this.setDefinition(Category.BORDER, new Definition(Terminal.Color.BLACK, Terminal.Color.WHITE, true));
        this.setDefinition(Category.RAISED_BORDER, new Definition(Terminal.Color.WHITE, Terminal.Color.WHITE, true));
        this.setDefinition(Category.BUTTON_LABEL_ACTIVE, new Definition(Terminal.Color.YELLOW, Terminal.Color.BLUE, true));
        this.setDefinition(Category.BUTTON_LABEL_INACTIVE, new Definition(Terminal.Color.BLACK, Terminal.Color.WHITE, true));
        this.setDefinition(Category.BUTTON_ACTIVE, SELECTED);
        this.setDefinition(Category.BUTTON_INACTIVE, DEFAULT);
        this.setDefinition(Category.LIST_ITEM, DEFAULT);
        this.setDefinition(Category.LIST_ITEM_SELECTED, SELECTED);
        this.setDefinition(Category.CHECKBOX, DEFAULT);
        this.setDefinition(Category.CHECKBOX_SELECTED, SELECTED);
        this.setDefinition(Category.TEXTBOX, SELECTED);
        this.setDefinition(Category.TEXTBOX_FOCUSED, new Definition(Terminal.Color.YELLOW, Terminal.Color.BLUE, true));
        this.setDefinition(Category.PROGRESS_BAR_COMPLETED, new Definition(Terminal.Color.GREEN, Terminal.Color.BLACK, false));
        this.setDefinition(Category.PROGRESS_BAR_REMAINING, new Definition(Terminal.Color.RED, Terminal.Color.BLACK, false));
    }

    public Definition getDefinition(Category category) {
        if (this.styles.containsKey((Object)category) && this.styles.get((Object)category) != null) {
            return this.styles.get((Object)category);
        }
        return this.getDefault();
    }

    protected void setDefinition(Category category, Definition def) {
        if (def == null) {
            this.styles.remove((Object)category);
        } else {
            this.styles.put(category, def);
        }
    }

    protected Definition getDefaultStyle() {
        return DEFAULT;
    }

    @Deprecated
    protected Definition getDefault() {
        return this.getDefaultStyle();
    }

    @Deprecated
    protected Definition getDialogEmptyArea() {
        return this.getDefinition(Category.DIALOG_AREA);
    }

    @Deprecated
    protected Definition getScreenBackground() {
        return this.getDefinition(Category.SCREEN_BACKGROUND);
    }

    @Deprecated
    protected Definition getShadow() {
        return this.getDefinition(Category.SHADOW);
    }

    @Deprecated
    protected Definition getBorder() {
        return this.getDefinition(Category.BORDER);
    }

    @Deprecated
    protected Definition getRaisedBorder() {
        return this.getDefinition(Category.RAISED_BORDER);
    }

    @Deprecated
    protected Definition getButtonLabelActive() {
        return this.getDefinition(Category.BUTTON_LABEL_ACTIVE);
    }

    @Deprecated
    protected Definition getButtonLabelInactive() {
        return this.getDefinition(Category.BUTTON_LABEL_INACTIVE);
    }

    @Deprecated
    protected Definition getButtonActive() {
        return this.getDefinition(Category.BUTTON_ACTIVE);
    }

    @Deprecated
    protected Definition getButtonInactive() {
        return this.getDefinition(Category.BUTTON_INACTIVE);
    }

    @Deprecated
    protected Definition getItem() {
        return this.getDefinition(Category.LIST_ITEM);
    }

    @Deprecated
    protected Definition getItemSelected() {
        return this.getDefinition(Category.LIST_ITEM_SELECTED);
    }

    @Deprecated
    protected Definition getCheckBox() {
        return this.getDefinition(Category.CHECKBOX);
    }

    @Deprecated
    protected Definition getCheckBoxSelected() {
        return this.getDefinition(Category.CHECKBOX_SELECTED);
    }

    @Deprecated
    protected Definition getTextBoxFocused() {
        return this.getDefinition(Category.TEXTBOX_FOCUSED);
    }

    @Deprecated
    protected Definition getTextBox() {
        return this.getDefinition(Category.TEXTBOX);
    }

    public static Theme getDefaultTheme() {
        return DEFAULT_INSTANCE;
    }

    public static class Definition {
        private Terminal.Color foreground;
        private Terminal.Color background;
        private boolean highlighted;
        private boolean underlined;

        public Definition(Terminal.Color foreground, Terminal.Color background) {
            this(foreground, background, false);
        }

        public Definition(Terminal.Color foreground, Terminal.Color background, boolean highlighted) {
            this(foreground, background, highlighted, false);
        }

        public Definition(Terminal.Color foreground, Terminal.Color background, boolean highlighted, boolean underlined) {
            if (foreground == null) {
                throw new IllegalArgumentException("foreground color cannot be null");
            }
            if (background == null) {
                throw new IllegalArgumentException("background color cannot be null");
            }
            this.foreground = foreground;
            this.background = background;
            this.highlighted = highlighted;
            this.underlined = underlined;
        }

        public Terminal.Color foreground() {
            return this.foreground;
        }

        public Terminal.Color background() {
            return this.background;
        }

        public boolean isHighlighted() {
            return this.highlighted;
        }

        public boolean isUnderlined() {
            return this.underlined;
        }
    }

    public static enum Category {
        DIALOG_AREA,
        SCREEN_BACKGROUND,
        SHADOW,
        RAISED_BORDER,
        BORDER,
        BUTTON_ACTIVE,
        BUTTON_INACTIVE,
        BUTTON_LABEL_INACTIVE,
        BUTTON_LABEL_ACTIVE,
        LIST_ITEM,
        LIST_ITEM_SELECTED,
        CHECKBOX,
        CHECKBOX_SELECTED,
        TEXTBOX,
        TEXTBOX_FOCUSED,
        PROGRESS_BAR_COMPLETED,
        PROGRESS_BAR_REMAINING;

    }
}

