/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui;

import com.googlecode.lanterna.gui.TextGraphics;
import com.googlecode.lanterna.gui.Theme;
import com.googlecode.lanterna.screen.ScreenCharacterStyle;
import com.googlecode.lanterna.terminal.TerminalPosition;
import com.googlecode.lanterna.terminal.TerminalSize;

public abstract class Border {
    public abstract void drawBorder(TextGraphics var1, TerminalSize var2, String var3);

    public abstract TerminalSize getInnerAreaSize(int var1, int var2);

    public abstract TerminalPosition getInnerAreaLocation(int var1, int var2);

    public abstract TerminalSize surroundAreaSize(TerminalSize var1);

    public static class Invisible
    extends Border {
        @Override
        public void drawBorder(TextGraphics graphics, TerminalSize actualSize, String title) {
        }

        @Override
        public TerminalPosition getInnerAreaLocation(int width, int height) {
            return new TerminalPosition(0, 0);
        }

        @Override
        public TerminalSize getInnerAreaSize(int width, int height) {
            return new TerminalSize(width, height);
        }

        @Override
        public TerminalSize surroundAreaSize(TerminalSize TerminalSize2) {
            return TerminalSize2;
        }
    }

    public static class Bevel
    extends Border {
        private boolean raised;

        public Bevel(boolean raised) {
            this.raised = raised;
        }

        @Override
        public void drawBorder(TextGraphics graphics, TerminalSize actualSize, String title) {
            int i;
            Theme.Definition lowerRight;
            Theme.Definition upperLeft;
            int width = actualSize.getColumns();
            int height = actualSize.getRows();
            if (this.raised) {
                upperLeft = graphics.getTheme().getDefinition(Theme.Category.RAISED_BORDER);
                lowerRight = graphics.getTheme().getDefinition(Theme.Category.BORDER);
            } else {
                upperLeft = graphics.getTheme().getDefinition(Theme.Category.BORDER);
                lowerRight = graphics.getTheme().getDefinition(Theme.Category.RAISED_BORDER);
            }
            graphics.applyTheme(upperLeft);
            graphics.drawString(0, 0, "\u250c", new ScreenCharacterStyle[0]);
            for (i = 1; i < width - 1; ++i) {
                graphics.drawString(i, 0, "\u2500", new ScreenCharacterStyle[0]);
            }
            graphics.applyTheme(lowerRight);
            graphics.drawString(width - 1, 0, "\u2510", new ScreenCharacterStyle[0]);
            for (i = 1; i < height - 1; ++i) {
                graphics.applyTheme(upperLeft);
                graphics.drawString(0, i, "\u2502", new ScreenCharacterStyle[0]);
                graphics.applyTheme(lowerRight);
                graphics.drawString(width - 1, i, "\u2502", new ScreenCharacterStyle[0]);
            }
            graphics.applyTheme(upperLeft);
            graphics.drawString(0, height - 1, "\u2514", new ScreenCharacterStyle[0]);
            graphics.applyTheme(lowerRight);
            for (i = 1; i < width - 1; ++i) {
                graphics.drawString(i, height - 1, "\u2500", new ScreenCharacterStyle[0]);
            }
            graphics.drawString(width - 1, height - 1, "\u2518", new ScreenCharacterStyle[0]);
            graphics.applyTheme(graphics.getTheme().getDefinition(Theme.Category.DIALOG_AREA));
            graphics.setBoldMask(true);
            graphics.drawString(2, 0, title, new ScreenCharacterStyle[0]);
        }

        @Override
        public TerminalPosition getInnerAreaLocation(int width, int height) {
            if (width > 2 && height > 2) {
                return new TerminalPosition(2, 1);
            }
            return new TerminalPosition(0, 0);
        }

        @Override
        public TerminalSize getInnerAreaSize(int width, int height) {
            if (width > 2 && height > 2) {
                return new TerminalSize(width - 4, height - 2);
            }
            return new TerminalSize(width, height);
        }

        @Override
        public TerminalSize surroundAreaSize(TerminalSize TerminalSize2) {
            return new TerminalSize(TerminalSize2.getColumns() == Integer.MAX_VALUE ? Integer.MAX_VALUE : TerminalSize2.getColumns() + 4, TerminalSize2.getRows() == Integer.MAX_VALUE ? Integer.MAX_VALUE : TerminalSize2.getRows() + 2);
        }
    }

    public static class Standard
    extends Border {
        @Override
        public void drawBorder(TextGraphics graphics, TerminalSize actualSize, String title) {
            int x;
            graphics.applyTheme(graphics.getTheme().getDefinition(Theme.Category.BORDER));
            int width = actualSize.getColumns();
            int height = actualSize.getRows();
            graphics.drawString(0, 0, "\u250c", new ScreenCharacterStyle[0]);
            for (x = 1; x < width - 1; ++x) {
                graphics.drawString(x, 0, "\u2500", new ScreenCharacterStyle[0]);
            }
            graphics.drawString(width - 1, 0, "\u2510", new ScreenCharacterStyle[0]);
            for (int i = 1; i < height - 1; ++i) {
                graphics.drawString(0, i, "\u2502", new ScreenCharacterStyle[0]);
                graphics.drawString(0 + width - 1, i, "\u2502", new ScreenCharacterStyle[0]);
            }
            graphics.drawString(0, height - 1, "\u2514", new ScreenCharacterStyle[0]);
            for (x = 1; x < width - 1; ++x) {
                graphics.drawString(x, height - 1, "\u2500", new ScreenCharacterStyle[0]);
            }
            graphics.drawString(width - 1, height - 1, "\u2518", new ScreenCharacterStyle[0]);
            graphics.applyTheme(graphics.getTheme().getDefinition(Theme.Category.DIALOG_AREA));
            graphics.setBoldMask(true);
            graphics.drawString(2, 0, title, new ScreenCharacterStyle[0]);
        }

        @Override
        public TerminalPosition getInnerAreaLocation(int width, int height) {
            if (width > 2 && height > 2) {
                return new TerminalPosition(2, 1);
            }
            return new TerminalPosition(0, 0);
        }

        @Override
        public TerminalSize getInnerAreaSize(int width, int height) {
            if (width > 2 && height > 2) {
                return new TerminalSize(width - 4, height - 2);
            }
            return new TerminalSize(width, height);
        }

        @Override
        public TerminalSize surroundAreaSize(TerminalSize TerminalSize2) {
            return new TerminalSize(TerminalSize2.getColumns() == Integer.MAX_VALUE ? Integer.MAX_VALUE : TerminalSize2.getColumns() + 4, TerminalSize2.getRows() == Integer.MAX_VALUE ? Integer.MAX_VALUE : TerminalSize2.getRows() + 2);
        }
    }
}

