/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.palette.view.dialogs;

import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.AccessibleComponentNode;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ComponentInformationDialog
extends TitleAreaDialog {
    private static final int STYLED_TEXT_LINE_SPACING = 2;
    private static final int STYLED_TEXT_MARGIN = 5;
    private static final String MESSAGE_STRING = "Component information about the '%s' component.";
    private static final String STRING_COLON = ":";
    private AccessibleComponentNode node;

    public ComponentInformationDialog(Shell parentShell, AccessibleComponentNode node) {
        super(parentShell);
        this.node = node;
        ComponentInformationDialog.setDialogHelpAvailable((boolean)false);
    }

    public void create() {
        super.create();
        this.setTitle(this.node.getDisplayName());
        this.setMessage(StringUtils.format((String)MESSAGE_STRING, (Object[])new Object[]{this.node.getDisplayName()}));
        ComponentInterface componentInterface = this.node.getComponentEntry().getComponentInterface();
        if (componentInterface.getIcon32() != null) {
            this.setTitleImage(new Image((Device)Display.getCurrent(), (InputStream)new ByteArrayInputStream(componentInterface.getIcon32())));
            return;
        }
        if (componentInterface.getIcon24() != null) {
            this.setTitleImage(new Image((Device)Display.getCurrent(), (InputStream)new ByteArrayInputStream(componentInterface.getIcon24())));
            return;
        }
        if (this.node.getIcon().isPresent()) {
            this.setTitleImage(this.node.getIcon().get());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        StyledText text = new StyledText(container, 66);
        text.setEditable(false);
        text.setEnabled(false);
        text.setMargins(5, 5, 5, 5);
        text.setLineSpacing(2);
        text.setLayoutData((Object)new GridData(1808));
        text.setText(this.node.getComponentInformation());
        this.autoformatText(text);
        return container;
    }

    private void autoformatText(StyledText text) {
        ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
        int i = 0;
        while (i < text.getLineCount()) {
            String line = text.getLine(i);
            ranges.add(new StyleRange(text.getOffsetAtLine(i), line.indexOf(STRING_COLON) + 1, null, null, 1));
            ++i;
        }
        text.setStyleRanges(ranges.toArray(new StyleRange[ranges.size()]));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }
}

