/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.network.internal;

import de.rcenvironment.core.utils.common.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.LogFactory;

public enum UplinkProtocolErrorType {
    LOW_LEVEL_CONNECTION_ERROR(0, true),
    PROTOCOL_VERSION_MISMATCH(1, false),
    CLIENT_NAMESPACE_COLLISION(2, false),
    SERVER_SHUTTING_DOWN(10, true),
    PROTOCOL_VIOLATION(90, false),
    INVALID_HANDSHAKE_DATA(91, false),
    UNKNOWN_ERROR_ALLOW_RECONNECT(92, true),
    INTERNAL_CLIENT_ERROR(93, false),
    UNRECOGNIZED_ERROR_MESSAGE(99, false);

    private static final Pattern PARSE_PATTERN;
    private int code;
    private boolean clientRetry;

    static {
        PARSE_PATTERN = Pattern.compile("E(\\d+): (.*)");
    }

    private UplinkProtocolErrorType(int code, boolean clientRetry) {
        this.code = code;
        this.clientRetry = clientRetry;
    }

    public int getCode() {
        return this.code;
    }

    public boolean getClientRetryFlag() {
        return this.clientRetry;
    }

    String wrapErrorMessage(String message) {
        return StringUtils.format((String)"E%d: %s", (Object[])new Object[]{this.code, message});
    }

    static UplinkProtocolErrorType typeOfWrappedErrorMessage(String message) {
        Matcher matcher = PARSE_PATTERN.matcher(message);
        if (matcher.matches()) {
            int inputCode = Integer.parseInt(matcher.group(1));
            UplinkProtocolErrorType[] uplinkProtocolErrorTypeArray = UplinkProtocolErrorType.values();
            int n = uplinkProtocolErrorTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                UplinkProtocolErrorType type = uplinkProtocolErrorTypeArray[n2];
                if (type.code == inputCode) {
                    return type;
                }
                ++n2;
            }
            LogFactory.getLog(UplinkProtocolErrorType.class).warn((Object)("Failed to recognize error code of message; raw text: " + message));
            return UNRECOGNIZED_ERROR_MESSAGE;
        }
        LogFactory.getLog(UplinkProtocolErrorType.class).warn((Object)("Failed to parse error code of message; raw text: " + message));
        return UNRECOGNIZED_ERROR_MESSAGE;
    }

    static String unwrapErrorMessage(String message) {
        Matcher matcher = PARSE_PATTERN.matcher(message);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return "<Unexpected error formatting>: " + message;
    }
}

