/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.cpacs.writer.execution;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.rcenvironment.components.cpacs.writer.common.CpacsWriterComponentConstants;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.component.update.api.PersistentComponentDescriptionUpdaterUtils;
import de.rcenvironment.core.component.update.spi.PersistentComponentDescriptionUpdater;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;

public class CpacsWriterPersistentComponentDescriptionUpdater
implements PersistentComponentDescriptionUpdater {
    private static final String V3_0 = "3.0";
    private static final String V3_1 = "3.1";
    private final String currentVersion = "3.1";

    public String[] getComponentIdentifiersAffectedByUpdate() {
        return CpacsWriterComponentConstants.COMPONENT_IDS;
    }

    public int getFormatVersionsAffectedByUpdate(String persistentComponentDescriptionVersion, boolean silent) {
        int versionsToUpdate = 0;
        if (!silent) {
            if (persistentComponentDescriptionVersion == null || persistentComponentDescriptionVersion.compareTo(V3_0) < 0) {
                versionsToUpdate |= 2;
            }
            if (persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo(V3_1) < 0) {
                versionsToUpdate |= 4;
            }
        }
        return versionsToUpdate;
    }

    public PersistentComponentDescription performComponentDescriptionUpdate(int formatVersion, PersistentComponentDescription description, boolean silent) throws IOException {
        if (!silent) {
            if (formatVersion == 2) {
                return this.updateFromToV30(description);
            }
            if (formatVersion == 4) {
                return this.updateFromV30ToV31(description);
            }
        }
        return description;
    }

    private PersistentComponentDescription updateFromV30ToV31(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        description = PersistentComponentDescriptionUpdaterUtils.updateSchedulingInformation((PersistentComponentDescription)description);
        description.setComponentVersion(V3_1);
        return description;
    }

    private PersistentComponentDescription updateFromToV30(PersistentComponentDescription description) throws JsonParseException, IOException {
        description = PersistentComponentDescriptionUpdaterUtils.updateAllDynamicEndpointsToIdentifier((String)"dynamicOutputs", (String)"default", (PersistentComponentDescription)description);
        description = PersistentComponentDescriptionUpdaterUtils.updateAllDynamicEndpointsToIdentifier((String)"dynamicInputs", (String)"default", (PersistentComponentDescription)description);
        description = PersistentComponentDescriptionUpdaterUtils.addStaticInput((PersistentComponentDescription)description, (String)"CPACS");
        description = PersistentComponentDescriptionUpdaterUtils.addStaticOutput((PersistentComponentDescription)description, (String)"CPACS");
        description = PersistentComponentDescriptionUpdaterUtils.updateConsumeCPACSFlag((PersistentComponentDescription)description);
        description = PersistentComponentDescriptionUpdaterUtils.updateDynamicInputsOptional((PersistentComponentDescription)description);
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ObjectNode configuration = (ObjectNode)node.get("configuration");
        String saveMode = configuration.get("saveMode").textValue();
        configuration.remove("saveMode");
        if (saveMode.equals("OverwriteAtEachRun")) {
            configuration.set("saveMode", (JsonNode)TextNode.valueOf((String)"true"));
        } else {
            configuration.set("saveMode", (JsonNode)TextNode.valueOf((String)"false"));
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion(V3_0);
        return description;
    }
}

