/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.encryption.internal;

import de.rcenvironment.core.utils.encryption.EncryptionFactory;
import de.rcenvironment.core.utils.encryption.KeyBasedEncryption;
import de.rcenvironment.core.utils.encryption.PassphraseBasedEncryption;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultEncryption
implements PassphraseBasedEncryption,
KeyBasedEncryption {
    protected static final Log LOG = LogFactory.getLog(DefaultEncryption.class);
    protected final EncryptionFactory.EncryptionAlgorithm algorithm;

    public DefaultEncryption(EncryptionFactory.EncryptionAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public String encrypt(String text, String password) {
        return this.encrypt(text, this.createKey(password));
    }

    @Override
    public String decrypt(String text, String password) {
        return this.decrypt(text, this.createKey(password));
    }

    @Override
    public String encrypt(String text, Key key) {
        String errorMessage = "encrypting text failed";
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm.getName());
            cipher.init(1, key);
            byte[] encrypted = cipher.doFinal(text.getBytes());
            byte[] encoded = Base64.encodeBase64((byte[])encrypted);
            return StringUtils.newStringUtf8((byte[])encoded);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)errorMessage, (Throwable)e);
            return null;
        }
        catch (NoSuchPaddingException e) {
            LOG.error((Object)errorMessage, (Throwable)e);
            return null;
        }
        catch (InvalidKeyException e) {
            LOG.error((Object)errorMessage, (Throwable)e);
            return null;
        }
        catch (IllegalBlockSizeException e) {
            LOG.error((Object)errorMessage, (Throwable)e);
            return null;
        }
        catch (BadPaddingException e) {
            LOG.error((Object)errorMessage, (Throwable)e);
            return null;
        }
    }

    @Override
    public String decrypt(String text, Key key) {
        String errorMessage = "decrypting text failed";
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm.getName());
            cipher.init(2, key);
            byte[] crypted = Base64.decodeBase64((String)text);
            byte[] cipherData = cipher.doFinal(crypted);
            return StringUtils.newString((byte[])cipherData, (String)"UTF-8");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)errorMessage, (Throwable)e);
            return null;
        }
        catch (NoSuchPaddingException e) {
            LOG.error((Object)errorMessage, (Throwable)e);
            return null;
        }
        catch (InvalidKeyException e) {
            LOG.error((Object)errorMessage, (Throwable)e);
            return null;
        }
        catch (IllegalBlockSizeException e) {
            LOG.error((Object)errorMessage, (Throwable)e);
            return null;
        }
        catch (BadPaddingException e) {
            LOG.error((Object)errorMessage, (Throwable)e);
            return null;
        }
    }

    private Key createKey(String password) {
        return new SecretKeySpec(DefaultEncryption.createHashFromKey(password), this.algorithm.getName());
    }

    private static byte[] createHashFromKey(String passphrase) {
        byte[] key;
        try {
            String salt = "#salty_";
            key = (String.valueOf(salt) + passphrase).getBytes();
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        return key;
    }
}

