/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.model.api;

import de.rcenvironment.core.component.model.spi.PropertiesChangeSupport;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.Serializable;
import java.util.UUID;

public class WorkflowLabel
extends PropertiesChangeSupport
implements Serializable,
Comparable<WorkflowLabel> {
    public static final String PALETTE_ENTRY_NAME = "Add Label";
    public static final int DEFAULT_HEADER_FONT_SIZE = 12;
    public static final int DEFAULT_FONT_SIZE = 9;
    public static final int DEFAULT_WIDTH = 121;
    public static final int DEFAULT_HEIGHT = 61;
    public static final String INITIAL_TEXT = "New label";
    public static final int DEFAULT_ALPHA = 128;
    public static final int DEFAULT_COLOR_BLUE = 34;
    public static final int DEFAULT_COLOR_GREEN = 146;
    public static final int DEFAULT_COLOR_RED = 57;
    public static final int DEFAULT_COLOR_BLACK = 0;
    public static final String PROPERTY_CHANGE = "de.rcenvironment.rce.component.workflow.WorkflowLabelProperty";
    public static final String COMMAND_CHANGE = "de.rcenvironment.rce.component.workflow.WorkflowLabelCommand";
    private static final int INT_255 = 255;
    private static final long serialVersionUID = 3420597804308218542L;
    private static final int INITIAL_ZINDEX = -1;
    private String headerText;
    private String text;
    private int x;
    private int y;
    private int width;
    private int height;
    private int alpha = 128;
    private String identifier;
    private int[] colorBackground;
    private int[] colorHeader;
    private int[] colorText;
    private boolean hasBorder;
    private LabelPosition labelPosition;
    private TextAlignmentType textAlignmentType;
    private TextAlignmentType headerAlignmentType;
    private int headerTextSize;
    private int textSize;
    private int zIndex;

    public WorkflowLabel(String text) {
        this.text = text;
        this.headerText = "";
        this.identifier = UUID.randomUUID().toString();
        this.setColorBackground(new int[]{57, 146, 34});
        this.setColorHeader(new int[3]);
        this.setColorText(new int[3]);
        this.setLabelPosition(LabelPosition.CENTER);
        this.setTextAlignmentType(TextAlignmentType.LEFT);
        this.setHeaderAlignmentType(TextAlignmentType.CENTER);
        this.setHasBorder(false);
        this.setHeaderTextSize(12);
        this.setTextSize(9);
        this.setSize(121, 61);
        this.zIndex = -1;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setLocation(int newX, int newY) {
        this.setX(newX);
        this.setY(newY);
        this.firePropertyChange(PROPERTY_CHANGE);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setSize(int newWidth, int newHeight) {
        this.setWidth(newWidth);
        this.setHeight(newHeight);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getAlphaDisplay() {
        return -this.alpha + 255;
    }

    public void setAlpha(int alpha) {
        this.alpha = 255 - alpha;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public int[] getColorBackground() {
        return this.colorBackground;
    }

    public void setColorBackground(int[] color) {
        this.colorBackground = color;
    }

    public int[] getColorText() {
        return this.colorText;
    }

    public void setColorText(int[] colorText) {
        this.colorText = colorText;
    }

    public boolean hasBorder() {
        return this.hasBorder;
    }

    public void setHasBorder(boolean hasBorder) {
        this.hasBorder = hasBorder;
    }

    public LabelPosition getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(LabelPosition labelPosition) {
        this.labelPosition = labelPosition;
    }

    public TextAlignmentType getTextAlignmentType() {
        return this.textAlignmentType;
    }

    public void setTextAlignmentType(TextAlignmentType textAlignmentType) {
        this.textAlignmentType = textAlignmentType;
    }

    public TextAlignmentType getHeaderAlignmentType() {
        return this.headerAlignmentType;
    }

    public void setHeaderAlignmentType(TextAlignmentType headerAlignmentType) {
        this.headerAlignmentType = headerAlignmentType;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    public void firePropertChangeEvent() {
        this.firePropertyChange(PROPERTY_CHANGE);
    }

    public String toString() {
        return StringUtils.format((String)"'%s' (x=%d, y=%d, height=%d, width=%d alpha=%d, color=%d %d %d, background=%d %d %d, border=%b, font size=%d)", (Object[])new Object[]{this.text, this.x, this.y, this.height, this.width, this.alpha, this.colorText[0], this.colorText[1], this.colorText[2], this.colorBackground[0], this.colorBackground[1], this.colorBackground[2], this.hasBorder, this.textSize});
    }

    @Override
    public int compareTo(WorkflowLabel o) {
        return this.getIdentifier().compareTo(o.getIdentifier());
    }

    public boolean equals(Object obj) {
        if (obj instanceof WorkflowLabel) {
            return this.getIdentifier().equals(((WorkflowLabel)obj).getIdentifier());
        }
        return false;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public String getHeaderText() {
        return this.headerText;
    }

    public void setHeaderText(String headerText) {
        this.headerText = headerText;
    }

    public int[] getColorHeader() {
        return this.colorHeader;
    }

    public void setColorHeader(int[] colorHeader) {
        this.colorHeader = colorHeader;
    }

    public int getHeaderTextSize() {
        return this.headerTextSize;
    }

    public void setHeaderTextSize(int headerTextSize) {
        this.headerTextSize = headerTextSize;
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public void setZIndex(int zindex) {
        this.zIndex = zindex;
    }

    public static enum LabelPosition {
        TOPLEFT,
        TOPCENTER,
        TOPRIGHT,
        CENTERLEFT,
        CENTER,
        CENTERRIGHT,
        BOTTOMLEFT,
        BOTTOMCENTER,
        BOTTOMRIGHT;

    }

    public static enum TextAlignmentType {
        LEFT,
        CENTER,
        RIGHT;

    }
}

