/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.transport.virtual.testutils;

import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.testutils.VirtualInstance;
import de.rcenvironment.core.communication.testutils.VirtualInstanceGroup;
import de.rcenvironment.core.communication.transport.virtual.testutils.VirtualInstanceTestUtils;
import java.util.concurrent.TimeoutException;

public class VirtualTopology {
    private VirtualInstance[] instances;
    private VirtualInstanceGroup allInstancesGroup;
    private VirtualInstanceTestUtils testUtils = new VirtualInstanceTestUtils(null, null);
    private int lastIndex;
    private boolean connectBothDirectionsByDefaultFlag;

    public VirtualTopology(VirtualInstance ... instances) {
        this.instances = instances;
        this.allInstancesGroup = new VirtualInstanceGroup(instances);
        this.lastIndex = instances.length - 1;
    }

    public int getInstanceCount() {
        return this.instances.length;
    }

    public VirtualInstance[] getInstances() {
        return this.instances;
    }

    public VirtualInstance getInstance(int i) {
        return this.instances[i];
    }

    public VirtualInstance getFirstInstance() {
        return this.instances[0];
    }

    public VirtualInstance getLastInstance() {
        return this.instances[this.lastIndex];
    }

    public VirtualInstance getRandomInstance() {
        return this.testUtils.getRandomInstance(this.instances);
    }

    public VirtualInstance getRandomInstanceExcept(VirtualInstance ... not) {
        return this.testUtils.getRandomInstance(this.instances, not);
    }

    public VirtualInstanceGroup getAsGroup() {
        return this.allInstancesGroup;
    }

    public void connect(int from, int to) {
        this.connect(from, to, this.connectBothDirectionsByDefaultFlag);
    }

    public void connect(int from, int to, boolean bothDirections) {
        NetworkContactPoint targetSCP = this.instances[to].getDefaultContactPoint();
        this.instances[from].connectAsync(targetSCP);
        if (bothDirections) {
            this.connect(to, from, false);
        }
    }

    public void waitUntilReachable(int from, int to, int timeout) throws InterruptedException, TimeoutException {
        this.getInstance(from).waitUntilContainsInReachableNodes(this.getInstance(to).getInstanceNodeSessionId(), timeout);
    }

    public void connectAndWait(int from, int to, int timeoutMsec) throws TimeoutException, InterruptedException {
        this.connect(from, to);
        this.waitUntilReachable(from, to, timeoutMsec);
        if (this.connectBothDirectionsByDefaultFlag) {
            this.waitUntilReachable(to, from, timeoutMsec);
        }
    }

    public void connectToChain(boolean bothDirections) {
        this.connectToChain(0, this.lastIndex, bothDirections);
    }

    public void connectToChain(int from, int to, boolean bothDirections) {
        if (to < from) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < to) {
            this.connect(i, i + 1, bothDirections);
            ++i;
        }
    }

    public void connectToRing(boolean bothDirections) {
        this.connectToRing(0, this.lastIndex, bothDirections);
    }

    public void connectToRing(int from, int to, boolean bothDirections) {
        this.connectToChain(from, to, bothDirections);
        this.connect(to, from, bothDirections);
    }

    public boolean allInstancesConverged() {
        return this.testUtils.allInstancesHaveSameRawNetworkGraph(this.instances);
    }

    public void setConnectBothDirectionsByDefaultFlag(boolean connectBothDirectionsByDefaultFlag) {
        this.connectBothDirectionsByDefaultFlag = connectBothDirectionsByDefaultFlag;
    }
}

