/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.transport.virtual;

import de.rcenvironment.core.communication.channel.MessageChannelState;
import de.rcenvironment.core.communication.channel.ServerContactPoint;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.SerializationException;
import de.rcenvironment.core.communication.connection.internal.ConnectionClosedException;
import de.rcenvironment.core.communication.model.InitialNodeInformation;
import de.rcenvironment.core.communication.model.NetworkRequest;
import de.rcenvironment.core.communication.model.NetworkResponse;
import de.rcenvironment.core.communication.model.impl.NetworkRequestImpl;
import de.rcenvironment.core.communication.model.impl.NetworkResponseImpl;
import de.rcenvironment.core.communication.protocol.MessageMetaData;
import de.rcenvironment.core.communication.protocol.NetworkRequestFactory;
import de.rcenvironment.core.communication.protocol.NetworkResponseFactory;
import de.rcenvironment.core.communication.transport.spi.AbstractMessageChannel;
import de.rcenvironment.core.communication.transport.spi.MessageChannelEndpointHandler;
import de.rcenvironment.core.communication.transport.spi.MessageChannelResponseHandler;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VirtualNetworkMessageChannel
extends AbstractMessageChannel {
    protected final Log log = LogFactory.getLog(this.getClass());
    private MessageChannelEndpointHandler receivingRawEndpointHandler;
    private InitialNodeInformation ownNodeInformation;
    private AsyncTaskService threadPool = ConcurrencyUtils.getAsyncTaskService();

    public VirtualNetworkMessageChannel(InitialNodeInformation ownNodeInformation, String ownProtocolVersion, MessageChannelEndpointHandler receivingRawEndpointHandler, ServerContactPoint remoteSCP) throws CommunicationException {
        this.receivingRawEndpointHandler = receivingRawEndpointHandler;
        this.ownNodeInformation = ownNodeInformation;
        this.associatedSCP = remoteSCP;
        this.failOnIncompatibleVersions(remoteSCP.getExpectedProtocolVersion(), ownProtocolVersion);
    }

    @Override
    public void sendRequest(final NetworkRequest request, final MessageChannelResponseHandler responseHandler, int timeoutMsec) {
        if (request == null || responseHandler == null) {
            throw new NullPointerException();
        }
        Callable<NetworkResponse> task = new Callable<NetworkResponse>(){

            @Override
            @TaskDescription(value="Communication Layer: Virtual connection message sending")
            public NetworkResponse call() throws Exception {
                if (VirtualNetworkMessageChannel.this.isSimulatingBreakdown()) {
                    responseHandler.onChannelBroken(request, VirtualNetworkMessageChannel.this);
                    throw new ConnectionClosedException("Simulating breakdown of virtual channel " + VirtualNetworkMessageChannel.this.getChannelId());
                }
                if (VirtualNetworkMessageChannel.this.associatedSCP.isSimulatingBreakdown()) {
                    responseHandler.onChannelBroken(request, VirtualNetworkMessageChannel.this);
                    throw new ConnectionClosedException(VirtualNetworkMessageChannel.this.associatedSCP + " is simulating breakdown; failing send attempt on channel " + VirtualNetworkMessageChannel.this.getChannelId());
                }
                try {
                    return this.simulateRoundTrip(request, responseHandler);
                }
                catch (RuntimeException e) {
                    String errorId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)VirtualNetworkMessageChannel.this.log, (String)"Uncaught RuntimeException", (Throwable)e);
                    NetworkResponse errorResponse = NetworkResponseFactory.generateResponseForErrorDuringDelivery(request, VirtualNetworkMessageChannel.this.ownNodeInformation.getInstanceNodeSessionId(), errorId);
                    responseHandler.onResponseAvailable(errorResponse);
                    throw new CommunicationException("Failed to simulate request-response loop (request id: '" + request.getRequestId() + "')", e);
                }
            }

            private NetworkResponse simulateRoundTrip(NetworkRequest request2, MessageChannelResponseHandler responseHandler2) throws SerializationException {
                String virtualSenderId = VirtualNetworkMessageChannel.this.ownNodeInformation.getInstanceNodeSessionId().getInstanceNodeSessionIdString();
                NetworkRequestImpl clonedRequest = NetworkRequestFactory.createDetachedClone(request2);
                NetworkResponse generatedResponse = VirtualNetworkMessageChannel.this.receivingRawEndpointHandler.onRawRequestReceived(clonedRequest, virtualSenderId);
                NetworkResponseImpl clonedResponse = VirtualNetworkMessageChannel.this.createDetachedClone(generatedResponse);
                responseHandler2.onResponseAvailable(clonedResponse);
                return clonedResponse;
            }
        };
        this.threadPool.submit((Callable)task);
    }

    @Override
    protected void onClosedOrBroken() {
        this.log.debug((Object)("Closing connection " + this + " (remote=" + this.getRemoteNodeInformation().getLogDescription() + ", NCP=" + this.associatedSCP));
        if (this.getState() == MessageChannelState.CLOSED) {
            if (this.isSimulatingBreakdown()) {
                this.log.debug((Object)("Simulating breakdown of virtual channel " + this.getChannelId() + "; not sending shutdown message"));
                return;
            }
            if (this.associatedSCP.isSimulatingBreakdown()) {
                this.log.debug((Object)(this.associatedSCP + " is simulating breakdown; not sending shutdown message for channel " + this.getChannelId()));
                return;
            }
            this.receivingRawEndpointHandler.onInboundChannelClosing(this.getChannelId());
        }
    }

    private NetworkResponseImpl createDetachedClone(NetworkResponse response) throws SerializationException {
        Map<String, String> clonedResponseMetaData = MessageMetaData.wrap(response.accessRawMetaData()).cloneData();
        byte[] originalContentBytes = response.getContentBytes();
        byte[] detachedContentBytes = null;
        if (originalContentBytes != null) {
            detachedContentBytes = Arrays.copyOf(originalContentBytes, originalContentBytes.length);
        }
        NetworkResponseImpl clonedResponse = new NetworkResponseImpl(detachedContentBytes, clonedResponseMetaData);
        return clonedResponse;
    }
}

