/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.xml.loader.gui.properties;

import de.rcenvironment.components.xml.loader.gui.properties.Messages;
import de.rcenvironment.core.gui.utils.common.components.PropertyTabGuiHelper;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class XmlLoaderComponentSection
extends ValidatingWorkflowNodePropertySection {
    private static final int MINIMUM_HEIGHT_OF_FILE_CONTENT_TEXT = 300;
    private Button fileChooser;
    private Text fileContentText;
    private WorkflowNodePropertySection.LayoutComposite content;

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        TabbedPropertySheetWidgetFactory toolkit = aTabbedPropertySheetPage.getWidgetFactory();
        this.content = new WorkflowNodePropertySection.LayoutComposite(parent);
        this.content.setLayout((Layout)new FillLayout());
        this.content.setData("property.control", (Object)"xmlContent");
        this.initFileChoosingSection(toolkit, (Composite)this.content);
    }

    private void initFileChoosingSection(TabbedPropertySheetWidgetFactory toolkit, Composite container) {
        Section section = toolkit.createSection(container, 256);
        section.setText(Messages.fileChoosingSectionName);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)new GridLayout());
        this.fileChooser = toolkit.createButton(client, Messages.fileLinkButtonLabel, 8);
        toolkit.createCLabel(client, Messages.actuallyLoadedLabel);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 300;
        this.fileContentText = toolkit.createText(client, "", 768);
        this.fileContentText.setEditable(false);
        this.fileContentText.setLayoutData((Object)gridData);
        section.setClient((Control)client);
    }

    protected void refreshBeforeValidation() {
        this.setXMLContent();
    }

    private void setXMLContent() {
        if (this.getProperty("xmlContent") != null) {
            this.fileContentText.setText(this.getProperty("xmlContent"));
        }
    }

    protected WorkflowNodePropertySection.Controller createController() {
        return new FileController();
    }

    protected WorkflowNodePropertySection.Updater createUpdater() {
        return new XmlLoaderComponentSectionUpdater();
    }

    private final class FileController
    extends WorkflowNodePropertySection.DefaultController {
        private FileController() {
            super((WorkflowNodePropertySection)XmlLoaderComponentSection.this);
        }

        protected void widgetSelected(SelectionEvent event, Control source) {
            super.widgetSelected(event, source);
            if (source == XmlLoaderComponentSection.this.fileChooser) {
                this.fileChoosing();
            }
        }

        private void fileChoosing() {
            IFile file = PropertyTabGuiHelper.selectFileFromProjects((Shell)XmlLoaderComponentSection.this.content.getShell(), (String)Messages.loadTitle, (String)Messages.loadMessage);
            if (file != null) {
                StringWriter writer = new StringWriter();
                try {
                    IOUtils.copy((InputStream)file.getContents(), (Writer)writer);
                    String theString = writer.toString();
                    XmlLoaderComponentSection.this.setProperty("xmlContent", theString);
                }
                catch (IOException | CoreException e) {
                    XmlLoaderComponentSection.this.logger.error((Object)"Cannot read content from file.", e);
                }
                XmlLoaderComponentSection.this.setXMLContent();
            }
        }
    }

    protected class XmlLoaderComponentSectionUpdater
    extends WorkflowNodePropertySection.DefaultUpdater {
        protected XmlLoaderComponentSectionUpdater() {
            super((WorkflowNodePropertySection)XmlLoaderComponentSection.this);
        }

        public void updateControl(Control control, String propertyName, String newValue, String oldValue) {
            super.updateControl(control, propertyName, newValue, oldValue);
            if (propertyName.equals("xmlContent")) {
                if (newValue == null) {
                    XmlLoaderComponentSection.this.fileContentText.setText("");
                } else {
                    XmlLoaderComponentSection.this.fileContentText.setText(newValue);
                }
            }
        }
    }
}

