/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.management.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.authorization.api.AuthorizationAccessGroupKeyData;
import de.rcenvironment.core.authorization.api.AuthorizationPermissionSet;
import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.authorization.cryptography.api.CryptographyOperationsProvider;
import de.rcenvironment.core.authorization.cryptography.api.SymmetricKey;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.management.internal.ComponentPublicationException;
import de.rcenvironment.core.component.management.internal.DistributedComponentEntryImpl;
import de.rcenvironment.core.component.management.utils.JsonDataEncryptionUtils;
import de.rcenvironment.core.component.management.utils.JsonDataWithOptionalEncryption;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.impl.ComponentInstallationImpl;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.LogFactory;

public final class ComponentDataConverter {
    private static final ObjectMapper sharedJsonMapper = JsonUtils.getDefaultObjectMapper();

    private ComponentDataConverter() {
    }

    public static String serializeComponentInstallationData(ComponentInstallation ci) {
        try {
            return sharedJsonMapper.writeValueAsString((Object)ci);
        }
        catch (IOException e) {
            throw new ComponentPublicationException("Error serializing component descriptor", e);
        }
    }

    public static ComponentInstallation deserializeComponentInstallationData(String jsonData) throws OperationFailureException {
        try {
            return (ComponentInstallation)sharedJsonMapper.readValue(jsonData, ComponentInstallationImpl.class);
        }
        catch (IOException e) {
            throw new OperationFailureException("Error deserializing component descriptor from JSON data: " + jsonData, (Throwable)e);
        }
    }

    public static DistributedComponentEntryImpl createLocalDistributedComponentEntry(ComponentInstallation componentInstallation, AuthorizationPermissionSet permissionSet, AuthorizationService authorizationService) {
        if (permissionSet == null || permissionSet.isLocalOnly()) {
            return new DistributedComponentEntryImpl(componentInstallation.getComponentInterface().getDisplayName(), componentInstallation, permissionSet, permissionSet, false, null);
        }
        try {
            JsonDataWithOptionalEncryption transferObject;
            String rawComponentData = ComponentDataConverter.serializeComponentInstallationData(componentInstallation);
            if (permissionSet.isPublic()) {
                transferObject = JsonDataEncryptionUtils.asPublicData(ComponentDataConverter.serializeComponentInstallationData(componentInstallation));
            } else {
                HashMap<String, SymmetricKey> keyData = new HashMap<String, SymmetricKey>();
                for (AuthorizationAccessGroup group : permissionSet.getAccessGroups()) {
                    AuthorizationAccessGroupKeyData keyDataForGroup = authorizationService.getKeyDataForGroup(group);
                    if (keyDataForGroup == null) {
                        LogFactory.getLog(ComponentDataConverter.class).warn((Object)("Found no key data for assigned access group " + group.getFullId() + " when creating publication data for " + componentInstallation.getInstallationId() + "; skipping group"));
                        continue;
                    }
                    keyData.put(group.getFullId(), keyDataForGroup.getSymmetricKey());
                }
                transferObject = JsonDataEncryptionUtils.encryptForKeys(rawComponentData, keyData, authorizationService.getCryptographyOperationsProvider());
            }
            String serializedForm = sharedJsonMapper.writeValueAsString((Object)transferObject);
            return new DistributedComponentEntryImpl(componentInstallation.getComponentInterface().getDisplayName(), componentInstallation, permissionSet, permissionSet, false, serializedForm);
        }
        catch (OperationFailureException | IOException e) {
            throw new ComponentPublicationException("Error serializing component descriptor", e);
        }
    }

    public static DistributedComponentEntry deserializeRemoteDistributedComponentEntry(String jsonData, AuthorizationService authorizationService) throws OperationFailureException {
        String displayName;
        ComponentInstallation componentInstallation;
        AuthorizationPermissionSet matchingPermissionSet;
        AuthorizationPermissionSet declaredPermissionSet;
        JsonDataWithOptionalEncryption transferObject;
        try {
            transferObject = (JsonDataWithOptionalEncryption)sharedJsonMapper.readValue(jsonData, JsonDataWithOptionalEncryption.class);
        }
        catch (IOException e) {
            throw new OperationFailureException("Error deserializing component entry from JSON data: " + jsonData, (Throwable)e);
        }
        if (JsonDataEncryptionUtils.isPublic(transferObject)) {
            matchingPermissionSet = declaredPermissionSet = authorizationService.getDefaultAuthorizationObjects().permissionSetPublicInLocalNetwork();
            componentInstallation = ComponentDataConverter.deserializeComponentInstallationData(JsonDataEncryptionUtils.getPublicData(transferObject));
            displayName = componentInstallation.getComponentInterface().getDisplayName();
        } else {
            Set<String> declaredGroupIds = JsonDataEncryptionUtils.getKeyIds(transferObject);
            Set declaredGroups = authorizationService.representRemoteGroupIds(declaredGroupIds);
            Set matchingGroups = authorizationService.intersectWithAccessibleGroups(declaredGroups);
            declaredPermissionSet = authorizationService.buildPermissionSet((Collection)declaredGroups);
            matchingPermissionSet = authorizationService.buildPermissionSet((Collection)matchingGroups);
            if (!matchingPermissionSet.isLocalOnly()) {
                CryptographyOperationsProvider cryptographyOperations = authorizationService.getCryptographyOperationsProvider();
                AuthorizationAccessGroup groupForDecryption = matchingPermissionSet.getArbitraryGroup();
                String groupId = groupForDecryption.getFullId();
                SymmetricKey groupKey = authorizationService.getKeyDataForGroup(groupForDecryption).getSymmetricKey();
                String decryptedComponentData = JsonDataEncryptionUtils.attemptDecryption(transferObject, groupId, groupKey, cryptographyOperations);
                componentInstallation = ComponentDataConverter.deserializeComponentInstallationData(decryptedComponentData);
                displayName = componentInstallation.getComponentInterface().getDisplayName();
            } else {
                componentInstallation = null;
                displayName = "Inaccessible component";
            }
        }
        return new DistributedComponentEntryImpl(displayName, componentInstallation, declaredPermissionSet, matchingPermissionSet, true, null);
    }
}

