/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.internal;

import de.rcenvironment.core.component.api.UserComponentIdMappingService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;

@Component
public final class UserComponentIdMappingServiceImpl
implements UserComponentIdMappingService {
    private static final String SINGLE_QUOTE = "'";
    private static final String DOLLAR = ")$";
    private static final String BUILTIN_COMPONENTS_TYPE_PREFIX = "rce";
    private static final String RA_COMPONENTS_TYPE_PREFIX = "ssh";
    private static final String VALID_INTEGRATED_TOOL_ID_REGEXP = "[^/]+";
    private static final Pattern BUILTIN_COMPONENTS_EXTERNAL = Pattern.compile("^rce/([\\w ]+)$");
    private static final Pattern RA_COMPONENTS_EXTERNAL = Pattern.compile("^ssh/([\\w ]+)$");
    private static final Pattern INTEGRATED_TOOLS_EXTERNAL = Pattern.compile("^(\\w+)/([^/]+)$");
    private static final Pattern BUILTIN_COMPONENTS_INTERNAL = Pattern.compile("^de\\.rcenvironment\\.(\\w+(?:\\.\\w+)?)$");
    private static final Pattern RA_COMPONENTS_INTERNAL = Pattern.compile("^de\\.rcenvironment\\.remoteaccess\\.([^/]+)$");
    private static final Pattern INTEGRATED_TOOLS_INTERNAL = Pattern.compile("^de\\.rcenvironment\\.integration\\.(\\w+)\\.([^/]+)$");
    private final Map<String, String> builtinComponentNamesByInternalId = Collections.synchronizedMap(new HashMap());
    private final Map<String, String> builtinComponentInternalIdsByName = Collections.synchronizedMap(new HashMap());

    @Override
    public String fromExternalToInternalId(String input) throws OperationFailureException {
        Matcher matcher = RA_COMPONENTS_EXTERNAL.matcher(input);
        if (matcher.matches()) {
            String name = matcher.group(1);
            return StringUtils.format((String)"de.rcenvironment.remoteaccess.%s", (Object[])new Object[]{name});
        }
        matcher = BUILTIN_COMPONENTS_EXTERNAL.matcher(input);
        if (matcher.matches()) {
            String extId = matcher.group(1);
            String intId = this.builtinComponentInternalIdsByName.get(extId);
            if (intId == null) {
                throw new OperationFailureException("Found no built-in component matching '" + input + SINGLE_QUOTE);
            }
            return intId;
        }
        matcher = INTEGRATED_TOOLS_EXTERNAL.matcher(input);
        if (matcher.matches()) {
            String type = matcher.group(1);
            String name = matcher.group(2);
            return StringUtils.format((String)"de.rcenvironment.integration.%s.%s", (Object[])new Object[]{type, name});
        }
        throw new OperationFailureException("Unrecognized component/tool id format '" + input + SINGLE_QUOTE);
    }

    @Override
    public String fromInternalToExternalId(String input) throws OperationFailureException {
        Matcher matcher = RA_COMPONENTS_INTERNAL.matcher(input);
        if (matcher.matches()) {
            String name = matcher.group(1);
            return StringUtils.format((String)"ssh/%s", (Object[])new Object[]{name});
        }
        matcher = BUILTIN_COMPONENTS_INTERNAL.matcher(input);
        if (matcher.matches()) {
            String name = this.builtinComponentNamesByInternalId.get(input);
            if (name == null) {
                throw new OperationFailureException("Found no built-in component matching '" + input + SINGLE_QUOTE);
            }
            return StringUtils.format((String)"rce/%s", (Object[])new Object[]{name});
        }
        matcher = INTEGRATED_TOOLS_INTERNAL.matcher(input);
        if (matcher.matches()) {
            String type = matcher.group(1);
            String name = matcher.group(2);
            return StringUtils.format((String)"%s/%s", (Object[])new Object[]{type, name});
        }
        throw new OperationFailureException("Unrecognized internal component/tool id format '" + input + SINGLE_QUOTE);
    }

    @Override
    public void registerBuiltinComponentMapping(String intId, String name) {
        LogFactory.getLog(this.getClass()).debug((Object)StringUtils.format((String)"Registered built-in mapping from component id '%s' to name '%s'", (Object[])new Object[]{intId, name}));
        this.builtinComponentInternalIdsByName.put(name, intId);
        this.builtinComponentNamesByInternalId.put(intId, name);
    }
}

