/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.internal;

import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.component.execution.api.EndpointDatumSerializer;
import de.rcenvironment.core.component.execution.internal.InternalTDImpl;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDatum;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDatumRecipient;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDatumRecipientFactory;
import de.rcenvironment.core.component.model.endpoint.impl.EndpointDatumImpl;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.utils.common.StringUtils;

public class EndpointDatumSerializerImpl
implements EndpointDatumSerializer {
    private TypedDatumSerializer typedDatumSerializer;

    @Override
    public String serializeEndpointDatum(EndpointDatum endpoint) {
        TypedDatum value;
        String[] parts = new String[]{endpoint.getInputName(), (value = endpoint.getValue()).getDataType().equals((Object)DataType.Internal) ? ((InternalTDImpl)value).serialize() : this.typedDatumSerializer.serialize(value), endpoint.getInputsComponentExecutionIdentifier(), endpoint.getInputsComponentInstanceName(), endpoint.getDestinationNodeId().getLogicalNodeIdString(), endpoint.getOutputsComponentExecutionIdentifier(), endpoint.getOutputsNodeId().getLogicalNodeIdString(), endpoint.getWorkflowExecutionIdentifier(), endpoint.getWorkflowControllerLocation().getLogicalNodeIdString(), endpoint.getDataManagementId() == null ? "" : String.valueOf(endpoint.getDataManagementId())};
        return StringUtils.escapeAndConcat((String[])parts);
    }

    @Override
    public EndpointDatum deserializeEndpointDatum(String serializedEndpoint) {
        String[] parts = StringUtils.splitAndUnescape((String)serializedEndpoint);
        EndpointDatumImpl endpoint = new EndpointDatumImpl();
        InternalTDImpl typedDatum = InternalTDImpl.fromString(parts[1]);
        if (typedDatum == null) {
            typedDatum = this.typedDatumSerializer.deserialize(parts[1]);
        }
        endpoint.setValue((TypedDatum)typedDatum);
        EndpointDatumRecipient endpointDatumRecipient = EndpointDatumRecipientFactory.createEndpointDatumRecipient(parts[0], parts[2], parts[3], NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)parts[4]));
        endpoint.setEndpointDatumRecipient(endpointDatumRecipient);
        endpoint.setOutputsComponentExecutionIdentifier(parts[5]);
        endpoint.setOutputsNodeId(NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)parts[6]));
        endpoint.setWorkflowExecutionIdentifier(parts[7]);
        endpoint.setWorkflowNodeId(NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)parts[8]));
        if (!parts[9].isEmpty()) {
            endpoint.setDataManagementId(Long.valueOf(parts[9]));
        }
        return endpoint;
    }

    protected void bindTypedDatumService(TypedDatumService typedDatumService) {
        this.typedDatumSerializer = typedDatumService.getSerializer();
    }
}

