/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.internal;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.execution.api.ComponentExecutionContext;
import de.rcenvironment.core.component.execution.api.ComponentExecutionControllerService;
import de.rcenvironment.core.component.execution.api.ComponentExecutionException;
import de.rcenvironment.core.component.execution.api.ComponentExecutionInformation;
import de.rcenvironment.core.component.execution.api.ComponentExecutionService;
import de.rcenvironment.core.component.execution.api.ComponentState;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.execution.api.RemotableComponentExecutionControllerService;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncExceptionListener;
import de.rcenvironment.toolkit.modules.concurrency.api.CallablesGroup;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComponentExecutionServiceImpl
implements ComponentExecutionService {
    private static final int RATE_LIMITING_DEFAULT_MAX_CONCURRENT_REQUESTS_PER_NODE = 1;
    private static final int RATE_LIMITING_DEFAULT_MAX_GLOBAL_CONCURRENT_REQUESTS = 2;
    private static final String RATE_LIMITING_SYSTEM_PROPERTY_MAX_CONCURRENT_REQUESTS_PER_NODE = "rce.maxComponentInitRequestsPerNode";
    private static final String RATE_LIMITING_SYSTEM_PROPERTY_MAX_GLOBAL_CONCURRENT_REQUESTS = "rce.maxGlobalComponentInitRequests";
    private static final long RATE_LIMITING_RETRY_INTERVAL_MSEC = 250L;
    private CommunicationService communicationService;
    private ComponentExecutionControllerService cmpExeCtrlService;
    private PlatformService platformService;
    private final ComponentInitializationRateLimiter rateLimiter = new ComponentInitializationRateLimiter();
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public String init(ComponentExecutionContext executionContext, String authToken, Long referenceTimestamp) throws ComponentExecutionException {
        LogicalNodeId remoteNodeId = executionContext.getNodeId();
        boolean wasDelayedAtLeastOnce = false;
        while (!this.rateLimiter.acquirePermission(remoteNodeId)) {
            if (!wasDelayedAtLeastOnce) {
                this.log.debug((Object)StringUtils.format((String)"Delaying initialization of component %s on node %s for rate limiting", (Object[])new Object[]{executionContext.getExecutionIdentifier(), remoteNodeId}));
                wasDelayedAtLeastOnce = true;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ComponentExecutionException("Interrupted while waiting for rate limiting permission: " + e.toString());
            }
        }
        if (wasDelayedAtLeastOnce) {
            this.log.debug((Object)StringUtils.format((String)"Performing initialization of component %s on node %s after waiting for rate limiting", (Object[])new Object[]{executionContext.getExecutionIdentifier(), remoteNodeId}));
        } else {
            this.log.debug((Object)StringUtils.format((String)"Performing immediate initialization of component %s on node %s (no rate limiting required)", (Object[])new Object[]{executionContext.getExecutionIdentifier(), remoteNodeId}));
        }
        try {
            if (authToken == null) {
                throw new ComponentExecutionException("Received a 'null' authorization token for component execution " + executionContext.getExecutionIdentifier());
            }
            String string = this.getExecutionControllerService((NetworkDestination)remoteNodeId).createExecutionController(executionContext, authToken, referenceTimestamp);
            return string;
        }
        catch (RemoteOperationException e) {
            throw new ComponentExecutionException("Error initiating component " + executionContext.getExecutionIdentifier() + " for execution", e);
        }
        finally {
            this.rateLimiter.releasePermission(remoteNodeId);
        }
    }

    @Override
    public void pause(String executionId, NetworkDestination node) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionControllerService(node).performPause(executionId);
    }

    @Override
    public void resume(String executionId, NetworkDestination node) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionControllerService(node).performResume(executionId);
    }

    @Override
    public void cancel(String executionId, NetworkDestination node) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionControllerService(node).performCancel(executionId);
    }

    @Override
    public void dispose(String executionId, NetworkDestination node) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionControllerService(node).performDispose(executionId);
    }

    @Override
    public void prepare(String executionId, NetworkDestination node) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionControllerService(node).performPrepare(executionId);
    }

    @Override
    public void start(String executionId, NetworkDestination node) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionControllerService(node).performStart(executionId);
    }

    @Override
    public ComponentState getComponentState(String executionId, ResolvableNodeId node) throws ExecutionControllerException, RemoteOperationException {
        return this.getExecutionControllerService((NetworkDestination)node).getComponentState(executionId);
    }

    @Override
    public ComponentExecutionInformation getComponentExecutionInformation(final String verificationToken) throws RemoteOperationException {
        final AtomicReference<Object> remoteOperationExceptionRef = new AtomicReference<Object>(null);
        CallablesGroup callablesGroup = ConcurrencyUtils.getFactory().createCallablesGroup(ComponentExecutionInformation.class);
        Iterator iterator = this.communicationService.getReachableLogicalNodes().iterator();
        while (iterator.hasNext()) {
            LogicalNodeId logicalNodeId;
            final LogicalNodeId nodeId = logicalNodeId = (LogicalNodeId)iterator.next();
            callablesGroup.add((Callable)new Callable<ComponentExecutionInformation>(){

                @Override
                @TaskDescription(value="Fetching component information")
                public ComponentExecutionInformation call() throws Exception {
                    ComponentExecutionInformation compExeInfo = ComponentExecutionServiceImpl.this.getExecutionControllerService((NetworkDestination)nodeId).getComponentExecutionInformation(verificationToken);
                    if (compExeInfo != null) {
                        return compExeInfo;
                    }
                    return null;
                }
            });
            List compExeInfos = callablesGroup.executeParallel(new AsyncExceptionListener(){

                public void onAsyncException(Exception e) {
                    if (e instanceof RemoteOperationException && remoteOperationExceptionRef.get() == null) {
                        remoteOperationExceptionRef.set((RemoteOperationException)((Object)e));
                    }
                    LogFactory.getLog(ComponentExecutionServiceImpl.class).error((Object)"Error in asychronous request when retrieving component execution information for a verification key", (Throwable)e);
                }
            });
            if (remoteOperationExceptionRef.get() != null) {
                throw (RemoteOperationException)remoteOperationExceptionRef.get();
            }
            for (ComponentExecutionInformation compExeInfo : compExeInfos) {
                if (compExeInfo == null) continue;
                return compExeInfo;
            }
        }
        return null;
    }

    @Override
    public boolean verifyResults(String executionId, ResolvableNodeId node, String verificationToken, boolean verified) throws ExecutionControllerException, RemoteOperationException {
        return this.getExecutionControllerService((NetworkDestination)node).performVerifyResults(executionId, verificationToken, verified);
    }

    @Override
    public Set<ComponentExecutionInformation> getLocalComponentExecutionInformations() {
        return new HashSet<ComponentExecutionInformation>(this.cmpExeCtrlService.getComponentExecutionInformations());
    }

    private RemotableComponentExecutionControllerService getExecutionControllerService(NetworkDestination destination) {
        if (destination instanceof ResolvableNodeId && this.platformService.matchesLocalInstance((ResolvableNodeId)destination)) {
            return this.cmpExeCtrlService;
        }
        return (RemotableComponentExecutionControllerService)this.communicationService.getRemotableService(RemotableComponentExecutionControllerService.class, destination);
    }

    protected void bindCommunicationService(CommunicationService newService) {
        this.communicationService = newService;
    }

    protected void bindPlatformService(PlatformService newService) {
        this.platformService = newService;
    }

    protected void bindComponentExecutionControllerService(ComponentExecutionControllerService newService) {
        this.cmpExeCtrlService = newService;
    }

    protected class ComponentInitializationRateLimiter {
        private final Log log;
        private int globalPendingRequestCount = 0;
        private final int maxConcurrentRequestsPerNode;
        private final int maxGlobalConcurrentRequests;
        private final Map<LogicalNodeId, Integer> requestCountPerNode = new HashMap<LogicalNodeId, Integer>();

        public ComponentInitializationRateLimiter() {
            this.log = LogFactory.getLog(this.getClass());
            this.maxConcurrentRequestsPerNode = this.parsePotentialOverrideProperty(ComponentExecutionServiceImpl.RATE_LIMITING_SYSTEM_PROPERTY_MAX_CONCURRENT_REQUESTS_PER_NODE, 1);
            this.maxGlobalConcurrentRequests = this.parsePotentialOverrideProperty(ComponentExecutionServiceImpl.RATE_LIMITING_SYSTEM_PROPERTY_MAX_GLOBAL_CONCURRENT_REQUESTS, 2);
            this.log.debug((Object)("Component initialization limits set to " + this.maxConcurrentRequestsPerNode + " concurrent requests per node and " + this.maxGlobalConcurrentRequests + " concurrent global requests"));
        }

        synchronized boolean acquirePermission(LogicalNodeId nodeId) {
            if (ComponentExecutionServiceImpl.this.platformService.matchesLocalInstance((ResolvableNodeId)nodeId)) {
                return true;
            }
            if (this.globalPendingRequestCount >= this.maxGlobalConcurrentRequests) {
                return false;
            }
            Integer currentWrapper = this.requestCountPerNode.get(nodeId);
            int oldValue = currentWrapper != null ? currentWrapper : 0;
            if (oldValue >= this.maxConcurrentRequestsPerNode) {
                return false;
            }
            this.requestCountPerNode.put(nodeId, oldValue + 1);
            ++this.globalPendingRequestCount;
            return true;
        }

        synchronized void releasePermission(LogicalNodeId nodeId) {
            if (ComponentExecutionServiceImpl.this.platformService.matchesLocalInstance((ResolvableNodeId)nodeId)) {
                return;
            }
            Integer removedValue = this.requestCountPerNode.remove(nodeId);
            if (removedValue == null) {
                throw new IllegalStateException("Per-node request counter reduced below zero");
            }
            int oldValue = removedValue;
            if (oldValue < 1) {
                throw new IllegalStateException("Request counter map contained a stored value below 1");
            }
            if (oldValue > 1) {
                this.requestCountPerNode.put(nodeId, oldValue - 1);
            }
            if (--this.globalPendingRequestCount < 0) {
                throw new IllegalStateException("Global request counter reduced below zero");
            }
        }

        private int parsePotentialOverrideProperty(String propertyKey, int defaultValue) {
            int finalValue;
            String sysPropertyValue = System.getProperty(propertyKey);
            if (sysPropertyValue != null && !sysPropertyValue.isEmpty()) {
                try {
                    finalValue = Integer.parseInt(sysPropertyValue);
                }
                catch (NumberFormatException e) {
                    this.log.error((Object)("Invalid value for " + propertyKey), (Throwable)e);
                    finalValue = defaultValue;
                }
            } else {
                finalValue = defaultValue;
            }
            return finalValue;
        }
    }
}

