/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.internal;

import de.rcenvironment.core.component.execution.api.ComponentExecutionContext;
import de.rcenvironment.core.component.execution.api.ComponentExecutionException;
import de.rcenvironment.core.component.execution.api.ComponentExecutionIdentifier;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionRelatedInstances;
import de.rcenvironment.core.component.execution.internal.ComponentStateMachineEvent;
import de.rcenvironment.core.component.execution.internal.ComponentStateMachineEventType;
import de.rcenvironment.core.component.execution.internal.InternalTDImpl;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDatum;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.model.endpoint.api.EndpointGroupDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointGroupDescription;
import de.rcenvironment.core.component.model.endpoint.impl.EndpointDatumImpl;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumConverter;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.NotAValueTD;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.LogFactory;

public class ComponentExecutionScheduler {
    private static TypedDatumFactory typedDatumFactory;
    private static TypedDatumConverter typedDatumConverter;
    private ComponentExecutionRelatedInstances compExeRelatedInstances;
    private final Deque<EndpointDatum> validatedEndpointDatumsToProcess = new LinkedList<EndpointDatum>();
    private final Map<String, DataType> endpointDataTypes = new HashMap<String, DataType>();
    private final Map<String, EndpointGroupDescription> endpointGroupDescriptions = new HashMap<String, EndpointGroupDescription>();
    private final Map<String, EndpointDatum> inputsOccupied = Collections.synchronizedMap(new HashMap());
    private final Map<String, Deque<EndpointDatum>> endpointDatums = new HashMap<String, Deque<EndpointDatum>>();
    private final Set<String> queuedConsumingInputs = new HashSet<String>();
    private final Set<String> consumingInputs = new HashSet<String>();
    private final Set<String> constantInputs = new HashSet<String>();
    private final Set<String> constantInputsProcessed = Collections.synchronizedSet(new HashSet());
    private final Set<String> requiredInputsOrGroups = new HashSet<String>();
    private final Set<String> notRequiredInputs = new HashSet<String>();
    private final Set<String> inputsWithValue = new HashSet<String>();
    private final Map<String, Set<String>> groups = new HashMap<String, Set<String>>();
    private final Set<String> finishedInputs = new HashSet<String>();
    private final Map<String, Set<String>> idsOfNotAValueDatumsReceived = new HashMap<String, Set<String>>();
    private final Set<String> idsNotAValueDatumsSent = Collections.synchronizedSet(new HashSet());
    private final AtomicBoolean loopResetRequested = new AtomicBoolean(false);
    private final Set<String> resetDataIdsSent = Collections.synchronizedSet(new HashSet());
    private final AtomicBoolean loopReset = new AtomicBoolean(false);
    private final AtomicReference<EndpointDatum> resetDatumToFoward = new AtomicReference<Object>(null);
    private final AtomicReference<EndpointDatum> failureDatumToFoward = new AtomicReference<Object>(null);
    private int inputsCount = 0;
    private Set<String> inputsConsideredForFinished = new HashSet<String>();
    private AtomicReference<State> state = new AtomicReference<State>(State.IDLING);
    private boolean isEnabled = false;
    private volatile boolean schedulingFailed = false;

    @Deprecated
    public ComponentExecutionScheduler() {
    }

    protected ComponentExecutionScheduler(ComponentExecutionRelatedInstances compExeRelatedInstances) {
        this.compExeRelatedInstances = compExeRelatedInstances;
    }

    protected void initialize(ComponentExecutionContext compExeContext) throws ComponentExecutionException {
        EndpointDescriptionsManager inputDescriptionsManager = compExeContext.getComponentDescription().getInputDescriptionsManager();
        for (EndpointGroupDescription groupDescription : inputDescriptionsManager.getEndpointGroupDescriptions()) {
            this.endpointGroupDescriptions.put(groupDescription.getName(), groupDescription);
        }
        int inputsOuterCount = 0;
        HashSet<String> inputsSame = new HashSet<String>();
        for (EndpointDescription endpointDescription : inputDescriptionsManager.getEndpointDescriptions()) {
            switch (endpointDescription.getEndpointDefinition().getEndpointCharacter()) {
                case OUTER_LOOP: {
                    ++inputsOuterCount;
                    break;
                }
                case SAME_LOOP: {
                    inputsSame.add(endpointDescription.getName());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Endpoint type unknown: " + endpointDescription.getEndpointDefinition().getEndpointCharacter());
                }
            }
            this.endpointDataTypes.put(endpointDescription.getName(), endpointDescription.getDataType());
            this.endpointDatums.put(endpointDescription.getName(), new LinkedList());
            Map<String, String> metaData = endpointDescription.getMetaData();
            String inputHandling = metaData.get("inputHandling_73b1056e");
            if (inputHandling == null) {
                inputHandling = endpointDescription.getEndpointDefinition().getDefaultInputDatumHandling().name();
            }
            if (inputHandling.equals(EndpointDefinition.InputDatumHandling.Constant.name())) {
                this.constantInputs.add(endpointDescription.getName());
            } else {
                this.consumingInputs.add(endpointDescription.getName());
                if (inputHandling.equals(EndpointDefinition.InputDatumHandling.Queue.name())) {
                    this.queuedConsumingInputs.add(endpointDescription.getName());
                }
            }
            String inputExecutionConstraint = metaData.get("inputExecutionConstraint_4aae3eea");
            if (inputExecutionConstraint == null) {
                inputExecutionConstraint = endpointDescription.getEndpointDefinition().getDefaultInputExecutionConstraint().name();
            }
            if (inputExecutionConstraint.equals(EndpointDefinition.InputExecutionContraint.RequiredIfConnected.name())) {
                if (!endpointDescription.isConnected()) continue;
                this.addToRequiredInputsOrGroups(inputDescriptionsManager, endpointDescription);
                continue;
            }
            if (inputExecutionConstraint.equals(EndpointDefinition.InputExecutionContraint.None.name())) {
                if (endpointDescription.getParentGroupName() == null) {
                    throw new ComponentExecutionException(StringUtils.format((String)"Input '%s' of component '%s' is declared as not required, but it is not part of an input group of type 'or'", (Object[])new Object[]{endpointDescription.getName(), compExeContext.getInstanceName()}));
                }
                if (!endpointDescription.isConnected()) continue;
                this.addToRequiredInputsOrGroups(inputDescriptionsManager, endpointDescription);
                continue;
            }
            if (inputExecutionConstraint.equals(EndpointDefinition.InputExecutionContraint.NotRequired.name())) {
                if (!endpointDescription.isConnected()) continue;
                this.addToNotRequiredInputs(endpointDescription);
                continue;
            }
            if (!endpointDescription.isConnected()) {
                throw new ComponentExecutionException(StringUtils.format((String)"The execution constraint of input '%s' of component '%s' is declared as 'required', but the input is not connected to an output. Either connect it to an output or alter its execution constraint (e.g., to 'required if connected') or delete the input at all. Note: The two latter options might not be applicable in this particular case.", (Object[])new Object[]{endpointDescription.getName(), compExeContext.getInstanceName()}));
            }
            this.addToRequiredInputsOrGroups(inputDescriptionsManager, endpointDescription);
        }
        if (!this.isDriver(compExeContext) && inputsOuterCount > 0 || this.isNestedDriver(compExeContext)) {
            this.inputsConsideredForFinished.removeAll(inputsSame);
        }
    }

    boolean isNestedDriver(ComponentExecutionContext compExeContext) {
        return Boolean.valueOf(compExeContext.getComponentDescription().getConfigurationDescription().getConfigurationValue("isNestedLoop_5e0ed1cd"));
    }

    boolean isDriver(ComponentExecutionContext compExeContext) {
        return compExeContext.getComponentDescription().getComponentInterface().getIsLoopDriver();
    }

    protected synchronized void validateAndQueueEndpointDatum(EndpointDatum datum) {
        try {
            this.checkDataType(datum);
            this.checkIfConstantAndSingleConstraintIsMatched(datum);
            this.validatedEndpointDatumsToProcess.add(datum);
        }
        catch (ComponentExecutionException e) {
            this.postSchedulingFailedEvent(e);
            return;
        }
        if (this.isEnabled) {
            this.updateSchedulingState();
        }
    }

    private void postSchedulingFailedEvent(ComponentExecutionException e) {
        if (!this.schedulingFailed) {
            this.compExeRelatedInstances.compStateMachine.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.SCHEDULING_FAILED, e));
            this.schedulingFailed = true;
            this.isEnabled = false;
        }
    }

    private void postNewSchedulingStateEvent() {
        this.compExeRelatedInstances.compStateMachine.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.NEW_SCHEDULING_STATE));
        this.isEnabled = false;
    }

    protected synchronized boolean isEnabled() {
        return this.isEnabled;
    }

    protected synchronized void enable() {
        if (this.isEnabled) {
            LogFactory.getLog(this.getClass()).warn((Object)"Component execution scheduler was requested to get enabled even if it is already enabled; ignored enabling request");
            return;
        }
        this.setEnabled(true);
    }

    protected synchronized void disable() {
        this.setEnabled(false);
    }

    private void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        if (this.isEnabled) {
            this.updateSchedulingState();
        }
    }

    protected State getSchedulingState() {
        return this.state.get();
    }

    private void checkDataType(EndpointDatum endpointDatum) throws ComponentExecutionException {
        DataType sourceDataType = endpointDatum.getValue().getDataType();
        DataType targetDataType = this.endpointDataTypes.get(endpointDatum.getInputName());
        if (sourceDataType != DataType.Internal && sourceDataType != DataType.NotAValue && sourceDataType != targetDataType && !typedDatumConverter.isConvertibleTo(sourceDataType, targetDataType)) {
            throw new ComponentExecutionException(StringUtils.format((String)"Value of type '%s' at input '%s' received that is not convertible to expected data type '%s'", (Object[])new Object[]{sourceDataType, endpointDatum.getInputName(), targetDataType}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfConstantAndSingleConstraintIsMatched(EndpointDatum endpointDatum) throws ComponentExecutionException {
        if (endpointDatum.getValue().getDataType() != DataType.Internal) {
            Map<String, EndpointDatum> map = this.inputsOccupied;
            synchronized (map) {
                if (this.inputsOccupied.containsKey(endpointDatum.getInputName())) {
                    if (this.constantInputs.contains(endpointDatum.getInputName())) {
                        throw new ComponentExecutionException(StringUtils.format((String)"A second value at input '%s' of type 'constant' received. Only one value is allowed. First: %s. Second: %s. (Except in inner loops. There, one value is allowed for each inner loop run.)", (Object[])new Object[]{endpointDatum.getInputName(), this.inputsOccupied.get(endpointDatum.getInputName()), endpointDatum}));
                    }
                    if (!this.queuedConsumingInputs.contains(endpointDatum.getInputName())) {
                        throw new ComponentExecutionException(StringUtils.format((String)"A new value at input '%s' of type 'single' received, but the current one was not consumed yet. Current: %s. New: %s. Queue of values is not allowed at inputs of type 'single'. Use input type 'queue' if queuing is allowed and intended.", (Object[])new Object[]{endpointDatum.getInputName(), this.inputsOccupied.get(endpointDatum.getInputName()), endpointDatum}));
                    }
                } else if (this.constantInputs.contains(endpointDatum.getInputName()) || !this.queuedConsumingInputs.contains(endpointDatum.getInputName())) {
                    this.inputsOccupied.put(endpointDatum.getInputName(), endpointDatum);
                }
            }
        }
    }

    private void addToNotRequiredInputs(EndpointDescription endpointDescription) {
        this.increaseInputCount(endpointDescription);
        this.notRequiredInputs.add(endpointDescription.getName());
    }

    private void addToRequiredInputsOrGroups(EndpointDescriptionsManager endpointDescriptionsManager, EndpointDescription endpointDescription) {
        this.increaseInputCount(endpointDescription);
        if (endpointDescription.getParentGroupName() == null || endpointDescription.getParentGroupName().equals("null")) {
            this.requiredInputsOrGroups.add(endpointDescription.getName());
        } else {
            this.requiredInputsOrGroups.add(this.getTopLevelGroup(endpointDescriptionsManager, endpointDescription.getParentGroupName()));
            this.fillGroups(endpointDescriptionsManager, endpointDescription.getName(), endpointDescription.getParentGroupName());
        }
    }

    private void increaseInputCount(EndpointDescription endpointDescription) {
        ++this.inputsCount;
        this.inputsConsideredForFinished.add(endpointDescription.getName());
    }

    private void fillGroups(EndpointDescriptionsManager endpointDescriptionsManager, String inputOrGroupName, String groupName) {
        if (!this.groups.containsKey(groupName)) {
            this.groups.put(groupName, new HashSet());
        }
        this.groups.get(groupName).add(inputOrGroupName);
        if (endpointDescriptionsManager.getEndpointGroupDescription(groupName).getParentGroupName() != null) {
            this.fillGroups(endpointDescriptionsManager, groupName, endpointDescriptionsManager.getEndpointGroupDescription(groupName).getParentGroupName());
        }
    }

    private String getTopLevelGroup(EndpointDescriptionsManager endpointDescriptionsManager, String groupName) {
        if (endpointDescriptionsManager.getEndpointGroupDescription(groupName).getParentGroupName() != null) {
            return this.getTopLevelGroup(endpointDescriptionsManager, endpointDescriptionsManager.getEndpointGroupDescription(groupName).getParentGroupName());
        }
        return groupName;
    }

    private void updateSchedulingState() {
        try {
            State newState = this.calculateSchedulingState();
            while (!this.validatedEndpointDatumsToProcess.isEmpty() && newState == State.IDLING) {
                this.addEndpointDatum(this.validatedEndpointDatumsToProcess.poll());
                newState = this.calculateSchedulingState();
            }
            this.state.set(newState);
            if (newState != State.IDLING) {
                this.postNewSchedulingStateEvent();
            }
        }
        catch (ComponentExecutionException e) {
            this.postSchedulingFailedEvent(e);
        }
    }

    protected synchronized Map<String, EndpointDatum> fetchEndpointDatums() {
        HashMap<String, EndpointDatum> datums = new HashMap<String, EndpointDatum>();
        for (String inputName : this.inputsWithValue) {
            datums.put(inputName, this.getEndpointDatumReturnedForExecution(inputName));
        }
        for (String inputName : this.notRequiredInputs) {
            if (this.endpointDatums.get(inputName).isEmpty()) continue;
            datums.put(inputName, this.getEndpointDatumReturnedForExecution(inputName));
        }
        this.inputsWithValue.clear();
        return datums;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EndpointDatum getEndpointDatumReturnedForExecution(String inputName) {
        if (this.constantInputs.contains(inputName)) {
            this.constantInputsProcessed.add(inputName);
            return this.endpointDatums.get(inputName).peekFirst();
        }
        if (!this.queuedConsumingInputs.contains(inputName)) {
            Map<String, EndpointDatum> map = this.inputsOccupied;
            synchronized (map) {
                this.inputsOccupied.remove(inputName);
            }
        }
        EndpointDatum pollFirst = this.endpointDatums.get(inputName).pollFirst();
        return pollFirst;
    }

    protected InternalTDImpl getResetDatum() {
        InternalTDImpl resetDatum = (InternalTDImpl)this.resetDatumToFoward.get().getValue();
        this.resetDatumToFoward.set(null);
        return resetDatum;
    }

    protected InternalTDImpl getFailureDatum() {
        InternalTDImpl failureDatum = (InternalTDImpl)this.failureDatumToFoward.get().getValue();
        this.failureDatumToFoward.set(null);
        return failureDatum;
    }

    private void addEndpointDatum(EndpointDatum endpointDatum) throws ComponentExecutionException {
        this.performFirstSanityCheckForEndpointDatumAdded(endpointDatum);
        switch (endpointDatum.getValue().getDataType()) {
            case Internal: {
                this.handleInternalEndpointDatumAdded(endpointDatum);
                break;
            }
            default: {
                this.handleNonInternalEndpointDatumAdded(endpointDatum);
            }
        }
    }

    private void performFirstSanityCheckForEndpointDatumAdded(EndpointDatum endpointDatum) throws ComponentExecutionException {
        if (this.loopResetRequested.get() && (endpointDatum.getValue().getDataType() != DataType.Internal || ((InternalTDImpl)endpointDatum.getValue()).getType() != InternalTDImpl.InternalTDType.NestedLoopReset)) {
            if (endpointDatum.getValue().getDataType() == DataType.Internal) {
                throw new ComponentExecutionException(StringUtils.format((String)"Received input at '%s' of type 'Internal (Finished)', but component is waiting for datums of type 'Internal (Reset)'. Review the connections of your (nested) loop(s). Refer to the user guide if in doubt.", (Object[])new Object[]{endpointDatum.getInputName()}));
            }
            throw new ComponentExecutionException(StringUtils.format((String)"Received input at '%s' of type '%s', but component is waiting for datums of type 'Internal (Reset)'. Review the connections of your (nested) loop(s). Refer to the user guide if in doubt.", (Object[])new Object[]{endpointDatum.getInputName(), endpointDatum.getValue().getDataType().getDisplayName()}));
        }
    }

    private void handleInternalEndpointDatumAdded(EndpointDatum endpointDatum) throws ComponentExecutionException {
        InternalTDImpl internalDatum = (InternalTDImpl)endpointDatum.getValue();
        switch (internalDatum.getType()) {
            case WorkflowFinish: {
                this.finishedInputs.add(endpointDatum.getInputName());
                break;
            }
            case FailureInLoop: {
                if (internalDatum.getHopsToTraverse().isEmpty()) {
                    this.handleNonInternalEndpointDatumAdded(this.convertEndpointDatum(endpointDatum, Long.valueOf(internalDatum.getPayload())));
                    break;
                }
                if (!internalDatum.getHopsToTraverse().peek().getHopExecutionIdentifier().equals(new ComponentExecutionIdentifier(this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier()))) {
                    throw new ComponentExecutionException("Internal error: Received failure datum, but component is not the recipient, , there are still hops to traverse left: " + internalDatum.getHopsToTraverse());
                }
                this.failureDatumToFoward.set(endpointDatum);
                break;
            }
            case NestedLoopReset: {
                if (this.loopResetRequested.get()) {
                    if (!internalDatum.getHopsToTraverse().isEmpty()) {
                        LogFactory.getLog(this.getClass()).warn((Object)("Internal error: Initiated reset, received own reset datum, but component is not the final recipient, there are still hops to traverse left: " + internalDatum.getHopsToTraverse()));
                    }
                    if (!this.resetDataIdsSent.remove(internalDatum.getIdentifier())) {
                        throw new ComponentExecutionException(StringUtils.format((String)"Internal error: Received unexpected (wrong identifier) input at '%s' of type '%s'", (Object[])new Object[]{endpointDatum.getInputName(), endpointDatum.getValue().getDataType().getDisplayName()}));
                    }
                    if (!this.resetDataIdsSent.isEmpty()) break;
                    this.loopReset.set(true);
                    break;
                }
                if (internalDatum.getHopsToTraverse().isEmpty()) {
                    throw new ComponentExecutionException("Internal error: Received reset datum and component is the final recipient, but no loop reset was requested");
                }
                if (!internalDatum.getHopsToTraverse().peek().getHopExecutionIdentifier().equals(new ComponentExecutionIdentifier(this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier()))) {
                    throw new ComponentExecutionException("Internal error: Received reset datum, but component is not the final recipient; there are still hops to traverse left: " + internalDatum.getHopsToTraverse());
                }
                this.resetDatumToFoward.set(endpointDatum);
                break;
            }
        }
    }

    private EndpointDatum convertEndpointDatum(EndpointDatum endpointDatumToConvert, Long dmId) {
        EndpointDatumImpl endpointDatumToAdd = new EndpointDatumImpl();
        endpointDatumToAdd.setEndpointDatumRecipient(endpointDatumToConvert.getEndpointDatumRecipient());
        endpointDatumToAdd.setValue((TypedDatum)typedDatumFactory.createNotAValue(((InternalTDImpl)endpointDatumToConvert.getValue()).getIdentifier(), NotAValueTD.Cause.Failure));
        endpointDatumToAdd.setDataManagementId(dmId);
        endpointDatumToAdd.setWorkflowNodeId(endpointDatumToConvert.getWorkflowControllerLocation());
        endpointDatumToAdd.setOutputsComponentExecutionIdentifier(endpointDatumToConvert.getOutputsComponentExecutionIdentifier());
        endpointDatumToAdd.setOutputsNodeId(endpointDatumToConvert.getOutputsNodeId());
        endpointDatumToAdd.setWorkflowExecutionIdentifier(endpointDatumToConvert.getWorkflowExecutionIdentifier());
        return endpointDatumToAdd;
    }

    private void handleNonInternalEndpointDatumAdded(EndpointDatum endpointDatum) throws ComponentExecutionException {
        if (endpointDatum.getValue().getDataType().equals((Object)DataType.NotAValue)) {
            NotAValueTD datum = (NotAValueTD)endpointDatum.getValue();
            if (this.idsOfNotAValueDatumsReceived.containsKey(endpointDatum.getInputName()) && this.idsOfNotAValueDatumsReceived.get(endpointDatum.getInputName()).contains(datum.getIdentifier())) {
                throw new ComponentExecutionException("Internal error: Received 'not a value' datum twice I.e., no component handled it appropriately within this loop.");
            }
            if (this.idsNotAValueDatumsSent.contains(datum.getIdentifier())) {
                throw new ComponentExecutionException("Received own 'not a value' datum I.e., no component handled it appropriately within this loop; Review the components and connections of your (nested) loop(s). Refer to the user guide if in doubt.");
            }
            if (!this.idsOfNotAValueDatumsReceived.containsKey(endpointDatum.getInputName())) {
                this.idsOfNotAValueDatumsReceived.put(endpointDatum.getInputName(), new HashSet());
            }
            this.idsOfNotAValueDatumsReceived.get(endpointDatum.getInputName()).add(datum.getIdentifier());
        }
        this.finishedInputs.remove(endpointDatum.getInputName());
        this.endpointDatums.get(endpointDatum.getInputName()).add(endpointDatum);
    }

    protected void addNotAValueDatumSent(String identifier) {
        this.idsNotAValueDatumsSent.add(identifier);
    }

    protected void addResetDataIdSent(String identifier) {
        this.resetDataIdsSent.add(identifier);
        this.loopResetRequested.set(true);
    }

    protected boolean isLoopResetRequested() {
        return this.loopResetRequested.get();
    }

    private State calculateSchedulingState() throws ComponentExecutionException {
        State newState;
        if (this.isExecutable()) {
            newState = this.checkForNotAValueDatums();
        } else if (this.finishedInputs.containsAll(this.inputsConsideredForFinished)) {
            this.checkIfDatumAtConsumingInputsLeft();
            newState = State.FINISHED;
        } else if (this.resetDatumToFoward.get() != null) {
            this.checkIfDatumAtConsumingInputsLeft();
            this.resetConstantInputs();
            newState = State.RESET;
        } else if (this.failureDatumToFoward.get() != null) {
            newState = State.FAILURE_FORWARD;
        } else if (this.loopReset.get()) {
            this.loopReset.set(false);
            this.loopResetRequested.set(false);
            this.resetConstantInputs();
            newState = State.LOOP_RESET;
        } else {
            newState = State.IDLING;
        }
        return newState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetConstantInputs() {
        for (String constantInputName : this.constantInputs) {
            if (this.finishedInputs.contains(constantInputName)) continue;
            this.endpointDatums.get(constantInputName).clear();
            this.constantInputsProcessed.remove(constantInputName);
            Map<String, EndpointDatum> map = this.inputsOccupied;
            synchronized (map) {
                this.inputsOccupied.remove(constantInputName);
            }
        }
    }

    private void checkIfDatumAtConsumingInputsLeft() throws ComponentExecutionException {
        String logMessage = null;
        for (String inputName : this.endpointDatums.keySet()) {
            if (!this.consumingInputs.contains(inputName) || this.endpointDatums.get(inputName).isEmpty()) continue;
            StringBuilder strBuilder = new StringBuilder();
            for (EndpointDatum datum : this.endpointDatums.get(inputName)) {
                strBuilder.append(datum.getValue().toString());
                strBuilder.append(", ");
            }
            strBuilder.delete(strBuilder.length() - 3, strBuilder.length() - 1);
            logMessage = StringUtils.format((String)"Component is finished or reset, but there are values for input '%s' left that are not processed yet: %s", (Object[])new Object[]{inputName, strBuilder.toString()});
            if (this.notRequiredInputs.contains(inputName)) {
                LogFactory.getLog(ComponentExecutionScheduler.class).warn((Object)logMessage);
                logMessage = null;
                continue;
            }
            LogFactory.getLog(ComponentExecutionScheduler.class).error((Object)logMessage);
        }
        if (logMessage != null) {
            throw new ComponentExecutionException(logMessage);
        }
    }

    protected boolean isExecutable() {
        return this.constantInputsProcessed.size() < this.inputsCount && this.isExecutableWithAndCondition(this.requiredInputsOrGroups);
    }

    private boolean isExecutableWithAndCondition(Set<String> inputsOrGroupIds) {
        if (inputsOrGroupIds.isEmpty()) {
            return false;
        }
        for (String identifier : inputsOrGroupIds) {
            if (this.endpointGroupDescriptions.containsKey(identifier)) {
                if (this.checkGroupForExecutable(identifier)) continue;
                this.inputsWithValue.clear();
                return false;
            }
            if (this.endpointDatums.get(identifier).isEmpty() || this.allGroupInputsConstantAndSent(inputsOrGroupIds)) {
                this.inputsWithValue.clear();
                return false;
            }
            this.inputsWithValue.add(identifier);
        }
        return true;
    }

    private boolean allGroupInputsConstantAndSent(Set<String> inputsOrGroupIds) {
        for (String identifier : inputsOrGroupIds) {
            if (this.constantInputs.contains(identifier) && this.constantInputsProcessed.contains(identifier)) continue;
            return false;
        }
        return true;
    }

    private boolean isExecutableWithOrCondition(Set<String> inputsOrGroupIds) {
        for (String identifier : inputsOrGroupIds) {
            if (this.endpointGroupDescriptions.containsKey(identifier)) {
                if (!this.checkGroupForExecutable(identifier)) continue;
                return true;
            }
            if (this.endpointDatums.get(identifier).isEmpty() || this.constantInputs.contains(identifier) && this.constantInputsProcessed.contains(identifier)) continue;
            this.inputsWithValue.add(identifier);
            return true;
        }
        this.inputsWithValue.clear();
        return false;
    }

    private boolean checkGroupForExecutable(String groupName) {
        EndpointGroupDescription groupDescription = this.endpointGroupDescriptions.get(groupName);
        if (groupDescription.getEndpointGroupDefinition().getLogicOperation().equals((Object)EndpointGroupDefinition.LogicOperation.And)) {
            return this.isExecutableWithAndCondition(this.groups.get(groupName));
        }
        return this.isExecutableWithOrCondition(this.groups.get(groupName));
    }

    private State checkForNotAValueDatums() {
        State newState = State.PROCESS_INPUT_DATA;
        for (String inputIdentifier : this.endpointDatums.keySet()) {
            if (this.endpointDatums.get(inputIdentifier).isEmpty() || this.endpointDatums.get(inputIdentifier).getFirst().getValue().getDataType() != DataType.NotAValue) continue;
            newState = State.PROCESS_INPUT_DATA_WITH_NOT_A_VALUE_DATA;
            break;
        }
        return newState;
    }

    protected void bindTypedDatumService(TypedDatumService typedDatumService) {
        typedDatumFactory = typedDatumService.getFactory();
        typedDatumConverter = typedDatumService.getConverter();
    }

    protected static enum State {
        IDLING,
        PROCESS_INPUT_DATA,
        PROCESS_INPUT_DATA_WITH_NOT_A_VALUE_DATA,
        FINISHED,
        RESET,
        FAILURE_FORWARD,
        LOOP_RESET;

    }
}

