/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.api;

import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.execution.impl.ConsoleRowImpl;

public class ConsoleRowBuilder {
    private final int timestampOffset;
    private final ConsoleRowImpl consoleRow;

    public ConsoleRowBuilder() {
        this(0);
    }

    public ConsoleRowBuilder(int timestampOffset) {
        this.timestampOffset = timestampOffset;
        this.consoleRow = new ConsoleRowImpl();
    }

    public ConsoleRowBuilder setExecutionIdentifiers(String workflowExecutionIdentifier, String componentExecutionIdentifier) {
        this.consoleRow.setWorkflowIdentifier(workflowExecutionIdentifier);
        this.consoleRow.setComponentIdentifier(componentExecutionIdentifier);
        return this;
    }

    public ConsoleRowBuilder setInstanceNames(String workflowInstanceName, String componentInstanceName) {
        this.consoleRow.setWorkflowName(workflowInstanceName);
        this.consoleRow.setComponentName(componentInstanceName);
        return this;
    }

    public ConsoleRowBuilder setType(ConsoleRow.Type type) {
        this.consoleRow.setType(type);
        return this;
    }

    public ConsoleRowBuilder setPayload(String payload) {
        this.consoleRow.setPayload(payload);
        return this;
    }

    public ConsoleRowBuilder setSequenceNumber(long sequenceNumber) {
        this.consoleRow.setSequenceNumber(sequenceNumber);
        return this;
    }

    public ConsoleRowBuilder setComponentRun(int compRun) {
        this.consoleRow.setComponentRun(compRun);
        return this;
    }

    public ConsoleRow build() {
        this.consoleRow.setTimestamp(System.currentTimeMillis() + (long)this.timestampOffset);
        return this.consoleRow;
    }
}

